/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaNotFoundException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.history.NodeVersionHistoryListener;
import org.jahia.test.SurefireJUnitXMLResultFormatter;
import org.jahia.test.bin.BaseTestController;
import org.jahia.test.bin.TestBean;
import org.junit.internal.requests.FilterRequest;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServlet
extends BaseTestController {
    private static final Logger logger = LoggerFactory.getLogger(TestServlet.class);
    private static final String TEST_ERROR_MSG = "Error executing test";

    @Override
    protected void handleGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String pathInfo = StringUtils.substringAfter((String)httpServletRequest.getPathInfo(), (String)"/test");
        boolean isHtmlOutput = ".html".equals(pathInfo);
        if (StringUtils.isNotEmpty((String)pathInfo) && !pathInfo.contains("*") && !pathInfo.trim().equals("/") && !isHtmlOutput) {
            this.runIntegrationTests(httpServletRequest, httpServletResponse, pathInfo.substring(pathInfo.lastIndexOf(47) + 1));
        } else {
            Set<String> testCases = this.getAllTestCases(Boolean.valueOf(httpServletRequest.getParameter("skipCoreTests")));
            List<String> selectedTests = new LinkedList<String>();
            if (!isHtmlOutput && StringUtils.isNotEmpty((String)pathInfo) && !pathInfo.trim().equals("/")) {
                Pattern testNamePattern = Pattern.compile(pathInfo.length() > 1 && pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo);
                selectedTests = testCases.stream().filter(testCase -> testNamePattern.matcher((CharSequence)testCase).matches()).collect(Collectors.toList());
            } else {
                selectedTests.addAll(testCases);
            }
            if (Boolean.parseBoolean(httpServletRequest.getParameter("run"))) {
                this.runIntegrationTests(httpServletRequest, httpServletResponse, (String[])selectedTests.stream().toArray(String[]::new));
            } else if (isHtmlOutput) {
                this.outputHtml(selectedTests, httpServletRequest, httpServletResponse);
            } else {
                PrintWriter pw = httpServletResponse.getWriter();
                selectedTests.forEach(pw::println);
            }
        }
    }

    private void outputHtml(List<String> tests, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter pw = response.getWriter();
        pw.println("<!doctype html>");
        pw.println("");
        pw.println("<html lang=\"en\">");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        pw.print("<link rel=\"stylesheet\" href=\"");
        pw.print(request.getContextPath());
        pw.println("/modules/tools/css/tools.css\" type=\"text/css\" />");
        pw.println("<title>DX Tests</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>");
        pw.println(tests.size());
        pw.println(" tests found");
        pw.println("</h1>");
        pw.println("<ul>");
        for (String test : tests) {
            pw.print("<li><a href=\"");
            pw.print(request.getContextPath());
            pw.print("/cms/test/");
            pw.print(test);
            pw.print("\">");
            pw.print(test);
            pw.println("</a></li>");
        }
        pw.println("</ul>");
        pw.println("</body>");
    }

    private void runIntegrationTests(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String ... classNames) throws IOException {
        JUnitCore junitcore = new JUnitCore();
        Map<Class<?>, List<Class<?>>> testClassesPerSuites = this.getTestClassesPerSuites(classNames);
        SurefireJUnitXMLResultFormatter xmlResultFormatter = new SurefireJUnitXMLResultFormatter((OutputStream)httpServletResponse.getOutputStream());
        junitcore.addListener(xmlResultFormatter);
        ArrayList testClassesToRun = new ArrayList();
        for (Map.Entry<Class<?>, List<Class<?>>> testClassesPerSuite : testClassesPerSuites.entrySet()) {
            try {
                Class<?> suiteOrTestClass = testClassesPerSuite.getKey();
                List<Class<?>> testClasses = testClassesPerSuite.getValue();
                if (testClasses.isEmpty()) {
                    Description description = Description.createSuiteDescription(suiteOrTestClass);
                    xmlResultFormatter.testRunStarted(description);
                    xmlResultFormatter.testRunFinished(new Result());
                    continue;
                }
                testClassesToRun.addAll(testClasses);
            }
            catch (Exception e) {
                logger.error(TEST_ERROR_MSG, (Throwable)e);
            }
        }
        if (!testClassesToRun.isEmpty()) {
            final String methodName = httpServletRequest.getParameter("test");
            logger.info("Executing test classes {}", testClassesToRun.toArray());
            long start = System.currentTimeMillis();
            final Set<String> ignoreTests = this.getIgnoreTests();
            Runner runner = new FilterRequest(Request.classes(testClassesToRun.toArray(new Class[testClassesToRun.size()])), new Filter(){

                @Override
                public boolean shouldRun(Description description) {
                    return !ignoreTests.contains(description.getDisplayName()) && (methodName == null || description.getMethodName() == null || methodName.equalsIgnoreCase(description.getMethodName()));
                }

                @Override
                public String describe() {
                    return "Filter out Jahia configured methods";
                }
            }).getRunner();
            if (runner instanceof ErrorReportingRunner) {
                logger.warn("No tests remain after applying ignoreTests filter {} in {}", ignoreTests, (Object)testClassesToRun.toArray());
            } else {
                junitcore.run(runner);
                logger.info("Done executing test classes {} in {} ms", (Object)testClassesToRun.toArray(), (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    private Map<Class<?>, List<Class<?>>> getTestClassesPerSuites(String ... classNames) {
        HashMap testClassesPerSuites = new HashMap();
        for (String className : classNames) {
            try {
                Class<?> testClass;
                JahiaTemplatesPackage testPackage = this.findPackageForTestCase(className);
                Class<?> clazz = testClass = testPackage != null ? testPackage.getClassLoader().loadClass(className) : Class.forName(className);
                if (testClass == null) {
                    throw new JahiaNotFoundException("Couldn't find origin module for test " + className);
                }
                logger.info("Will use test class {}", (Object)testClass.getName());
                testClassesPerSuites.put(testClass, this.getTestClasses(testClass, new ArrayList()));
            }
            catch (Exception e) {
                logger.error("Error getting tests", (Throwable)e);
            }
        }
        return testClassesPerSuites;
    }

    private Set<String> getAllTestCases(boolean skipCore) {
        TreeSet<String> testCases = new TreeSet<String>();
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null) continue;
            Map packageTestBeans = aPackage.getContext().getBeansOfType(TestBean.class);
            for (TestBean testBean : packageTestBeans.values()) {
                if (skipCore && testBean.isCoreTests()) continue;
                testCases.addAll(testBean.getTestCases());
            }
        }
        return testCases;
    }

    private JahiaTemplatesPackage findPackageForTestCase(String testCase) {
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null) continue;
            Map packageTestBeans = aPackage.getContext().getBeansOfType(TestBean.class);
            for (TestBean testBean : packageTestBeans.values()) {
                for (String beanTestCase : testBean.getTestCases()) {
                    if (!beanTestCase.equals(testCase)) continue;
                    return aPackage;
                }
            }
        }
        return null;
    }

    private List<Class<?>> getTestClasses(Class<?> testClass, List<Class<?>> classes) {
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod("suite", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (suiteMethod != null) {
            try {
                classes = this.getTestClasses((Test)suiteMethod.invoke(null, (Object[])null), classes);
            }
            catch (Exception e) {
                logger.error("Error getting classes of suite", (Throwable)e);
            }
        } else {
            classes.add(testClass);
        }
        return classes;
    }

    private List<Class<?>> getTestClasses(Test test, List<Class<?>> classes) {
        if (test instanceof TestSuite) {
            HashSet tempClasses = new HashSet();
            Enumeration<Test> tests = ((TestSuite)test).tests();
            while (tests.hasMoreElements()) {
                Test currentTest = tests.nextElement();
                if (!(currentTest instanceof TestSuite) && tempClasses.contains(currentTest.getClass())) continue;
                classes = this.getTestClasses(currentTest, classes);
                tempClasses.add(currentTest.getClass());
            }
        } else {
            classes.add(test.getClass());
        }
        return classes;
    }

    private Set<String> getIgnoreTests() {
        HashSet<String> ignoreTests = new HashSet<String>();
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            Map packageTestBeans;
            if (aPackage.getContext() == null || (packageTestBeans = aPackage.getContext().getBeansOfType(TestBean.class)).size() <= 0) continue;
            for (TestBean testBean : packageTestBeans.values()) {
                if (testBean.getIgnoredTests() == null) continue;
                ignoreTests.addAll(testBean.getIgnoredTests());
            }
        }
        return ignoreTests;
    }

    static {
        NodeVersionHistoryListener.setDisabled((boolean)true);
    }
}

