/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleState;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.modulemanager.OperationResult;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.PomUtils;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.internal.AetherBasedResolver;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenConfigurationImpl;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import shaded.org.apache.maven.settings.Profile;
import shaded.org.apache.maven.settings.Repository;
import shaded.org.apache.maven.settings.RepositoryPolicy;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.ops4j.util.property.PropertiesPropertyResolver;
import shaded.org.ops4j.util.property.PropertyResolver;

public class ModuleTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(ModuleTestHelper.class);
    private static JahiaTemplateManagerService managerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
    private static ModuleManager moduleManager = ModuleUtils.getModuleManager();
    private static final MavenResolver resolver;

    public static File getModuleFromMaven(String groupId, String artifactId) throws IOException {
        return ModuleTestHelper.getModuleFromMaven(groupId, artifactId, null);
    }

    public static File getModuleFromMaven(String groupId, String artifactId, String version) throws IOException {
        return ModuleTestHelper.getArtifactFromMaven(groupId, artifactId, version, "jar");
    }

    public static File getArtifactFromMaven(String groupId, String artifactId, String version, String packaging) throws IOException {
        if (version == null || version.trim().isEmpty()) {
            version = "LATEST";
        }
        return resolver.resolve(groupId, artifactId, "", packaging, version);
    }

    private static Dependency getArtifactInfo(String artifactId) {
        try {
            Model model = PomUtils.read((InputStream)ModuleTestHelper.class.getClassLoader().getResourceAsStream("META-INF/maven/org.jahia.test/jahia-test-module/pom.xml"));
            for (Dependency dep : model.getDependencies()) {
                if (!artifactId.equals(dep.getArtifactId())) continue;
                return dep;
            }
        }
        catch (IOException | XmlPullParserException e) {
            logger.error("Unable to read module information from pom.xml file. Cause: " + e.getMessage(), e);
            throw new RuntimeException("Unable to read module information from pom.xml file. Cause: " + e.getMessage(), e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureModuleStarted(String artifactId) {
        JahiaTemplatesPackage pkg = managerService.getTemplatePackageById(artifactId);
        if (pkg != null) {
            ModuleState.State state = pkg.getState().getState();
            if (state == ModuleState.State.STARTED) return;
            if (state != ModuleState.State.INSTALLED && state != ModuleState.State.RESOLVED) throw new RuntimeException("Module " + artifactId + " is in the state " + state + " and cannot be started");
            moduleManager.start(pkg.getBundleKey(), null);
            return;
        }
        logger.info("Module {} is not deployed. Retrieving required version information from pom.xml file", (Object)artifactId);
        Dependency info = ModuleTestHelper.getArtifactInfo(artifactId);
        if (info == null) {
            logger.warn("Unable to find version information for module {} in the pom.xml of the jahia-test-module project", (Object)artifactId);
            info = new Dependency();
            info.setArtifactId(artifactId);
            info.setGroupId("org.jahia.modules");
        }
        logger.info("Resolved module artifact information: {}. Resolving corresponding Maven artifact", (Object)info);
        try {
            File moduleFile = ModuleTestHelper.getModuleFromMaven(info.getGroupId(), info.getArtifactId(), info.getVersion());
            logger.info("Module Maven artifact resolved to file: {}. Installing and starting module", (Object)moduleFile);
            OperationResult opResult = moduleManager.install((Resource)new FileSystemResource(moduleFile), null, true);
            logger.info("Module {} has been installed and started with status {}", (Object)artifactId, (Object)opResult);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to resolve maven artifact for module " + info);
        }
    }

    public static String ensurePrepackagedSiteExist(String prepackedZIPFile) {
        File prepackagedSiteFile;
        if (prepackedZIPFile == null) {
            return null;
        }
        File file = prepackagedSiteFile = prepackedZIPFile.startsWith("prepackagedSites/") ? new File(SettingsBean.getInstance().getJahiaVarDiskPath(), prepackedZIPFile) : new File(prepackedZIPFile);
        if (prepackagedSiteFile.exists()) {
            return prepackagedSiteFile.getAbsolutePath();
        }
        String bundleInfo = ModuleTestHelper.getPrepackagedSiteInBundle(prepackedZIPFile);
        if (bundleInfo != null) {
            return bundleInfo;
        }
        String artifactId = StringUtils.substringBefore((String)StringUtils.substringAfter((String)prepackedZIPFile, (String)"/"), (String)".zip");
        logger.info("Prepackaged site {} is not present. Retrieving required version information from pom.xml file", (Object)artifactId);
        Dependency info = ModuleTestHelper.getArtifactInfo(artifactId);
        if (info == null) {
            throw new RuntimeException("Unable to find version information for prepackaged site " + artifactId + " in the pom.xml of the jahia-test-module project");
        }
        logger.info("Resolved prepackaged site artifact information: {}. Resolving corresponding Maven artifact", (Object)info);
        try {
            File moduleFile = ModuleTestHelper.getArtifactFromMaven(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getType());
            logger.info("Module Maven artifact resolved to file: {}. Copying prepackaged site", (Object)moduleFile);
            FileUtils.copyFile((File)moduleFile, (File)prepackagedSiteFile);
            logger.info("Prepackaged site copied to {}", (Object)prepackagedSiteFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to resolve maven artifact for module " + info);
        }
        return prepackagedSiteFile.getAbsolutePath();
    }

    private static String getPrepackagedSiteInBundle(String prepackedZIPFile) {
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            URL url;
            Bundle bundle = aPackage.getBundle();
            if (bundle == null || (url = bundle.getEntry("META-INF/prepackagedSites/" + prepackedZIPFile)) == null) continue;
            return url + "#" + bundle.getSymbolicName();
        }
        return null;
    }

    static {
        Profile jahiaProfile = new Profile();
        jahiaProfile.setId("jahia-module-test");
        Repository jahia = new Repository();
        jahia.setId("jahia-public");
        jahia.setUrl("https://devtools.jahia.com/nexus/content/groups/public");
        jahiaProfile.addRepository(jahia);
        jahia = new Repository();
        jahia.setId("jahia-snapshots");
        jahia.setUrl("https://devtools.jahia.com/nexus/content/repositories/jahia-snapshots/");
        RepositoryPolicy snapshots = new RepositoryPolicy();
        snapshots.setEnabled(true);
        jahia.setSnapshots(snapshots);
        jahiaProfile.addRepository(jahia);
        jahia = new Repository();
        jahia.setId("jahia-internal");
        jahia.setUrl("https://devtools.jahia.com/nexus/content/groups/internal");
        jahiaProfile.addRepository(jahia);
        MavenConfigurationImpl configuration = new MavenConfigurationImpl((PropertyResolver)new PropertiesPropertyResolver(new Properties()), "org.ops4j.pax.url.mvn");
        Settings settings = configuration.getSettings();
        settings.addProfile(jahiaProfile);
        settings.addActiveProfile("jahia-module-test");
        resolver = new AetherBasedResolver((MavenConfiguration)configuration);
    }
}

