/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.bin.BaseTestController;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(JahiaTestCase.class);
    private static final String PORT = "9090";
    private static final String BASE_URL = "http://localhost:9090";
    private static boolean baseUrlForTestsLogged;
    private static SimpleCredentials rootUserCredentials;
    private CloseableHttpClient client;

    protected static final HttpServletRequest getRequest() {
        return BaseTestController.getThreadLocalRequest();
    }

    protected static final HttpServletResponse getResponse() {
        return BaseTestController.getThreadLocalResponse();
    }

    protected static final JahiaUser getUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    protected static final JCRUserNode getUserNode(JahiaUser admin) {
        return ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByPath(admin.getLocalPath());
    }

    protected static final SimpleCredentials getRootUserCredentials() {
        if (rootUserCredentials == null) {
            rootUserCredentials = new SimpleCredentials("root", "root1234".toCharArray());
        }
        return rootUserCredentials;
    }

    protected static void publishAll(String nodeIdentifier) throws RepositoryException {
        JCRPublicationService.getInstance().publishByMainId(nodeIdentifier);
    }

    protected static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    protected String getBaseServerURL() {
        String url;
        HttpServletRequest req = JahiaTestCase.getRequest();
        String string = url = req != null ? req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() : BASE_URL;
        if (!baseUrlForTestsLogged) {
            logger.info("Base URL for tests is: {}", (Object)url);
            baseUrlForTestsLogged = true;
        }
        return url;
    }

    protected String getAsText(String relativeUrl) {
        return this.getAsText(relativeUrl, 200);
    }

    protected String getAsText(String relativeUrl, int expectedResponseCode) {
        return this.getAsText(relativeUrl, null, expectedResponseCode, null);
    }

    protected String getAsText(String relativeUrl, Map<String, String> requestHeaders, int expectedResponseCode, Map<String, List<String>> collectedResponseHeaders) {
        return this.getAsText(relativeUrl, requestHeaders, expectedResponseCode, collectedResponseHeaders, new HttpClientContext());
    }

    protected String getAsText(String relativeUrl, Map<String, String> requestHeaders, int expectedResponseCode, Map<String, List<String>> collectedResponseHeaders, HttpClientContext context) {
        String body = "";
        HttpGet getMethod = this.createHttpGet(relativeUrl);
        if (requestHeaders != null && !requestHeaders.isEmpty()) {
            for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
                getMethod.addHeader(header.getKey(), (Object)header.getValue());
            }
        }
        try (CloseableHttpResponse response = this.getHttpClient().execute((ClassicHttpRequest)getMethod, (HttpContext)context);){
            Assert.assertEquals("Response code for URL " + relativeUrl + " is incorrect", expectedResponseCode, response.getCode());
            String string = body = response.getEntity() == null ? null : EntityUtils.toString((HttpEntity)response.getEntity());
            if (collectedResponseHeaders != null) {
                for (Header header : response.getHeaders()) {
                    String headerName = header.getName();
                    if (!collectedResponseHeaders.containsKey(headerName)) {
                        collectedResponseHeaders.put(headerName, new LinkedList());
                    }
                    collectedResponseHeaders.get(headerName).add(header.getValue());
                }
            }
        }
        catch (IOException | ParseException e) {
            logger.error(e.getMessage(), e);
        }
        return body;
    }

    protected HttpGet createHttpGet(String relativeUrl) {
        HttpGet getMethod = new HttpGet(this.getBaseServerURL() + Jahia.getContextPath() + relativeUrl);
        getMethod.addHeader("Origin", (Object)this.getBaseServerURL());
        return getMethod;
    }

    protected String getBaseServerURLPort() {
        HttpServletRequest req = JahiaTestCase.getRequest();
        return req != null ? String.valueOf(JahiaTestCase.getRequest().getServerPort()) : PORT;
    }

    protected CloseableHttpClient getHttpClient() {
        if (this.client == null) {
            this.client = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

                public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
                    URI uri = super.getLocationURI(request, response, context);
                    try {
                        return new URI(uri.toString().replace("%3Bjsessionid%3D", ";jsessionid="));
                    }
                    catch (URISyntaxException e) {
                        return uri;
                    }
                }
            }).build();
        }
        return this.client;
    }

    protected void login(String username, String password) throws IOException {
        int statusCode = this.post(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/login", {"username", username}, {"password", password}, {"restMode", "true"}).getStatusCode();
        Assert.assertEquals("Login failed for user", 200L, statusCode);
    }

    protected void loginRoot() throws IOException {
        this.login(JahiaTestCase.getRootUserCredentials().getUserID(), new String(JahiaTestCase.getRootUserCredentials().getPassword()));
    }

    protected void logout() throws IOException {
        PostResult post = this.post(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/logout", new String[][]{{"redirectActive", "false"}});
        if (post.getStatusCode() != 200) {
            logger.error("Method failed: {}", (Object)post.getStatusLine());
        }
    }

    protected PostResult post(String url, String[] ... params) throws IOException {
        String responseBody;
        String statusLine;
        int statusCode;
        HttpPost method = new HttpPost(url);
        method.addHeader("Origin", (Object)this.getBaseServerURL());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (String[] param : params) {
            nvps.add(new BasicNameValuePair(param[0], param[1]));
        }
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        try (CloseableHttpResponse response = this.getHttpClient().execute((ClassicHttpRequest)method);){
            statusCode = response.getCode();
            statusLine = response.getReasonPhrase();
            if (response.getCode() != 200) {
                logger.warn("Method failed: {} {}", (Object)response.getCode(), (Object)response.getReasonPhrase());
            }
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        return new PostResult(statusCode, statusLine, responseBody);
    }

    protected class PostResult {
        private int statusCode;
        private String statusLine;
        private String responseBody;

        PostResult(int statusCode, String statusLine, String responseBody) {
            this.statusCode = statusCode;
            this.statusLine = statusLine;
            this.responseBody = responseBody;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusLine() {
            return this.statusLine;
        }

        public String getResponseBody() {
            return this.responseBody;
        }
    }
}

