/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.xml;

import java.util.ArrayList;
import java.util.List;
import org.jahia.exceptions.JahiaException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser {
    private static final String ERROR_READING_FILE_MSG = "Error reading file";
    private static final String PARAMETER_TAG = "parameter";
    private static final String PARAMETER_TAG_NAME_ATTRIBUTE = "name";

    public static String getParameterValue(Node paramParent, String parameterName) throws JahiaException {
        if (!paramParent.hasChildNodes()) {
            throw new JahiaException("No parameters available on portlet XML tag", "Parent has no children at all", 3, 11);
        }
        for (Node curNode = paramParent.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            if (curNode.getNodeType() != 1 || !curNode.getNodeName().equalsIgnoreCase(PARAMETER_TAG)) continue;
            NamedNodeMap attr = curNode.getAttributes();
            Node paramAttrNode = attr.getNamedItem(PARAMETER_TAG_NAME_ATTRIBUTE);
            if (paramAttrNode != null) {
                if (!paramAttrNode.getNodeValue().equalsIgnoreCase(parameterName)) continue;
                Node textNode = curNode.getFirstChild();
                if (textNode == null) {
                    return "";
                }
                if (textNode.getNodeType() == 3) {
                    return textNode.getNodeValue();
                }
                throw new JahiaException(ERROR_READING_FILE_MSG, "Value of paramater is not in correct format, should only be text", 3, 11);
            }
            throw new JahiaException(ERROR_READING_FILE_MSG, "No attribute name found on parameter !", 3, 11);
        }
        return null;
    }

    public static Node nextChildOfTag(Node startNode, String tagName) throws JahiaException {
        List<Node> childs = XMLParser.getChildNodes(startNode, tagName);
        int size = childs.size();
        for (int i = 0; i < size; ++i) {
            Node child = childs.get(i);
            if (!child.getNodeName().equalsIgnoreCase(tagName)) continue;
            return child;
        }
        return null;
    }

    public static Node lastChildOfTag(Node parentNode, String tagName) throws JahiaException {
        int i = 0;
        List<Node> childs = XMLParser.getChildNodes(parentNode, tagName);
        int size = childs.size();
        if (i < size) {
            Node child = childs.get(i);
            if (child.getNodeName().equalsIgnoreCase(tagName) && i == size - 1) {
                return child;
            }
            return null;
        }
        return null;
    }

    public static List<Node> getChildNodes(Node parentNode, String tagName) throws JahiaException {
        ArrayList<Node> childs = new ArrayList<Node>();
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node nodeItem = null;
                nodeItem = nodeList.item(i);
                if (!nodeItem.getNodeName().equalsIgnoreCase(tagName)) continue;
                childs.add(nodeItem);
            }
        }
        return childs;
    }

    public static String getAttributeValue(Node parentNode, String attributeName) {
        NamedNodeMap attribs = parentNode.getAttributes();
        Node attribNode = attribs.getNamedItem(attributeName);
        if (attribNode != null) {
            return attribNode.getNodeValue();
        }
        return null;
    }

    public static void setAttribute(Element nodeItem, String attribName, String value) {
        if (value != null && value.length() > 0) {
            nodeItem.setAttribute(attribName, value);
        }
    }
}

