/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.ResourceBundles;

public final class Messages {
    private static final String MISSING_RESOURCE = "???";
    private static final Pattern RB_MACRO = Pattern.compile("##resourceBundle\\(([^\"#]*)\\)##");

    public static String format(String text, Object ... arguments) {
        return Messages.format(text, null, arguments);
    }

    public static String format(String text, Locale locale, Object ... arguments) {
        if (text == null || arguments == null || arguments.length == 0) {
            return text;
        }
        return locale != null ? new MessageFormat(StringUtils.replace((String)text, (String)"'", (String)"''"), locale).format(arguments) : MessageFormat.format(StringUtils.replace((String)text, (String)"'", (String)"''"), arguments);
    }

    public static String get(JahiaTemplatesPackage pkg, String key, Locale locale) {
        return ResourceBundles.get(pkg, locale).getString(key);
    }

    public static String get(JahiaTemplatesPackage pkg, String key, Locale locale, String defaultValue) {
        String message;
        try {
            message = ResourceBundles.get(pkg, locale).getString(key);
        }
        catch (MissingResourceException e) {
            message = defaultValue;
        }
        return message;
    }

    public static String get(ResourceBundle bundle, String key, String defaultValue) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public static String get(String primaryBundleName, JahiaTemplatesPackage pkg, String key, Locale locale) {
        return ResourceBundles.get(primaryBundleName, pkg, locale).getString(key);
    }

    public static String get(String primaryBundleName, JahiaTemplatesPackage pkg, String key, Locale locale, String defaultValue) {
        try {
            return Messages.get(primaryBundleName, pkg, key, locale);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public static String get(String bundle, String key, Locale locale) throws MissingResourceException {
        return ResourceBundles.get(bundle, locale).getString(key);
    }

    public static String get(String bundle, String key, Locale locale, String defaultValue) {
        try {
            return ResourceBundles.get(bundle, locale).getString(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public static String getInternal(String key, Locale locale) {
        return Messages.getNonEmpty("JahiaInternalResources", key, locale);
    }

    public static String getInternal(String key, Locale locale, String defaultValue) {
        return Messages.get("JahiaInternalResources", key, locale, defaultValue);
    }

    public static String getInternalWithArguments(String key, Locale locale, Object ... args) {
        return Messages.format(Messages.get("JahiaInternalResources", key, locale), locale, args);
    }

    public static String getInternalWithArguments(String key, String defaultValue, Locale locale, Object ... args) {
        return Messages.format(Messages.get("JahiaInternalResources", key, locale, defaultValue), locale, args);
    }

    public static String getNonEmpty(String bundle, String key, Locale locale) {
        String value = Messages.get(bundle, key, locale, null);
        return value != null ? value : MISSING_RESOURCE + key + MISSING_RESOURCE;
    }

    public static String getTypes(String key, Locale locale, String defaultValue) {
        return Messages.get("JahiaTypesResources", key, locale, defaultValue);
    }

    public static String getWithArgs(ResourceBundle bundle, String key, Object ... arguments) throws MissingResourceException {
        return Messages.format(bundle.getString(key), bundle.getLocale(), arguments);
    }

    public static String getWithArgs(ResourceBundle bundle, String key, String defaultValue, Object ... arguments) throws MissingResourceException {
        return Messages.format(Messages.get(bundle, key, defaultValue), bundle.getLocale(), arguments);
    }

    public static String getWithArgs(String bundle, String key, Locale locale, Object ... arguments) throws MissingResourceException {
        return Messages.getWithArgs(ResourceBundles.get(bundle, locale), key, arguments);
    }

    public static String interpolateResourceBundleMacro(String input, Locale locale, JahiaTemplatesPackage module) {
        String params;
        if (StringUtils.isEmpty((String)input)) {
            return input;
        }
        String result = input;
        Matcher m = RB_MACRO.matcher(input);
        if (m.matches() && StringUtils.isNotEmpty((String)(params = m.group(1)))) {
            String bundle = null;
            String key = null;
            if (params.indexOf(34) != -1) {
                params = Patterns.DOUBLE_QUOTE.matcher(params).replaceAll("");
            }
            if (params.indexOf(39) != -1) {
                params = Patterns.SINGLE_QUOTE.matcher(params).replaceAll("");
            }
            if (params.indexOf(44) != -1) {
                String[] paramArray = Patterns.COMMA.split(params);
                if (paramArray.length > 0) {
                    key = paramArray[0];
                    bundle = paramArray.length > 1 ? paramArray[1] : null;
                }
            } else {
                key = params;
            }
            if (StringUtils.isNotEmpty((String)key)) {
                String replacement = Messages.get(bundle, module, key, locale, key);
                result = StringUtils.replace((String)input, (String)m.group(), (String)replacement);
            }
        }
        return result;
    }

    private Messages() {
    }
}

