/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.util.Locale;
import org.springframework.core.NamedThreadLocal;

public abstract class JahiaLocaleContextHolder {
    private static final ThreadLocal<Locale> localeContextHolder = new NamedThreadLocal("Jahia user Locale context");

    private JahiaLocaleContextHolder() {
    }

    public static void resetLocale() {
        localeContextHolder.remove();
    }

    public static Locale getLocale() {
        Locale locale = localeContextHolder.get();
        return locale != null ? locale : Locale.getDefault();
    }

    public static void setLocale(Locale locale) {
        localeContextHolder.set(locale);
    }
}

