/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.scripting.bundle.BundleScriptEngineManager;

public class ScriptEngineUtils {
    private final BundleScriptEngineManager enginesManager = BundleScriptEngineManager.getInstance();

    public static boolean canFactoryForExtensionProcessViews(String extension, Dictionary<String, String> headers) {
        ScriptEngineFactory engineFactory = ScriptEngineUtils.getInstance().enginesManager.getFactoryForExtension(extension);
        return ScriptEngineUtils.canFactoryProcessViews(engineFactory, headers);
    }

    public static boolean canFactoryProcessViews(ScriptEngineFactory scriptFactory, Dictionary<String, String> headers) {
        if (scriptFactory == null) {
            throw new IllegalArgumentException("ScriptEngineFactory is null");
        }
        if (headers != null) {
            String hasViews = headers.get("Jahia-Module-Has-Views");
            if ("no".equalsIgnoreCase(StringUtils.trim((String)hasViews))) {
                return false;
            }
            String commaSeparatedScriptNames = headers.get("Jahia-Module-Scripting-Views");
            String[] split = StringUtils.split((String)commaSeparatedScriptNames, (char)',');
            if (split != null) {
                List<String> extensions = scriptFactory.getExtensions();
                ArrayList<String> scriptNames = new ArrayList<String>(split.length);
                for (String scriptName : split) {
                    String script = scriptName.trim().toLowerCase();
                    scriptNames.add(script);
                    if (!extensions.contains(script)) continue;
                    return true;
                }
                return scriptNames.contains(scriptFactory.getEngineName().trim().toLowerCase()) || scriptNames.contains(scriptFactory.getLanguageName().trim().toLowerCase());
            }
        }
        return false;
    }

    public static ScriptEngineUtils getInstance() {
        return Holder.INSTANCE;
    }

    private ScriptEngineUtils() {
        try {
            this.enginesManager.getEngineByExtension("groovy").eval("true");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
    }

    public ScriptEngine getEngineByName(String name) throws ScriptException {
        return this.getScriptEngineFrom(name, false);
    }

    public ScriptEngine scriptEngine(String extension) throws ScriptException {
        return this.getScriptEngineFrom(extension, true);
    }

    private ScriptEngine getScriptEngineFrom(String nameOrExtension, boolean fromExtension) throws ScriptException {
        ScriptEngine scriptEngine;
        ScriptEngine scriptEngine2 = scriptEngine = fromExtension ? this.enginesManager.getEngineByExtension(nameOrExtension) : this.enginesManager.getEngineByName(nameOrExtension);
        if (scriptEngine == null) {
            throw new ScriptException("Script engine not found for " + (fromExtension ? "extension: " : "name: ") + nameOrExtension);
        }
        this.initEngine(scriptEngine);
        return scriptEngine;
    }

    private void initEngine(ScriptEngine engine) {
        if (engine.getFactory().getNames().contains("velocity")) {
            Properties velocityProperties = new Properties();
            String key = "runtime.log.logsystem.log4j.logger";
            String log4jLoggerProp = System.getProperty("runtime.log.logsystem.log4j.logger");
            if (log4jLoggerProp != null) {
                velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", log4jLoggerProp);
            } else {
                velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", "root");
            }
            engine.getContext().setAttribute("com.sun.script.velocity.properties", velocityProperties, 200);
        }
    }

    private static class Holder {
        static final ScriptEngineUtils INSTANCE = new ScriptEngineUtils();

        private Holder() {
        }
    }
}

