/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.jahia.settings.SettingsBean;
import org.springframework.util.PropertyPlaceholderHelper;

public class PlaceholderUtils {
    private static final PropertyPlaceholderHelper PLACEHOLDER_HELPER_NON_STRICT = new PropertyPlaceholderHelper("${", "}", ":", true);
    public static final PropertyPlaceholderHelper PLACEHOLDER_HELPER_STRICT = new PropertyPlaceholderHelper("${", "}", ":", false);

    public static InputStream resolvePlaceholders(InputStream configInputStream, SettingsBean settingsBean, boolean ignoreUnresolvablePlaceholders) throws IOException {
        return IOUtils.toInputStream((String)PlaceholderUtils.resolvePlaceholders(IOUtils.toString((InputStream)configInputStream, (Charset)Charsets.UTF_8), settingsBean, ignoreUnresolvablePlaceholders), (Charset)Charsets.UTF_8);
    }

    public static String resolvePlaceholders(String text, SettingsBean settingsBean, boolean ignoreUnresolvablePlaceholders) {
        return (ignoreUnresolvablePlaceholders ? PLACEHOLDER_HELPER_NON_STRICT : PLACEHOLDER_HELPER_STRICT).replacePlaceholders(text, (PropertyPlaceholderHelper.PlaceholderResolver)new SettingsPlaceholderResolver(settingsBean, true));
    }

    private static class SettingsPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private boolean fallbackToSystemProperties;
        private SettingsBean settingsBean;

        SettingsPlaceholderResolver(SettingsBean settingsBean, boolean fallbackToSystemProperties) {
            this.settingsBean = settingsBean;
            this.fallbackToSystemProperties = fallbackToSystemProperties;
        }

        public String resolvePlaceholder(String placeholderName) {
            String value = this.settingsBean.getPropertiesFile().getProperty(placeholderName);
            if (value == null && this.fallbackToSystemProperties) {
                value = System.getProperty(placeholderName);
            }
            return value;
        }
    }
}

