/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeType;

public class NodeTypeTreeEntry
implements Comparable<NodeTypeTreeEntry> {
    private String label;
    private String name;
    private ExtendedNodeType nodeType;
    private Set<NodeTypeTreeEntry> children;

    public NodeTypeTreeEntry(ExtendedNodeType nodeType, Locale uiLocale) {
        this.nodeType = nodeType;
        this.name = nodeType.getName();
        this.label = nodeType.getLabel(uiLocale);
    }

    public Set<NodeTypeTreeEntry> getChildren() {
        return this.children;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setChildren(Set<NodeTypeTreeEntry> children) {
        this.children = children;
    }

    public void add(NodeTypeTreeEntry entry) {
        if (this.children == null) {
            this.children = new HashSet<NodeTypeTreeEntry>();
        }
        this.children.add(entry);
    }

    public ExtendedNodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public int compareTo(NodeTypeTreeEntry otherNodeTypeTreeEntry) {
        return StringUtils.compareIgnoreCase((String)this.getLabel(), (String)otherNodeTypeTreeEntry.getLabel());
    }
}

