/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;

public final class DateUtils {
    private static final Map<String, Integer> DAYS = new HashMap<String, Integer>(7);
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    public static final String DEFAULT_DATETIME_FORMAT = "dd.MM.yyyy HH:mm";

    public static String convertDayOfWeekToCron(Object dayOfWeek) {
        System.out.println("object" + dayOfWeek);
        return "test";
    }

    public static Calendar dayEnd() {
        return DateUtils.dayEnd(Calendar.getInstance());
    }

    public static Calendar dayEnd(Calendar date) {
        Calendar c = (Calendar)date.clone();
        c.set(11, c.getMaximum(11));
        c.set(12, c.getMaximum(12));
        c.set(13, c.getMaximum(13));
        c.set(14, c.getMaximum(14));
        return c;
    }

    public static Calendar dayStart() {
        return DateUtils.dayStart(Calendar.getInstance());
    }

    public static Calendar dayStart(Calendar date) {
        Calendar c = (Calendar)date.clone();
        c.set(11, c.getMinimum(11));
        c.set(12, c.getMinimum(12));
        c.set(13, c.getMinimum(13));
        c.set(14, c.getMinimum(14));
        return c;
    }

    public static Integer getDayOfWeek(String dayOfWeek) {
        return dayOfWeek != null ? DAYS.get(dayOfWeek.toLowerCase()) : null;
    }

    public static String getDayOfWeekEndCron(List<String> daysOfWeek) {
        return "59 59 23 ? * " + (daysOfWeek != null && !daysOfWeek.isEmpty() ? StringUtils.join(daysOfWeek, (char)',') : "*");
    }

    public static String getDayOfWeekStartCron(List<String> daysOfWeek) {
        return "1 0 0 ? * " + (daysOfWeek != null && !daysOfWeek.isEmpty() ? StringUtils.join(daysOfWeek, (char)',') : "*");
    }

    public static String formatDurationWords(long durationMillis) {
        if (durationMillis <= 1000L) {
            return durationMillis + " ms";
        }
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true) + " (" + durationMillis + " ms)";
    }

    private DateUtils() {
    }

    static {
        DAYS.put("monday", 2);
        DAYS.put("tuesday", 3);
        DAYS.put("wednesday", 4);
        DAYS.put("thursday", 5);
        DAYS.put("friday", 6);
        DAYS.put("saturday", 7);
        DAYS.put("sunday", 1);
        DAYS.put("mon", 2);
        DAYS.put("tue", 3);
        DAYS.put("wed", 4);
        DAYS.put("thu", 5);
        DAYS.put("fri", 6);
        DAYS.put("sat", 7);
        DAYS.put("sun", 1);
    }
}

