/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import groovy.lang.Closure;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.jahia.tools.patches.PatchExecutor;
import org.jahia.utils.ScriptEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyPatcher
implements PatchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GroovyPatcher.class);

    @Override
    public boolean canExecute(String name, String lifecyclePhase) {
        return name.endsWith(lifecyclePhase + ".groovy");
    }

    @Override
    public String executeScript(String name, String scriptContent) {
        final AtomicReference res = new AtomicReference();
        try {
            ScriptEngine engine = this.getEngine();
            SimpleScriptContext ctx = new SimpleScriptContext();
            ctx.setWriter(new StringWriter());
            Bindings bindings = engine.createBindings();
            bindings.put("log", (Object)logger);
            bindings.put("setResult", (Object)new Closure<Void>((Object)this){

                public Void call(Object ... args) {
                    res.set(args[0].toString());
                    return null;
                }
            });
            ctx.setBindings(bindings, 100);
            engine.eval(scriptContent, (ScriptContext)ctx);
            return res.get() == null ? ".installed" : (String)res.get();
        }
        catch (ScriptException e) {
            logger.error("Execution of script failed with error: {}", (Object)e.getMessage(), (Object)e);
            return res.get() == null ? ".failed" : (String)res.get();
        }
    }

    protected ScriptEngine getEngine() throws ScriptException {
        try {
            return ScriptEngineUtils.getInstance().scriptEngine("groovy");
        }
        catch (ScriptException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Script engine not found for extension")) {
                return null;
            }
            throw e;
        }
    }
}

