/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.files;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.tools.files.FileWatcherJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
extends Observable
implements Serializable {
    private static final long serialVersionUID = -5173318550711639571L;
    private static Logger logger = LoggerFactory.getLogger(FileWatcher.class);
    private String m_FolderPath = "";
    private File m_Folder;
    private long m_Interval;
    private String triggerName;
    private String jobName;
    private int maxJobNameLength = 50;
    private boolean m_FileOnly = true;
    private boolean recursive = false;
    private boolean m_IsDeamon = true;
    public boolean mCheckDate = false;
    private long lastCheckTime;
    private boolean removedFiles = false;
    private Collection<File> previousFiles;
    private List<String> ignoreFiles;
    private IOFileFilter ignoreFilter;

    public FileWatcher(String jobName, String fullFolderPath, boolean checkDate, long interval, boolean fileOnly) throws IOException {
        this(jobName, fullFolderPath, checkDate, interval, fileOnly, true, null);
    }

    public FileWatcher(String fullFolderPath, boolean checkDate, long interval, boolean fileOnly, SchedulerService schedulerService) throws IOException {
        this(fullFolderPath, checkDate, interval, fileOnly, true, null);
    }

    public FileWatcher(String fullFolderPath, boolean checkDate, long interval, boolean fileOnly, boolean isDeamon, SchedulerService schedulerService) throws IOException {
        this(null, fullFolderPath, checkDate, interval, fileOnly, isDeamon, schedulerService);
    }

    public FileWatcher(String jobName, String fullFolderPath, boolean checkDate, long interval, boolean fileOnly, boolean isDeamon, SchedulerService schedulerService) throws IOException {
        this.jobName = jobName;
        this.setFolderPath(fullFolderPath);
        this.setCheckDate(checkDate);
        this.setInterval(interval);
        this.setFileOnly(fileOnly);
        this.setDeamon(isDeamon);
    }

    public void start() throws IOException {
        this.initialize();
        logger.debug("Time created, Check Interval=" + this.getInterval() + " (millis) ");
        JobDetail jobDetail = new JobDetail(this.jobName, "DEFAULT", FileWatcherJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"fileWatcher", (Object)this);
        jobDetail.setJobDataMap(jobDataMap);
        SimpleTrigger trigger = new SimpleTrigger(this.jobName + "_Trigger", "DEFAULT", -1, this.m_Interval);
        trigger.setVolatility(true);
        this.triggerName = trigger.getName();
        jobDetail.setRequestsRecovery(false);
        jobDetail.setDurability(false);
        jobDetail.setVolatility(true);
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().deleteJob(this.jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            logger.warn("Unable to delete the job " + this.jobName + ". Cause: " + e.getMessage());
        }
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException je) {
            logger.error("Error while scheduling file watch for " + this.m_FolderPath, (Throwable)je);
        }
    }

    public void stop() {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().unscheduleJob(this.triggerName, "DEFAULT");
        }
        catch (SchedulerException e) {
            logger.warn("Unable to unschedule the job with trigger " + this.triggerName + ". Cause: " + e.getMessage());
        }
        try {
            ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().deleteJob(this.jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            logger.warn("Unable to delete the job " + this.jobName + ". Cause: " + e.getMessage());
        }
    }

    public long getInterval() {
        return this.m_Interval;
    }

    protected void setInterval(long interval) {
        this.m_Interval = interval;
    }

    public void externalSetChanged() {
        this.setChanged();
    }

    public String getFolderPath() {
        return this.m_FolderPath;
    }

    protected void setFolderPath(String fullFolderPath) {
        int jobNameLength;
        this.m_FolderPath = fullFolderPath;
        if (this.jobName == null) {
            this.jobName = this.m_FolderPath;
        }
        if ((jobNameLength = this.jobName.length()) > this.maxJobNameLength) {
            int jobNameHashCode = this.jobName.hashCode();
            String jobNameHashCodeStr = Integer.toString(jobNameHashCode);
            this.jobName = "..." + this.jobName.substring(jobNameLength - this.maxJobNameLength + 4 + jobNameHashCodeStr.length()) + jobNameHashCodeStr;
        }
    }

    public void setFileOnly(boolean fileOnly) {
        this.m_FileOnly = fileOnly;
    }

    public boolean getFileOnly() {
        return this.m_FileOnly;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean getCheckDate() {
        return this.mCheckDate;
    }

    public void setCheckDate(boolean checkDate) {
        this.mCheckDate = checkDate;
    }

    public boolean isDeamon() {
        return this.m_IsDeamon;
    }

    protected void setDeamon(boolean isDeamon) {
        this.m_IsDeamon = isDeamon;
    }

    public File getFolder() {
        return this.m_Folder;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public void setLastCheckTime(long lastCheckTime) {
        this.lastCheckTime = lastCheckTime;
    }

    public int getMaxJobNameLength() {
        return this.maxJobNameLength;
    }

    public void setMaxJobNameLength(int maxJobNameLength) {
        this.maxJobNameLength = maxJobNameLength;
    }

    public boolean getRemovedFiles() {
        return this.removedFiles;
    }

    public void setRemovedFiles(boolean removedFiles) {
        this.removedFiles = removedFiles;
    }

    public Collection<File> getPreviousFiles() {
        return this.previousFiles;
    }

    public void setPreviousFiles(Collection<File> previousFiles) {
        this.previousFiles = previousFiles;
    }

    public void setIgnoreFiles(List<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public IOFileFilter getIgnoreFilter() {
        if (this.ignoreFilter == null && this.ignoreFiles != null) {
            for (String fileName : this.ignoreFiles) {
                NotFileFilter f = new NotFileFilter((IOFileFilter)new NameFileFilter(fileName));
                if (this.ignoreFilter == null) {
                    this.ignoreFilter = f;
                    continue;
                }
                this.ignoreFilter = new AndFileFilter(this.ignoreFilter, (IOFileFilter)f);
            }
        }
        return this.ignoreFilter;
    }

    protected void initialize() throws IOException {
        logger.debug("Initializing file watcher");
        this.lastCheckTime = System.currentTimeMillis();
        logger.debug("Watching directory=" + this.getFolderPath());
        File tmpFile = new File(this.getFolderPath());
        if (tmpFile.isDirectory() && !tmpFile.canWrite()) {
            logger.debug("No write access to directory " + this.getFolderPath() + " tmpFile=" + tmpFile.toString());
        } else if (!tmpFile.exists()) {
            logger.debug("Directory " + tmpFile.toString() + " does not exist, creating...");
            tmpFile.mkdirs();
            logger.debug("Directory " + tmpFile.toString() + " created successfully.");
        }
        this.m_Folder = tmpFile;
        if (this.removedFiles) {
            IOFileFilter filter = this.getIgnoreFilter();
            if (filter == null) {
                filter = TrueFileFilter.INSTANCE;
            }
            this.previousFiles = this.m_FileOnly ? FileUtils.listFiles((File)this.m_Folder, (IOFileFilter)filter, (IOFileFilter)(this.recursive ? filter : FalseFileFilter.INSTANCE)) : FileUtils.listFilesAndDirs((File)this.m_Folder, (IOFileFilter)filter, (IOFileFilter)(this.recursive ? filter : FalseFileFilter.INSTANCE));
        }
    }
}

