/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom.email;

import java.util.Collection;
import javax.mail.Message;
import org.jahia.services.workflow.jbpm.custom.AbstractWorkItemHandler;
import org.jahia.services.workflow.jbpm.custom.email.JBPMMailProducer;
import org.jahia.services.workflow.jbpm.custom.email.JBPMMailSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class JBPMMailWorkItemHandler
extends AbstractWorkItemHandler
implements WorkItemHandler {
    private JBPMMailProducer mailProducer;
    private JBPMMailSession mailSession;

    public void setMailProducer(JBPMMailProducer mailProducer) {
        this.mailProducer = mailProducer;
    }

    public void setMailSession(JBPMMailSession mailSession) {
        this.mailSession = mailSession;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        if (this.mailSession.isEnabled()) {
            Collection<Message> messages = this.mailProducer.produce(workItem);
            this.mailSession.send(messages);
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

