/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jahia.pipelines.Pipeline;
import org.jahia.pipelines.PipelineException;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.workflow.WorkflowVariable;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.wih.LocalHTWorkItemHandler;
import org.jbpm.services.task.wih.util.HumanTaskHandlerHelper;
import org.jbpm.services.task.wih.util.PeopleAssignmentHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaLocalHTWorkItemHandler
extends LocalHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(JahiaLocalHTWorkItemHandler.class);
    private Pipeline peopleAssignmentPipeline = null;

    public void setPeopleAssignmentPipeline(Pipeline peopleAssignmentPipeline) {
        this.peopleAssignmentPipeline = peopleAssignmentPipeline;
    }

    protected Task createTaskBasedOnWorkItemParams(KieSession session, WorkItem workItem) {
        String createdBy;
        String comment;
        TaskImpl task = new TaskImpl();
        String taskName = (String)workItem.getParameter("NodeName");
        if (taskName != null) {
            ArrayList<I18NTextImpl> names = new ArrayList<I18NTextImpl>();
            names.add(new I18NTextImpl("en", taskName));
            task.setNames(names);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Create workflow task [%s]", taskName));
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        ArrayList<I18NTextImpl> descriptions = new ArrayList<I18NTextImpl>();
        descriptions.add(new I18NTextImpl("en", comment));
        task.setDescriptions(descriptions);
        ArrayList<I18NTextImpl> subjects = new ArrayList<I18NTextImpl>();
        subjects.add(new I18NTextImpl("en", comment));
        task.setSubjects(subjects);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskDataImpl taskData = new TaskDataImpl();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
            taskData.setProcessId(session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
            String deploymentId = (String)session.getEnvironment().get("deploymentId");
            taskData.setDeploymentId(deploymentId);
        }
        taskData.setProcessSessionId(session.getId());
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId.longValue());
        }
        if ((createdBy = (String)workItem.getParameter("CreatedBy")) != null && createdBy.trim().length() > 0) {
            taskData.setCreatedBy((User)new UserImpl(createdBy));
        } else if (JCRSessionFactory.getInstance().getCurrentUser() != null) {
            taskData.setCreatedBy((User)new UserImpl(JCRSessionFactory.getInstance().getCurrentUser().getUserKey()));
        }
        taskData.setCreatedOn(new Date());
        WorkflowVariable dueDate = (WorkflowVariable)workItem.getParameter("dueDate");
        if (dueDate != null) {
            taskData.setExpirationTime(dueDate.getValueAsDate());
        }
        PeopleAssignmentHelper peopleAssignmentHelper = new PeopleAssignmentHelper();
        peopleAssignmentHelper.handlePeopleAssignments(workItem, (InternalTask)task, (InternalTaskData)taskData);
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        task.setTaskData((TaskData)taskData);
        task.setDeadlines(HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)businessAdministrators, (Environment)session.getEnvironment()));
        PeopleAssignmentContext peopleAssignmentContext = new PeopleAssignmentContext((Task)task, workItem, session);
        try {
            this.peopleAssignmentPipeline.invoke(peopleAssignmentContext);
        }
        catch (PipelineException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return task;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        RuntimeEngine runtime = this.getRuntimeManager().getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
        Task task = runtime.getTaskService().getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                runtime.getTaskService().exit(task.getId().longValue(), "/users/root");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }

    public class PeopleAssignmentContext {
        private Task task;
        private WorkItem workItem;
        private KieSession kieSession;

        public PeopleAssignmentContext(Task task, WorkItem workItem, KieSession kieSession) {
            this.task = task;
            this.workItem = workItem;
            this.kieSession = kieSession;
        }

        public Task getTask() {
            return this.task;
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }

        public KieSession getKieSession() {
            return this.kieSession;
        }
    }
}

