/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom;

import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.jbpm.custom.AbstractWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class CustomUnlockWorkItemHandler
extends AbstractWorkItemHandler
implements WorkItemHandler {
    private void doUnlock(String id, JCRSessionWrapper session, String key, String type) throws RepositoryException {
        try {
            JCRNodeWrapper node = session.getNodeByUUID(id);
            if (node.isLocked()) {
                try {
                    node.unlock(type, " " + key + " ");
                }
                catch (LockException lockException) {}
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void executeWorkItem(final WorkItem workItem, WorkItemManager manager) {
        final List uuids = (List)workItem.getParameter("nodeIds");
        String workspace = (String)workItem.getParameter("workspace");
        String userKey = (String)workItem.getParameter("user");
        JCRUserNode user = JahiaUserManagerService.getInstance().lookupUserByPath(userKey);
        JahiaUser jahiaUser = null;
        if (user != null) {
            jahiaUser = user.getJahiaUser();
        }
        final String type = (String)workItem.getParameter("type");
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(jahiaUser, workspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (String id : uuids) {
                        CustomUnlockWorkItemHandler.this.doUnlock(id, session, "process-" + workItem.getProcessInstanceId(), type);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

