/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.jahia.services.workflow.jbpm.custom.email.AddressTemplate;
import org.jahia.services.workflow.jbpm.custom.email.MailTemplate;
import org.jahia.services.workflow.jbpm.custom.email.MailTemplateRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class JBPMModuleProcessLoader
implements InitializingBean,
DisposableBean {
    private static final List<String> FIELDS = Arrays.asList("from", "to", "cc", "bcc", "from-users", "to-users", "cc-users", "bcc-users", "from-groups", "to-groups", "cc-groups", "bcc-groups", "subject", "text", "html", "language");
    private static transient Logger logger = LoggerFactory.getLogger(JBPMModuleProcessLoader.class);
    private Resource[] processes;
    private Resource[] mailTemplates;
    private MailTemplateRegistry mailTemplateRegistry;
    private JBPM6WorkflowProvider jbpm6WorkflowProvider;

    public void setJbpm6WorkflowProvider(JBPM6WorkflowProvider jbpm6WorkflowProvider) {
        this.jbpm6WorkflowProvider = jbpm6WorkflowProvider;
    }

    public void setMailTemplateRegistry(MailTemplateRegistry mailTemplateRegistry) {
        this.mailTemplateRegistry = mailTemplateRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        this.deployDeclaredProcesses();
    }

    public void destroy() throws Exception {
        this.undeployDeclaredProcesses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployDeclaredProcesses() throws IOException {
        if (this.processes != null && this.processes.length > 0) {
            logger.info("Found {} workflow processes to be deployed.", (Object)this.processes.length);
            for (Resource process : this.processes) {
                String fileName = process.getFilename();
                logger.info("Found workflow process " + fileName + ". Updating...");
                this.jbpm6WorkflowProvider.addResource(process);
                logger.info("... done");
            }
            logger.info("...workflow processes deployed.");
            if (this.jbpm6WorkflowProvider.isInitialized()) {
                this.jbpm6WorkflowProvider.recompilePackages();
            }
        }
        if (this.mailTemplates != null && this.mailTemplates.length > 0) {
            logger.info("Found {} workflow mail templates to be deployed.", (Object)this.mailTemplates.length);
            for (Resource mailTemplateResource : this.mailTemplates) {
                MailTemplate mailTemplate = new MailTemplate();
                mailTemplate.setLanguage("velocity");
                mailTemplate.setFrom(new AddressTemplate());
                mailTemplate.setTo(new AddressTemplate());
                mailTemplate.setCc(new AddressTemplate());
                mailTemplate.setBcc(new AddressTemplate());
                int currentField = -1;
                StringBuilder buf = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(mailTemplateResource.getInputStream(), "UTF-8"));
                try {
                    String currentLine;
                    while ((currentLine = reader.readLine()) != null) {
                        if (currentLine.contains(":")) {
                            String prefix = StringUtils.substringBefore((String)currentLine, (String)":").toLowerCase();
                            if (FIELDS.contains(prefix)) {
                                JBPMModuleProcessLoader.setMailTemplateField(mailTemplate, currentField, buf);
                                buf = new StringBuilder();
                                currentField = FIELDS.indexOf(prefix);
                                currentLine = StringUtils.substringAfter((String)currentLine, (String)":").trim();
                            }
                        } else {
                            buf.append('\n');
                        }
                        buf.append(currentLine);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
                JBPMModuleProcessLoader.setMailTemplateField(mailTemplate, currentField, buf);
                this.mailTemplateRegistry.addTemplate(StringUtils.substringBeforeLast((String)mailTemplateResource.getFilename(), (String)"."), mailTemplate);
            }
        }
    }

    public static void setMailTemplateField(MailTemplate t, int currentField, StringBuilder buf) {
        switch (currentField) {
            case 0: {
                t.getFrom().setAddresses(buf.toString());
                break;
            }
            case 1: {
                t.getTo().setAddresses(buf.toString());
                break;
            }
            case 2: {
                t.getCc().setAddresses(buf.toString());
                break;
            }
            case 3: {
                t.getBcc().setAddresses(buf.toString());
                break;
            }
            case 4: {
                t.getFrom().setUsers(buf.toString());
                break;
            }
            case 5: {
                t.getTo().setUsers(buf.toString());
                break;
            }
            case 6: {
                t.getCc().setUsers(buf.toString());
                break;
            }
            case 7: {
                t.getBcc().setUsers(buf.toString());
                break;
            }
            case 8: {
                t.getFrom().setGroups(buf.toString());
                break;
            }
            case 9: {
                t.getTo().setGroups(buf.toString());
                break;
            }
            case 10: {
                t.getCc().setGroups(buf.toString());
                break;
            }
            case 11: {
                t.getBcc().setGroups(buf.toString());
                break;
            }
            case 12: {
                t.setSubject(buf.toString());
                break;
            }
            case 13: {
                t.setText(buf.toString());
                break;
            }
            case 14: {
                t.setHtml(buf.toString());
                break;
            }
            case 15: {
                t.setLanguage(buf.toString());
            }
        }
    }

    private void undeployDeclaredProcesses() throws IOException {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        if (this.processes != null && this.processes.length > 0) {
            logger.info("Found {} workflow processes to be undeployed.", (Object)this.processes.length);
            for (Resource process : this.processes) {
                String fileName = process.getFilename();
                logger.info("Undeploy workflow process " + fileName + ". Updating...");
                this.jbpm6WorkflowProvider.removeResource(process);
                logger.info("... done");
            }
            logger.info("...workflow processes undeployed.");
            if (JahiaContextLoaderListener.isContextInitialized()) {
                this.jbpm6WorkflowProvider.recompilePackages();
            }
        }
        if (this.mailTemplates != null && this.mailTemplates.length > 0) {
            logger.info("Found {} workflow mail templates to be undeployed.", (Object)this.mailTemplates.length);
            for (Resource mailTemplateResource : this.mailTemplates) {
                this.mailTemplateRegistry.removeTemplate(StringUtils.substringBeforeLast((String)mailTemplateResource.getFilename(), (String)"."));
            }
        }
    }

    public void setProcesses(Resource[] processes) {
        this.processes = processes;
    }

    public void setMailTemplates(Resource[] mailTemplates) {
        this.mailTemplates = mailTemplates;
    }
}

