/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean;

import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Visibility {
    private static final Logger logger = LoggerFactory.getLogger(Visibility.class);
    private String permission;
    private String needAuthentication;
    private String userAgent;
    private String value;
    private String contextNodePath;
    private String inNodePath;
    private String operatingMode;
    private boolean needsMavenExecutable;

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getNeedAuthentication() {
        return this.needAuthentication;
    }

    public void setNeedAuthentication(String needAuthentication) {
        this.needAuthentication = needAuthentication;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getContextNodePath() {
        return this.contextNodePath;
    }

    public void setContextNodePath(String contextNodePath) {
        this.contextNodePath = contextNodePath;
    }

    public String getInNodePath() {
        return this.inNodePath;
    }

    public void setInNodePath(String inNodePath) {
        this.inNodePath = inNodePath;
    }

    public void setNeedsMavenExecutable(boolean needsMavenExecutable) {
        this.needsMavenExecutable = needsMavenExecutable;
    }

    public void setOperatingMode(String operatingMode) {
        this.operatingMode = operatingMode;
    }

    public boolean getRealValue(JCRNodeWrapper contextNode, JahiaUser jahiaUser, Locale locale, HttpServletRequest request) {
        if (this.value != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Value: " + this.value);
            }
            return Boolean.getBoolean(this.value);
        }
        try {
            boolean isLogged = this.isLogged(jahiaUser);
            if (!isLogged) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Logging: false");
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Logging: true");
            }
            if (this.inNodePath != null && !contextNode.getPath().startsWith(this.inNodePath)) {
                return false;
            }
            if (!this.isAllowed(contextNode)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SitePermission: false");
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SitePermission: true");
            }
            if (!this.isAllowedUserAgent(request)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("UserAgent: false");
                }
                return false;
            }
            if (!this.isAllowedOperatingMode()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("OperatingMode: false");
                }
                return false;
            }
            if (!this.isAllowedMavenExecutable()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("MavenExecutable: false");
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("UserAgent: true");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Permissions: true");
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Error in getRealValue", (Throwable)e);
            return true;
        }
    }

    private boolean isAllowed(JCRNodeWrapper node) {
        try {
            if (this.permission != null && !node.getUser().isRoot()) {
                if ("$currentsite".equals(this.contextNodePath)) {
                    node = node.getResolveSite();
                } else {
                    if ("$anysite".equals(this.contextNodePath)) {
                        JCRNodeWrapper sitesPath = node.getSession().getNode("/sites");
                        List<JCRNodeWrapper> l = JCRContentUtils.getChildrenOfType(sitesPath, "jnt:virtualsite");
                        for (JCRNodeWrapper nodeWrapper : l) {
                            if (!nodeWrapper.hasPermission(this.permission)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (this.contextNodePath != null && !this.contextNodePath.startsWith("/")) {
                        node = node.getNode(this.contextNodePath);
                    } else if (this.contextNodePath != null) {
                        node = node.getSession().getNode(this.contextNodePath);
                    }
                }
                return node.hasPermission(this.permission);
            }
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            logger.error("Cannot check permission " + this.permission, (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isLogged(JahiaUser jahiaUser) {
        if (this.needAuthentication != null && Boolean.parseBoolean(this.needAuthentication)) {
            return jahiaUser != null && !jahiaUser.getUsername().equalsIgnoreCase("guest");
        }
        return true;
    }

    private boolean isAllowedUserAgent(HttpServletRequest request) {
        if (this.userAgent != null) {
            boolean matches = false;
            String thisUserAgent = this.resolveUserAgent(request);
            if (thisUserAgent != null) {
                if ("ie".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("MSIE") != -1;
                } else if ("ie6".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("MSIE 6") != -1;
                } else if ("ie7".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("MSIE 7") != -1;
                } else if ("ns".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("Mozilla") != -1 && this.userAgent.indexOf("MSIE") == -1;
                } else if ("ns4".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("Mozilla/4") != -1 && this.userAgent.indexOf("MSIE") == -1;
                } else if ("ns6".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("Mozilla/5") != -1;
                } else if ("opera".equals(this.userAgent)) {
                    matches = thisUserAgent.indexOf("opera") != -1;
                }
            } else {
                return false;
            }
            return matches;
        }
        return true;
    }

    private boolean isAllowedOperatingMode() {
        return this.operatingMode == null || this.operatingMode.contains("development") && SettingsBean.getInstance().isDevelopmentMode() || this.operatingMode.contains("production") && SettingsBean.getInstance().isProductionMode() && !SettingsBean.getInstance().isDistantPublicationServerMode() || this.operatingMode.contains("distantPublicationServer") && SettingsBean.getInstance().isDistantPublicationServerMode();
    }

    private boolean isAllowedMavenExecutable() {
        return !this.needsMavenExecutable || SettingsBean.getInstance().isMavenExecutableSet();
    }

    private String resolveUserAgent(HttpServletRequest request) {
        String reqUserAgent = "";
        Enumeration userAgentValues = request.getHeaders("user-agent");
        if (userAgentValues.hasMoreElements()) {
            reqUserAgent = (String)userAgentValues.nextElement();
        }
        return reqUserAgent;
    }
}

