/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.search.AbstractHit;

public class SearchURLService {
    private static volatile SearchURLService instance;

    private SearchURLService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchURLService getInstance() {
        if (instance != null) return instance;
        Class<SearchURLService> clazz = SearchURLService.class;
        synchronized (SearchURLService.class) {
            if (instance != null) return instance;
            instance = new SearchURLService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addURLQueryParameter(AbstractHit<?> searchHit, String parameterName, String parameterValue) {
        searchHit.setQueryParameter(this.appendParams(searchHit.getQueryParameter(), parameterName + "=" + this.encode(parameterValue)));
    }

    public void updateHitLinkTemplateType(AbstractHit<?> searchHit, String templateType) {
        searchHit.setLinkTemplateType(templateType);
    }

    private String encode(String parameterValue) {
        String value;
        try {
            value = URLEncoder.encode(parameterValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return value;
    }

    protected String appendParams(String queryParam, String newParams) {
        if (!StringUtils.isEmpty((String)newParams)) {
            if (queryParam == null) {
                queryParam = "";
            }
            if (queryParam.indexOf("?") == -1) {
                if (newParams.startsWith("&")) {
                    newParams = "?" + newParams.substring(1, newParams.length());
                } else if (!newParams.startsWith("?") && !newParams.startsWith("/")) {
                    newParams = "?" + newParams;
                }
            } else if (!newParams.startsWith("&") && !newParams.startsWith("/")) {
                newParams = "&" + newParams;
            }
            queryParam = queryParam + newParams;
        }
        return queryParam;
    }
}

