/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.search.SearchServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class SearchSettingsListener
extends DefaultEventListener
implements ExternalEventListener,
ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(SearchSettingsListener.class);
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public int getEventTypes() {
        return 28;
    }

    @Override
    public String getPath() {
        return "/settings/search-settings";
    }

    public void onEvent(EventIterator events) {
        boolean external = false;
        while (events.hasNext()) {
            if (!this.isExternal(events.nextEvent())) continue;
            external = true;
            break;
        }
        if (!external) {
            return;
        }
        logger.info("Event received about changes in search server settings. Notifying search service...");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SearchServiceImpl.SearchSettingsChangedEvent(this));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

