/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.rules.RulesListener;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.Hit;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchProvider;
import org.jahia.services.search.SearchResponse;
import org.jahia.services.search.SearchService;
import org.jahia.services.search.SearchSettings;
import org.jahia.services.search.SearchURLService;
import org.jahia.services.search.SearchUtils;
import org.jahia.services.search.Suggestion;
import org.jahia.services.search.exception.InvalidSearchProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class SearchServiceImpl
extends SearchService
implements InitializingBean,
ApplicationListener<ApplicationEvent> {
    private List<SearchProvider> availableSearchProviders = new ArrayList<SearchProvider>();
    private SearchProvider selectedSearchProvider;
    private SearchProvider defaultSearchProvider;
    private static Logger logger = LoggerFactory.getLogger(SearchServiceImpl.class);
    private SearchSettings settings;

    public SearchSettings getSettings() {
        return this.settings;
    }

    public static SearchServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    private SearchServiceImpl() {
    }

    @Override
    public SearchResponse search(SearchCriteria criteria, RenderContext context) {
        SearchResponse response = SearchUtils.getStoredSearchResponse(criteria, context.getRequest());
        if (response == null) {
            response = this.getCurrentProvider().search(criteria, context);
            SearchUtils.storeSearchResponse(criteria, response, context.getRequest());
        }
        return response;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    @Override
    public Suggestion suggest(SearchCriteria originalQuery, RenderContext context, int maxTermsToSuggest) {
        if (this.getCurrentProvider() instanceof SearchProvider.SupportsSuggestion) {
            return ((SearchProvider.SupportsSuggestion)((Object)this.getCurrentProvider())).suggest(originalQuery, context, maxTermsToSuggest);
        }
        return this.getCurrentProvider().suggest(originalQuery.getTerms().get(0).getTerm(), context, maxTermsToSuggest);
    }

    @Override
    public Suggestion suggest(String originalQuery, RenderContext context, int maxTermsToSuggest) {
        SearchCriteria sc = new SearchCriteria();
        sc.setTerm(originalQuery);
        SearchCriteria.CommaSeparatedMultipleValue value = new SearchCriteria.CommaSeparatedMultipleValue();
        value.setValue(context.getSite().getSiteKey());
        sc.setSites(value);
        return this.suggest(sc, context, maxTermsToSuggest);
    }

    public static void executeURLModificationRules(List<? extends Hit> searchHits, RenderContext context) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("renderContext", context);
        globals.put("urlService", SearchURLService.getInstance());
        RulesListener.getInstance(context.getMainResource().getWorkspace()).executeRules(searchHits, globals);
    }

    public static void executeURLModificationRules(Hit<?> searchHit, RenderContext context) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("renderContext", context);
        globals.put("urlService", SearchURLService.getInstance());
        RulesListener.getInstance(context.getMainResource().getWorkspace()).executeRules(searchHit, globals);
    }

    public SearchProvider getCurrentProvider() {
        return this.selectedSearchProvider != null ? this.selectedSearchProvider : this.defaultSearchProvider;
    }

    protected SearchProvider getProvider(String name) {
        if (this.defaultSearchProvider != null && this.defaultSearchProvider.getName().equals(name)) {
            return this.defaultSearchProvider;
        }
        if (this.availableSearchProviders != null) {
            for (SearchProvider searchProvider : this.availableSearchProviders) {
                if (!searchProvider.getName().equals(name)) continue;
                return searchProvider;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerSearchProvider(SearchProvider searchProvider) throws InvalidSearchProviderException {
        if (searchProvider == null || !StringUtils.isNotEmpty((String)searchProvider.getName())) throw new InvalidSearchProviderException("Search provider need to be not null and named");
        if (this.getProvider(searchProvider.getName()) != null) throw new InvalidSearchProviderException("Unable to register search provider with the name \"" + searchProvider.getName() + "\", search provider with this name already exist");
        this.availableSearchProviders.add(searchProvider);
        if (!searchProvider.getName().equals(this.settings.getCurrentProvider())) return;
        this.selectedSearchProvider = searchProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterSearchProvider(SearchProvider searchProvider) throws InvalidSearchProviderException {
        if (searchProvider == null || !StringUtils.isNotEmpty((String)searchProvider.getName())) throw new InvalidSearchProviderException("Search provider need to be not null and named");
        SearchProvider retrievedSearchProvider = this.getProvider(searchProvider.getName());
        if (retrievedSearchProvider == null) throw new InvalidSearchProviderException("Unable to unregistered Search provider with the name \"" + searchProvider.getName() + "\", no search provider found");
        if (this.selectedSearchProvider != null && this.selectedSearchProvider.getName().equals(retrievedSearchProvider.getName())) {
            this.selectedSearchProvider = this.defaultSearchProvider;
        }
        this.availableSearchProviders.remove(retrievedSearchProvider);
    }

    public List<String> getAvailableProviders() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.defaultSearchProvider.getName());
        for (SearchProvider searchProvider : this.availableSearchProviders) {
            result.add(searchProvider.getName());
        }
        return result;
    }

    private boolean selectSearchProvider(String name) {
        SearchProvider searchProvider;
        if (StringUtils.isNotEmpty((String)name) && (searchProvider = this.getProvider(name)) != null) {
            this.selectedSearchProvider = searchProvider;
            return true;
        }
        return false;
    }

    protected void load() {
        this.settings = new SearchSettings();
        try {
            this.settings = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "default", null, new JCRCallback<SearchSettings>(){

                @Override
                public SearchSettings doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    SearchSettings cfg = new SearchSettings();
                    JCRNodeWrapper searchSettingNode = null;
                    try {
                        searchSettingNode = session.getNode("/settings/search-settings");
                        cfg.setCurrentProvider(searchSettingNode.hasProperty("j:provider") ? searchSettingNode.getProperty("j:provider").getString() : null);
                        if (cfg.getCurrentProvider() != null && !cfg.getCurrentProvider().equals(SearchServiceImpl.this.settings.getCurrentProvider())) {
                            SearchServiceImpl.this.selectSearchProvider(cfg.getCurrentProvider());
                        }
                    }
                    catch (PathNotFoundException e) {
                        cfg.setCurrentProvider(SearchServiceImpl.this.getDefaultSearchProvider().getName());
                        SearchServiceImpl.this.store(cfg, session);
                    }
                    return cfg;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error reading search settings from the repository.", (Throwable)e);
        }
    }

    public void store(final SearchSettings cfg) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    SearchServiceImpl.this.store(cfg, session);
                    return Boolean.TRUE;
                }
            });
            this.load();
        }
        catch (RepositoryException e) {
            logger.error("Error storing search settings into the repository.", (Throwable)e);
        }
    }

    protected void store(SearchSettings cfg, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper searchSettingNode = null;
        try {
            searchSettingNode = session.getNode("/settings/search-settings");
        }
        catch (PathNotFoundException e) {
            searchSettingNode = session.nodeExists("/settings") ? session.getNode("/settings").addNode("search-settings", "jnt:searchServerSettings") : session.getNode("/").addNode("settings", "jnt:globalSettings").addNode("search-settings", "jnt:searchServerSettings");
            searchSettingNode.setAclInheritanceBreak(true);
        }
        if (this.selectSearchProvider(cfg.getCurrentProvider())) {
            searchSettingNode.setProperty("j:provider", cfg.getCurrentProvider());
            session.save();
        }
    }

    public void onApplicationEvent(ApplicationEvent evt) {
        if (evt instanceof JahiaContextLoaderListener.RootContextInitializedEvent || evt instanceof SearchSettingsChangedEvent) {
            this.load();
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setDefaultSearchProvider(SearchProvider defaultSearchProvider) {
        this.defaultSearchProvider = defaultSearchProvider;
    }

    protected SearchProvider getDefaultSearchProvider() {
        return this.defaultSearchProvider;
    }

    public static class SearchSettingsChangedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -2547399042743406556L;

        public SearchSettingsChangedEvent(Object source) {
            super(source);
        }
    }

    private static class Holder {
        static final SearchServiceImpl INSTANCE = new SearchServiceImpl();

        private Holder() {
        }
    }
}

