/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Date;
import org.jahia.services.scheduler.SchedulerService;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.listeners.SchedulerListenerSupport;

class JahiaSchedulerListener
extends SchedulerListenerSupport {
    private Scheduler scheduler;

    public JahiaSchedulerListener(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void jobAdded(JobDetail jobDetail) {
        boolean doUpdate = false;
        if (!jobDetail.getJobDataMap().containsKey((Object)"created")) {
            jobDetail.getJobDataMap().put((Object)"created", (Object)new Date());
            doUpdate = true;
        }
        if (!jobDetail.getJobDataMap().containsKey((Object)"status")) {
            jobDetail.getJobDataMap().put("status", "added");
            doUpdate = true;
        }
        if (doUpdate) {
            try {
                this.scheduler.addJob(jobDetail, true);
            }
            catch (SchedulerException e) {
                SchedulerService.logger.warn("Unable to update status for job " + jobDetail.getFullName() + ". Cause: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void jobScheduled(Trigger trigger) {
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(trigger.getJobName(), trigger.getJobGroup());
            if (jobDetail != null && !"scheduled".equals(jobDetail.getJobDataMap().getString("status"))) {
                jobDetail.getJobDataMap().put("status", "scheduled");
                this.scheduler.addJob(jobDetail, true);
            }
        }
        catch (SchedulerException e) {
            SchedulerService.logger.warn("Unable to update job status for trigger " + trigger.getFullName() + ". Cause: " + e.getMessage(), (Throwable)e);
        }
    }
}

