/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.mvc.view.FlowViewResolver;

class BundleFlowViewResolver
implements FlowViewResolver {
    BundleFlowViewResolver() {
    }

    public View resolveView(String viewId, RequestContext context) {
        if (viewId.startsWith("/")) {
            return this.getViewInternal(viewId, context, context.getActiveFlow().getApplicationContext());
        }
        ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
        if (flowContext == null) {
            throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
        }
        Resource viewResource = flowContext.getResource(viewId);
        if (!(viewResource instanceof ContextResource)) {
            throw new IllegalStateException("A ContextResource is required to get relative view paths within this context");
        }
        return this.getViewInternal(((ContextResource)viewResource).getPathWithinContext(), context, flowContext);
    }

    public String getViewIdByConvention(String viewStateId) {
        return viewStateId + ".jsp";
    }

    private View getViewInternal(String viewPath, RequestContext context, ApplicationContext flowContext) {
        if (viewPath.endsWith(".jsp") || viewPath.endsWith(".jspx")) {
            InternalResourceView view = new InternalResourceView(viewPath);
            view.setApplicationContext(flowContext);
            return view;
        }
        throw new IllegalArgumentException("Unsupported view type " + viewPath + " only types supported by this FlowViewResolver implementation are [.jsp] and [.jspx]");
    }
}

