/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.scripting.Script;
import org.jahia.utils.i18n.ResourceBundles;

public class TemplateAttributesFilter
extends AbstractFilter {
    public static final String FORCED_LOCALE_ATTRIBUTE = "org.jahia.utils.i18n.forceLocale";
    public static final String AREA_RESOURCE = "areaResource";

    @Override
    public String prepare(RenderContext context, Resource resource, RenderChain chain) throws Exception {
        JCRSiteNode site = context.getSite();
        JahiaTemplatesPackage templatePackage = site.getTemplatePackage();
        if (templatePackage == null) {
            throw new ItemNotFoundException("Couldn't find the template associated with site " + site.getName() + ". Please check that all its dependencies are started.");
        }
        JCRNodeWrapper node = resource.getNode();
        HttpServletRequest request = context.getRequest();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Serializable> moduleParams = resource.getModuleParams();
        for (Map.Entry<String, Serializable> entry : moduleParams.entrySet()) {
            String string = entry.getKey();
            params.put(string, entry.getValue());
        }
        ExtendedNodeType cache = NodeTypeRegistry.getInstance().getNodeType("jmix:cache");
        this.overrideProperties(node, params, moduleParams, cache);
        for (Map.Entry entry : params.entrySet()) {
            chain.pushAttribute(request, (String)entry.getKey(), entry.getValue());
        }
        Script script = (Script)request.getAttribute("script");
        Locale locale2 = (Locale)request.getAttribute(FORCED_LOCALE_ATTRIBUTE);
        locale2 = locale2 != null ? locale2 : resource.getLocale();
        chain.pushAttribute(context.getRequest(), "javax.servlet.jsp.jstl.fmt.localizationContext.request", new LocalizationContext(ResourceBundles.get(templatePackage.getResourceBundleName(), script.getView().getModule(), locale2), locale2));
        String areaResourcePath = (String)request.getAttribute("org.jahia.savedAreaPath");
        if (areaResourcePath != null && !context.isContributionMode()) {
            chain.pushAttribute(request, AREA_RESOURCE, resource.getNode().getSession().getNode(areaResourcePath));
        }
        return null;
    }

    private void overrideProperties(JCRNodeWrapper node, Map<String, Object> params, Map<String, Serializable> moduleParams, ExtendedNodeType mixin) throws RepositoryException {
        Map<String, ExtendedPropertyDefinition> props = mixin.getDeclaredPropertyDefinitionsAsMap();
        for (String key : props.keySet()) {
            this.overrideProperties(node, params, moduleParams, key);
        }
    }

    private void overrideProperties(JCRNodeWrapper node, Map<String, Object> params, Map<String, Serializable> moduleParams, String key) throws RepositoryException {
        if (!key.equals("*")) {
            String pkey = StringUtils.substringAfter((String)key, (String)":");
            if (!moduleParams.containsKey("forced" + StringUtils.capitalize((String)pkey))) {
                if (node.hasProperty(key)) {
                    params.put(pkey, node.getProperty(key).getString());
                } else {
                    params.put(pkey, null);
                }
            }
        }
    }
}

