/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.jahia.services.query.ScrollableQueryCallback;

public class ScrollableQuery {
    private long step = 100L;
    private long maxIteration = -1L;
    private Query query;

    public ScrollableQuery(long step, Query query) {
        this.step = step;
        this.query = query;
    }

    public ScrollableQuery(long step, long maxIteration, Query query) {
        this.step = step;
        this.maxIteration = maxIteration;
        this.query = query;
    }

    public <T> T execute(ScrollableQueryCallback<T> callback) throws RepositoryException {
        this.query.setLimit(this.step);
        callback.setStepResult(this.query.execute());
        long _step = 0L;
        long count = 0L;
        while (callback.scroll()) {
            this.query.setLimit(this.step);
            this.query.setOffset(_step += this.step);
            QueryResult queryResult = this.query.execute();
            callback.setStepResult(queryResult);
            if (this.maxIteration == ++count) break;
            if (queryResult.getNodes().getSize() >= this.step) continue;
            callback.scroll();
            break;
        }
        return callback.getResult();
    }
}

