/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.pwd.PasswordService;
import org.jahia.services.pwdpolicy.EvaluationContext;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRuleParam;
import org.jahia.services.pwdpolicy.PasswordHistoryEntry;
import org.jahia.services.pwdpolicy.PasswordPolicyRuleCondition;

public final class RuleConditions {
    public static final long MILLISECONDS_PER_DAY = 86400000L;

    private static void checkParameterCount(List<JahiaPasswordPolicyRuleParam> parameters, int requiredParameterCount) {
        if (parameters.size() < requiredParameterCount) {
            throw new IllegalArgumentException("Found " + parameters.size() + " parameter, whereas " + requiredParameterCount + " are expected");
        }
    }

    private static long getLastPasswordChangeTimestamp(JCRUserNode user) {
        long lastChangeTimestamp = 0L;
        lastChangeTimestamp = user.getLastPasswordChangeTimestamp();
        return lastChangeTimestamp;
    }

    private static JahiaPasswordPolicyRuleParam getParameter(List<JahiaPasswordPolicyRuleParam> parameters, int position) {
        RuleConditions.checkParameterCount(parameters, position + 1);
        return parameters.get(position);
    }

    private static int getParameterIntValue(List<JahiaPasswordPolicyRuleParam> parameters, int position) {
        JahiaPasswordPolicyRuleParam param = RuleConditions.getParameter(parameters, position);
        return StringUtils.isNumeric((String)param.getValue()) ? Integer.parseInt(param.getValue()) : 0;
    }

    public static class SimilarToUsername
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            if (ctx.getPassword() == null || ctx.getUsername() == null) {
                throw new IllegalArgumentException("Either of the required values is null: password or username");
            }
            return ctx.getPassword().toLowerCase().indexOf(ctx.getUsername().toLowerCase()) == -1;
        }
    }

    public static class PreventUserInitiatedPasswordChange
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            if (!ctx.isUserInitiated()) {
                return true;
            }
            if (ctx.getUser() == null) {
                throw new IllegalArgumentException("The user object is null. Unable to evaluate the condition");
            }
            return ctx.getUser().isRoot();
        }
    }

    public static class PasswordHistory
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            if (ctx.getPassword() == null || ctx.getUser() == null) {
                return true;
            }
            boolean success = true;
            int checkedPasswordCount = RuleConditions.getParameterIntValue(parameters, 0);
            List<PasswordHistoryEntry> history = ctx.getUser().getPasswordHistory();
            if (!history.isEmpty()) {
                PasswordService pwdService = PasswordService.getInstance();
                for (int i = 0; i < checkedPasswordCount && i < history.size(); ++i) {
                    if (!pwdService.matches(ctx.getPassword(), history.get(i).getPassword())) continue;
                    success = false;
                    break;
                }
            }
            return success;
        }
    }

    public static class MinOccurrenceDigits
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            int requiredCount = RuleConditions.getParameterIntValue(parameters, 0);
            if (requiredCount <= 0) {
                return true;
            }
            int foundCharCount = 0;
            for (int i = 0; i < ctx.getPassword().length(); ++i) {
                if (Character.isDigit(ctx.getPassword().charAt(i))) {
                    ++foundCharCount;
                }
                if (foundCharCount >= requiredCount) break;
            }
            return foundCharCount >= requiredCount;
        }
    }

    public static class MinOccurrence
    implements PasswordPolicyRuleCondition {
        protected static boolean checkMinOccurrence(String password, int requiredCount, String setOfCharacts) {
            int foundCharCount = 0;
            for (int i = 0; i < password.length(); ++i) {
                if (setOfCharacts.indexOf(password.charAt(i)) != -1) {
                    ++foundCharCount;
                }
                if (foundCharCount >= requiredCount) break;
            }
            return foundCharCount >= requiredCount;
        }

        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            int requiredCount = RuleConditions.getParameterIntValue(parameters, 0);
            if (requiredCount <= 0) {
                return true;
            }
            String setOfCharacts = RuleConditions.getParameter(parameters, 1).getValue();
            return MinOccurrence.checkMinOccurrence(ctx.getPassword(), requiredCount, setOfCharacts);
        }
    }

    public static class MinimumLength
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            return ctx.getPassword().length() >= RuleConditions.getParameterIntValue(parameters, 0);
        }
    }

    public static class MaximumLength
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            return ctx.getPassword().length() <= RuleConditions.getParameterIntValue(parameters, 0);
        }
    }

    public static class FirstLoginEvaluator
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            if (ctx.getUser() == null) {
                throw new IllegalArgumentException("The user object is null. Unable to evaluate the condition");
            }
            try {
                return ctx.getUser().hasProperty("lastLoginDate");
            }
            catch (RepositoryException e) {
                return false;
            }
        }
    }

    public static class ExpiresSoon
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            if (ctx.getUser() == null) {
                throw new IllegalArgumentException("The user object is null. Unable to evaluate the condition");
            }
            boolean success = true;
            int ageDays = RuleConditions.getParameterIntValue(parameters, 0);
            int maxDays = RuleConditions.getParameterIntValue(parameters, 1);
            long lastChangeTimestamp = RuleConditions.getLastPasswordChangeTimestamp(ctx.getUser());
            if (lastChangeTimestamp > 0L) {
                success = System.currentTimeMillis() - lastChangeTimestamp <= (long)ageDays * 86400000L || System.currentTimeMillis() - lastChangeTimestamp > (long)maxDays * 86400000L;
            }
            return success;
        }
    }

    public static class ExpirationPeriodReached
    implements PasswordPolicyRuleCondition {
        @Override
        public boolean evaluate(List<JahiaPasswordPolicyRuleParam> parameters, EvaluationContext ctx) {
            if (ctx.getUser() == null) {
                throw new IllegalArgumentException("The user object is null. Unable to evaluate the condition");
            }
            boolean success = true;
            int expPeriod = RuleConditions.getParameterIntValue(parameters, 0);
            long lastChangeTimestamp = RuleConditions.getLastPasswordChangeTimestamp(ctx.getUser());
            if (lastChangeTimestamp > 0L) {
                success = System.currentTimeMillis() - lastChangeTimestamp <= (long)expPeriod * 86400000L;
            }
            return success;
        }
    }
}

