/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jahia.engines.EngineMessages;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRule;
import org.jahia.services.pwdpolicy.PolicyEnforcementResultConvertor;

public class PolicyEnforcementResult {
    static final PolicyEnforcementResult SUCCESS = new PolicyEnforcementResult();
    private List<JahiaPasswordPolicyRule> invalidationRules = Collections.emptyList();
    private List<JahiaPasswordPolicyRule> violatedRules = Collections.emptyList();
    private List<JahiaPasswordPolicyRule> warningRules = Collections.emptyList();

    private PolicyEnforcementResult() {
    }

    public PolicyEnforcementResult(List<JahiaPasswordPolicyRule> violatedRules) {
        this();
        this.violatedRules = violatedRules;
        this.buildResult();
    }

    private void buildResult() {
        if (this.violatedRules.size() > 0) {
            this.invalidationRules = new LinkedList<JahiaPasswordPolicyRule>();
            this.warningRules = new LinkedList<JahiaPasswordPolicyRule>();
            for (JahiaPasswordPolicyRule rule : this.violatedRules) {
                if ('P' == rule.getAction()) {
                    this.invalidationRules.add(rule);
                    continue;
                }
                if ('W' == rule.getAction()) {
                    this.warningRules.add(rule);
                    continue;
                }
                throw new IllegalArgumentException("Unknown action type: " + rule.getAction());
            }
        }
    }

    public EngineMessages getEngineMessages() {
        return PolicyEnforcementResultConvertor.toEngineMessages(this);
    }

    public List<String> getTextMessages() {
        return PolicyEnforcementResultConvertor.toText(this);
    }

    public List<JahiaPasswordPolicyRule> getInvalidationRules() {
        return this.invalidationRules;
    }

    public List<JahiaPasswordPolicyRule> getViolatedRules() {
        return this.violatedRules;
    }

    public List<JahiaPasswordPolicyRule> getWarningRules() {
        return this.warningRules;
    }

    public boolean isPasswordInvalidationRequired() {
        return this.invalidationRules.size() > 0;
    }

    public boolean isSuccess() {
        return this.violatedRules.size() == 0;
    }

    public boolean isWarningRequired() {
        return this.warningRules.size() > 0;
    }
}

