/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRule;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRuleParam;

public class JahiaPasswordPolicy
implements Serializable {
    private static final long serialVersionUID = 7340082798180832549L;
    private String id;
    private String name;
    private List<JahiaPasswordPolicyRule> rules = new LinkedList<JahiaPasswordPolicyRule>();

    public JahiaPasswordPolicy() {
    }

    public JahiaPasswordPolicy(String id, String name, boolean userAllowedToChangePassword) {
        this.id = id;
        this.name = name;
    }

    public JahiaPasswordPolicy(JahiaPasswordPolicy policy) {
        this.id = policy.id;
        this.name = policy.name;
        this.rules = policy.rules == null ? null : (List)policy.rules.stream().map(rule -> new JahiaPasswordPolicyRule((JahiaPasswordPolicyRule)rule)).collect(Collectors.toCollection(LinkedList::new));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public JahiaPasswordPolicyRule getRule(int position) {
        return this.rules.get(position);
    }

    public List<JahiaPasswordPolicyRule> getRules() {
        return this.rules;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRules(List<JahiaPasswordPolicyRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            JahiaPasswordPolicyRuleParam castOther = (JahiaPasswordPolicyRuleParam)obj;
            return new EqualsBuilder().append((Object)this.getId(), (Object)castOther.getId()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("rules", this.rules).toString();
    }
}

