/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.preferences.generic;

import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJahiaPreference
extends JCRNodeDecorator {
    private static final Logger logger = LoggerFactory.getLogger(GenericJahiaPreference.class);

    public GenericJahiaPreference(JCRNodeWrapper node) {
        super(node);
    }

    public String getPrefName() throws RepositoryException {
        return this.getProperty("j:prefName").getString();
    }

    public void setPrefName(String prefName) throws RepositoryException {
        this.setProperty("j:prefName", prefName);
    }

    public String getPrefValue() throws RepositoryException {
        if (this.hasProperty("j:prefValue")) {
            return this.getProperty("j:prefValue").getString();
        }
        return null;
    }

    public void setPrefValue(String prefValue) throws RepositoryException {
        this.setProperty("j:prefValue", prefValue);
    }

    public boolean isEmpty() {
        try {
            return !this.hasProperty("j:prefValue") || this.getPrefValue() == null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        try {
            return super.toString() + " ,[prefName=" + this.getPrefName() + ",prefValue" + this.getPrefValue() + "]";
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return super.toString();
        }
    }
}

