/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.notification.CamelNotificationService;

@Plugin(name="CamelAppender", category="Core", elementType="appender", printObject=true)
public class CamelAppender
extends AbstractAppender {
    private CamelNotificationService camelNotificationService;
    private String targetUri;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private CamelAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        CamelNotificationService notificationService = this.getNotificationService();
        if (notificationService != null) {
            notificationService.queueMessagesWithBodyAndHeaders(this.targetUri, this.getLayout().toSerializable(event), null);
        }
    }

    public void close() {
    }

    private CamelNotificationService getNotificationService() {
        SpringContextSingleton springCtx;
        if (this.camelNotificationService == null && (springCtx = SpringContextSingleton.getInstance()).isInitialized()) {
            this.camelNotificationService = (CamelNotificationService)springCtx.getContext().getBean("camelNotificationService");
        }
        return this.camelNotificationService;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<CamelAppender> {
        @PluginAttribute(value="targetUri", defaultString="direct:logs")
        private String targetUri;

        public CamelAppender build() {
            Layout layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for CamelAppender");
                return null;
            }
            CamelAppender appender = new CamelAppender(this.getName(), layout, this.getFilter(), this.isIgnoreExceptions());
            appender.setTargetUri(this.targetUri);
            return appender;
        }
    }
}

