/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.mail;

import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.mail.MailServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class MailSettingsListener
extends DefaultEventListener
implements ExternalEventListener,
ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(MailSettingsListener.class);
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public int getEventTypes() {
        return 28;
    }

    @Override
    public String[] getNodeTypes() {
        return new String[]{"jnt:mailServerSettings"};
    }

    @Override
    public String getPath() {
        return "/settings/mail-server";
    }

    public void onEvent(EventIterator events) {
        boolean external = false;
        while (events.hasNext()) {
            if (!this.isExternal(events.nextEvent())) continue;
            external = true;
            break;
        }
        if (!external) {
            return;
        }
        logger.info("Event received about changes in mail server connection settings. Notifying mail service...");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new MailServiceImpl.MailSettingsChangedEvent(this));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

