/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.jahia.services.importexport.validation.ValidationResult;

public class ValidationResults
implements Serializable {
    private static final long serialVersionUID = -7969446907569423334L;
    private List<ValidationResult> results = new LinkedList<ValidationResult>();
    private Map<String, ValidationResult> resultsByClassName;

    protected ValidationResult getResultByClassName(String clazz) {
        return this.getResultsByClassName().get(clazz);
    }

    public List<ValidationResult> getResults() {
        return this.results;
    }

    public void addResult(ValidationResult result) {
        this.results.add(result);
    }

    protected Map<String, ValidationResult> getResultsByClassName() {
        if (this.resultsByClassName == null) {
            this.resultsByClassName = LazyMap.decorate(new HashMap(0), (Transformer)new Transformer(){

                public Object transform(Object clazz) {
                    for (ValidationResult result : ValidationResults.this.results) {
                        if (!clazz.equals(result.getClass().getName())) continue;
                        return result;
                    }
                    return null;
                }
            });
        }
        return this.resultsByClassName;
    }

    public boolean isSuccessful() {
        for (ValidationResult result : this.results) {
            if (result.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public boolean isBlocking() {
        for (ValidationResult result : this.results) {
            if (result.isSuccessful() || !result.isBlocking()) continue;
            return true;
        }
        return false;
    }

    public ValidationResults merge(ValidationResults toBeMergedWith) {
        ValidationResults merged = new ValidationResults();
        HashSet<String> typesMerged = new HashSet<String>();
        for (ValidationResult thisResult : this.results) {
            String clazz = thisResult.getClass().getName();
            typesMerged.add(clazz);
            ValidationResult other = toBeMergedWith.getResultByClassName(clazz);
            merged.addResult(other != null ? thisResult.merge(other) : thisResult);
        }
        for (ValidationResult otherResult : toBeMergedWith.getResults()) {
            if (typesMerged.contains(otherResult.getClass().getName())) continue;
            merged.addResult(otherResult);
        }
        return merged;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        boolean successful = this.isSuccessful();
        out.append("[overall result=").append(successful ? "successful" : "failure");
        if (!successful) {
            out.append(", details=[");
            boolean first = true;
            for (ValidationResult result : this.results) {
                if (!first) {
                    out.append(", ");
                } else {
                    first = false;
                }
                out.append(result);
            }
            out.append("]");
        }
        out.append("]");
        return out.toString();
    }
}

