/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.services.importexport.BaseDocumentViewHandler;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.ModuleDependencyAware;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.importexport.validation.ValidationResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocumentViewValidationHandler
extends BaseDocumentViewHandler
implements ModuleDependencyAware {
    private static final Logger logger = LoggerFactory.getLogger(DocumentViewValidationHandler.class);
    private List<String> modules = Collections.emptyList();
    private String templateSetName;
    private List<ImportValidator> validators = Collections.emptyList();

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.validators.isEmpty()) {
            return;
        }
        this.pathes.pop();
    }

    public ValidationResults getResults() {
        ValidationResults results = new ValidationResults();
        for (ImportValidator validator : this.validators) {
            ValidationResult result = validator.getResult();
            if (result != null && !result.isSuccessful()) {
                logger.warn("Import validation fail: " + result.toString());
            }
            results.addResult(result);
        }
        return results;
    }

    @Override
    public void initDependencies(String templateSetName, List<String> modules) {
        this.templateSetName = templateSetName;
        this.modules = modules != null ? modules : Collections.emptyList();
        this.initValidators();
    }

    private void initValidators() {
        if (!this.validators.isEmpty() && this.templateSetName != null) {
            for (ImportValidator validator : this.validators) {
                if (!(validator instanceof ModuleDependencyAware)) continue;
                ((ModuleDependencyAware)((Object)validator)).initDependencies(this.templateSetName, this.modules);
            }
        }
    }

    public void setValidators(List<ImportValidator> validators) {
        if (validators != null) {
            this.validators = validators;
        } else {
            validators = Collections.emptyList();
        }
        this.initValidators();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.validators.isEmpty()) {
            return;
        }
        try {
            String decodedLocalName = ISO9075.decode((String)localName);
            String decodedQName = qName.replace(localName, decodedLocalName);
            this.pathes.push((String)this.pathes.peek() + "/" + decodedQName);
            for (ImportValidator validator : this.validators) {
                validator.validate(decodedLocalName, decodedQName, (String)this.pathes.peek(), atts);
            }
        }
        catch (Exception re) {
            throw new SAXException(re);
        }
    }
}

