/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.importexport.DefinitionsMapping;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.LegacyImportHandler;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.ResourceBundleMarker;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FilesAclImportHandler
extends DefaultHandler {
    private static Logger logger = LoggerFactory.getLogger(FilesAclImportHandler.class);
    private static Logger corruptedFilesLogger = LoggerFactory.getLogger((String)(FilesAclImportHandler.class.getName() + ".CorruptedFiles"));
    private Resource archive;
    private NoCloseZipInputStream zis;
    private ZipEntry nextEntry;
    private List<String> fileList = new ArrayList<String>();
    private Map<String, File> filePath = new HashMap<String, File>();
    private JahiaSite site;
    private DefinitionsMapping mapping;
    private JCRSessionWrapper session;
    private Map<String, String> davPropertiesMapping = this.initializeDavPropertiesMapping();
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMAT_Z = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");

    public FilesAclImportHandler(JahiaSite site, DefinitionsMapping mapping, Resource archive, List<String> fileList, Map<String, File> filePath) {
        this.site = site;
        this.mapping = mapping;
        this.archive = archive;
        this.fileList = fileList;
        this.filePath = filePath;
        try {
            this.session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("file".equals(localName) && "http://www.jahia.org/".equals(uri)) {
            InputStream content;
            block43: {
                boolean contentFound;
                String acl;
                String path;
                block42: {
                    path = attributes.getValue("http://www.jahia.org/", "path");
                    acl = attributes.getValue("http://www.jahia.org/", "fileacl");
                    content = null;
                    contentFound = false;
                    if (this.filePath != null) {
                        content = this.findExtractedContent(path);
                    } else {
                        contentFound = this.findContent(path);
                    }
                    if (path.startsWith("/shared") || path.startsWith("/users")) {
                        path = "/sites/" + this.site.getSiteKey() + "/files" + path;
                    }
                    if (!this.session.itemExists(path)) break block42;
                    IOUtils.closeQuietly((InputStream)content);
                    return;
                }
                try {
                    boolean isCorruptedFile;
                    JCRNodeWrapper f;
                    path = JCRContentUtils.escapeNodePath(path);
                    path = Patterns.COLON.matcher(path).replaceAll("_");
                    String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                    try {
                        f = this.session.getNode(parentPath);
                    }
                    catch (PathNotFoundException e) {
                        f = ImportExportBaseService.getInstance().ensureDir(this.session, parentPath, this.site);
                    }
                    GregorianCalendar created = new GregorianCalendar();
                    String creationDate = attributes.getValue("dav:creationdate");
                    if (creationDate != null) {
                        if (creationDate.endsWith("Z")) {
                            created.setTime(DATE_FORMAT_Z.parseDateTime(creationDate).toDate());
                        } else {
                            created.setTime(DATE_FORMAT.parseDateTime(creationDate).toDate());
                        }
                    }
                    GregorianCalendar lastModified = new GregorianCalendar();
                    String modificationDate = attributes.getValue("dav:modificationdate");
                    if (modificationDate != null) {
                        if (modificationDate.endsWith("Z")) {
                            lastModified.setTime(DATE_FORMAT_Z.parseDateTime(modificationDate).toDate());
                        } else {
                            lastModified.setTime(DATE_FORMAT.parseDateTime(modificationDate).toDate());
                        }
                    }
                    String createdBy = attributes.getValue("dav:creationuser");
                    String lastModifiedBy = attributes.getValue("dav:modificationuser");
                    String itemType = "file".equals(attributes.getValue("jahia:itemType")) || StringUtils.isNotBlank((String)attributes.getValue("dav:getcontenttype")) ? "file" : "folder";
                    boolean binaryAvailable = content != null && !contentFound;
                    boolean bl = isCorruptedFile = !binaryAvailable && "file".equals(itemType);
                    if (isCorruptedFile) {
                        logger.error(MessageFormat.format("Impossible to import the file {0} as its binary is missing", path));
                        corruptedFilesLogger.error(path);
                        break block43;
                    }
                    this.checkoutNode(f);
                    if (!binaryAvailable) {
                        f = f.addNode(StringUtils.substringAfterLast((String)path, (String)"/"), "jnt:folder", null, created, createdBy, lastModified, lastModifiedBy);
                    } else {
                        f = f.addNode(StringUtils.substringAfterLast((String)path, (String)"/"), "jnt:file", null, created, createdBy, lastModified, lastModifiedBy);
                        String contentType = attributes.getValue("dav:getcontenttype");
                        if (content != null) {
                            if (contentType == null || contentType.length() == 0 || "application/binary".equals(contentType)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("We don't have a proper content type for file content {}, let's force its detection", (Object)f.getPath());
                                }
                                contentType = null;
                            }
                            f.getFileContent().uploadFile(content, contentType);
                        } else {
                            f.getFileContent().uploadFile(this.zis, contentType);
                        }
                    }
                    if (acl != null && acl.length() > 0) {
                        StringTokenizer st = new StringTokenizer(acl, "|");
                        while (st.hasMoreElements()) {
                            String s = st.nextToken();
                            int beginIndex = s.lastIndexOf(":");
                            String principal = s.substring(0, beginIndex);
                            HashSet<String> grantedRoles = new HashSet<String>();
                            HashSet<String> removedRoles = new HashSet<String>();
                            String perm = s.substring(beginIndex + 1);
                            if (perm.charAt(0) == 'r') {
                                if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_READ_ROLES)) {
                                    grantedRoles.addAll(LegacyImportHandler.READ_ROLES);
                                } else {
                                    grantedRoles.addAll(LegacyImportHandler.CUSTOM_FILES_READ_ROLES);
                                }
                            } else if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_READ_ROLES)) {
                                removedRoles.addAll(LegacyImportHandler.READ_ROLES);
                            } else {
                                removedRoles.addAll(LegacyImportHandler.CUSTOM_FILES_READ_ROLES);
                            }
                            if (perm.charAt(1) == 'w') {
                                if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES)) {
                                    grantedRoles.addAll(LegacyImportHandler.WRITE_ROLES);
                                } else {
                                    grantedRoles.addAll(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES);
                                }
                            } else if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES)) {
                                removedRoles.addAll(LegacyImportHandler.WRITE_ROLES);
                            } else {
                                removedRoles.addAll(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES);
                            }
                            if (!grantedRoles.isEmpty()) {
                                f.grantRoles(principal, grantedRoles);
                            }
                            if (removedRoles.isEmpty()) continue;
                            f.denyRoles(principal, removedRoles);
                        }
                    }
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String attUri = attributes.getURI(i);
                        String attName = attributes.getLocalName(i);
                        if ("http://www.jahia.org/".equals(attUri) && ("path".equals(attName) || "fileacl".equals(attName) || "lastModification".equals(attName))) continue;
                        try {
                            this.setPropertyField(f.getPrimaryNodeType(), localName, f, this.getMappedProperty(f.getPrimaryNodeType(), attributes.getQName(i)), attributes.getValue(i));
                            continue;
                        }
                        catch (RepositoryException e) {
                            logger.warn("Error importing " + localName + " " + path, (Throwable)e);
                        }
                    }
                    this.session.save(13);
                }
                catch (Exception e) {
                    try {
                        logger.error("error", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(content);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)content);
                }
            }
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    private String getMappedProperty(ExtendedNodeType baseType, String qName) {
        String mappedProperty = this.davPropertiesMapping.get(qName);
        if (mappedProperty == null && this.mapping != null) {
            mappedProperty = this.mapping.getMappedProperty(baseType, qName);
        }
        if (mappedProperty != null) {
            return mappedProperty;
        }
        return null;
    }

    protected final Map<String, String> initializeDavPropertiesMapping() {
        HashMap<String, String> davPropertiesMapping = new HashMap<String, String>();
        davPropertiesMapping.put("dav:getcontentlanguage", "mix:language|jcr:content/jcr:language");
        davPropertiesMapping.put("dav:displayname", "mix:title|jcr:title");
        davPropertiesMapping.put("ged:categories", "jmix:categorized|j:defaultCategory");
        return davPropertiesMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setPropertyField(ExtendedNodeType baseType, String localName, JCRNodeWrapper node, String propertyName, String value) throws RepositoryException {
        if (propertyName == null || "#skip".equals(propertyName)) {
            return false;
        }
        JCRNodeWrapper parent = node;
        String mixinType = null;
        if (propertyName.contains("|")) {
            mixinType = StringUtils.substringBefore((String)propertyName, (String)"|");
            propertyName = StringUtils.substringAfter((String)propertyName, (String)"|");
        }
        if (StringUtils.contains((String)propertyName, (String)"/")) {
            String parentPath = StringUtils.substringBeforeLast((String)propertyName, (String)"/");
            if (parent.hasNode(parentPath)) {
                parent = parent.getNode(parentPath);
            }
            propertyName = StringUtils.substringAfterLast((String)propertyName, (String)"/");
        }
        parent = this.checkoutNode(parent);
        if (!StringUtils.isEmpty((String)mixinType) && !parent.isNodeType(mixinType)) {
            parent.addMixin(mixinType);
        }
        ExtendedPropertyDefinition propertyDefinition = null;
        propertyDefinition = parent.getApplicablePropertyDefinition(propertyName);
        if (propertyDefinition == null) {
            return false;
        }
        if (propertyDefinition.isProtected()) {
            return false;
        }
        JCRNodeWrapper n = parent;
        if (value == null || value.length() == 0 || value.equals("<empty>")) return false;
        switch (propertyDefinition.getRequiredType()) {
            case 5: {
                GregorianCalendar cal = new GregorianCalendar();
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    Date d = df.parse(value);
                    cal.setTime(d);
                    n.setProperty(propertyName, cal);
                    return true;
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return true;
            }
            default: {
                switch (propertyDefinition.getSelector()) {
                    case 13: {
                        String[] cats = Patterns.COMMA.split(value);
                        ArrayList<Value> values = new ArrayList<Value>();
                        for (int i = 0; i < cats.length; ++i) {
                            String cat = cats[i];
                            QueryWrapper q = this.session.getWorkspace().getQueryManager().createQuery("select * from [jnt:category] as cat where NAME(cat) = '" + JCRContentUtils.sqlEncode(cat) + "'", "JCR-SQL2");
                            NodeIterator ni = q.execute().getNodes();
                            if (!ni.hasNext()) continue;
                            values.add(this.session.getValueFactory().createValue(ni.nextNode()));
                        }
                        n.setProperty(propertyName, values.toArray(new Value[values.size()]));
                        return true;
                    }
                    case 2: {
                        n.setProperty(propertyName, value);
                        return true;
                    }
                }
                String[] vcs = propertyDefinition.getValueConstraints();
                List<String> constraints = Arrays.asList(vcs);
                if (!propertyDefinition.isMultiple()) {
                    if (value.startsWith("<jahia-resource") && (value = ResourceBundleMarker.parseMarkerValue(value).getResourceKey()).startsWith(propertyDefinition.getResourceBundleKey())) {
                        value = value.substring(propertyDefinition.getResourceBundleKey().length() + 1);
                    }
                    String string = value = baseType != null && this.mapping != null ? this.mapping.getMappedPropertyValue(baseType, localName, value) : value;
                    if (!constraints.isEmpty() && !constraints.contains(value)) return true;
                    try {
                        n.setProperty(propertyName, value);
                        return true;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    return true;
                }
                String[] strings = Patterns.TRIPPLE_DOLLAR.split(value);
                ArrayList<ValueImpl> values = new ArrayList<ValueImpl>();
                for (int i = 0; i < strings.length; ++i) {
                    String string = strings[i];
                    if (string.startsWith("<jahia-resource") && (string = ResourceBundleMarker.parseMarkerValue(string).getResourceKey()).startsWith(propertyDefinition.getResourceBundleKey())) {
                        string = string.substring(propertyDefinition.getResourceBundleKey().length() + 1);
                    }
                    String string2 = value = baseType != null ? this.mapping.getMappedPropertyValue(baseType, localName, value) : value;
                    if (!constraints.isEmpty() && !constraints.contains(value)) continue;
                    values.add(new ValueImpl(string, propertyDefinition.getRequiredType()));
                }
                n.setProperty(propertyName, values.toArray(new Value[values.size()]));
                return true;
            }
        }
    }

    private JCRNodeWrapper checkoutNode(JCRNodeWrapper node) throws RepositoryException {
        if (!node.isCheckedOut()) {
            this.session.checkout(node);
        }
        return node;
    }

    private boolean findContent(String path) throws IOException {
        int fileIndex;
        if (this.archive == null) {
            return false;
        }
        if (this.zis == null) {
            this.zis = new NoCloseZipInputStream(new BufferedInputStream(this.archive.getInputStream()));
            this.nextEntry = this.zis.getNextEntry();
        }
        if ((fileIndex = this.fileList.indexOf(path = JCRContentUtils.replaceColon(path))) != -1) {
            if (this.fileList.indexOf("/" + this.nextEntry.getName().replace('\\', '/')) > fileIndex) {
                this.zis.reallyClose();
                this.zis = new NoCloseZipInputStream(new BufferedInputStream(this.archive.getInputStream()));
            }
            do {
                this.nextEntry = this.zis.getNextEntry();
            } while (!("/" + this.nextEntry.getName().replace('\\', '/')).equals(path));
            return true;
        }
        return false;
    }

    private InputStream findExtractedContent(String path) throws IOException {
        File pathInFS = this.filePath.get(path = JCRContentUtils.replaceColon(path));
        if (pathInFS != null && pathInFS.exists() && !pathInFS.isDirectory()) {
            return new BufferedInputStream(new FileInputStream(pathInFS));
        }
        return null;
    }
}

