/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import com.google.common.collect.ImmutableSet;
import java.util.Stack;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRSessionWrapper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseDocumentViewHandler
extends DefaultHandler {
    protected Stack<String> pathes = new Stack();
    protected JCRSessionWrapper session;

    public BaseDocumentViewHandler() {
        this.pathes.add("");
    }

    public BaseDocumentViewHandler(JCRSessionWrapper session) {
        this();
        this.setSession(session);
    }

    public void setSession(JCRSessionWrapper session) {
        this.session = session;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            NamespaceRegistry nsRegistry = this.session.getWorkspace().getNamespaceRegistry();
            ImmutableSet prefixes = ImmutableSet.copyOf((Object[])nsRegistry.getPrefixes());
            if (!prefixes.contains(prefix)) {
                nsRegistry.registerNamespace(prefix, uri);
                this.session.setNamespacePrefix(prefix, uri);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public Stack<String> getPathes() {
        return this.pathes;
    }
}

