/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.deamons.filewatcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.deamons.filewatcher.JahiaFileWatcherService;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.tools.files.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaFileWatcherBaseService
extends JahiaFileWatcherService {
    private static Logger logger = LoggerFactory.getLogger(JahiaFileWatcherBaseService.class);
    private static JahiaFileWatcherBaseService m_Instance = null;
    private SchedulerService schedulerService;
    private Map m_Registry = new HashMap();

    protected JahiaFileWatcherBaseService() {
    }

    public static synchronized JahiaFileWatcherBaseService getInstance() {
        if (m_Instance == null) {
            m_Instance = new JahiaFileWatcherBaseService();
        }
        return m_Instance;
    }

    @Override
    public synchronized void addFileWatcher(String threadName, String fullFolderPath, boolean checkDate, long interval, boolean fileOnly) throws JahiaException {
        try {
            FileWatcher fw = new FileWatcher(fullFolderPath, checkDate, interval, fileOnly, this.schedulerService);
            this.m_Registry.put(threadName, fw);
        }
        catch (IOException e) {
            logger.error("addFileWatcher:: " + e.getMessage(), (Throwable)e);
            throw new JahiaException("JahiaFileWatcherBaseService", "failed adding File Watcher", 12, 1, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFileWatcher(String threadName) throws JahiaException {
        try {
            JahiaFileWatcherBaseService jahiaFileWatcherBaseService = this;
            synchronized (jahiaFileWatcherBaseService) {
                this.getFileWatcher(threadName).start();
            }
        }
        catch (IOException e) {
            logger.error("startFileWatcher:: " + e.getMessage(), (Throwable)e);
            throw new JahiaException("JahiaFileWatcherBaseService", "failed starting File Watcher", 12, 1, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFileWatcher(String threadName) throws JahiaException {
        JahiaFileWatcherBaseService jahiaFileWatcherBaseService = this;
        synchronized (jahiaFileWatcherBaseService) {
            this.getFileWatcher(threadName).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObserver(String threadName, Observer obs) {
        JahiaFileWatcherBaseService jahiaFileWatcherBaseService = this;
        synchronized (jahiaFileWatcherBaseService) {
            this.getFileWatcher(threadName).addObserver(obs);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() throws JahiaException {
        for (FileWatcher curFileWatcher : this.m_Registry.values()) {
            curFileWatcher.stop();
        }
    }

    @Override
    public synchronized FileWatcher getFileWatcher(String threadName) {
        return (FileWatcher)this.m_Registry.get(threadName);
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

