/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyValuesChoiceListInitializer
implements ChoiceListInitializer {
    private static final Logger logger = LoggerFactory.getLogger(PropertyValuesChoiceListInitializer.class);
    private static final String CONTEXT_NODE = "contextNode";

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        if (param == null || !param.contains(";")) {
            throw new IllegalArgumentException("Parameter format is wrong. Expecting 'targetNode;targetProperty' or 'targetNode;targetProperty;valueType'");
        }
        List<Object> choices = null;
        if (context != null) {
            JCRNodeWrapper contextNode = context.containsKey(CONTEXT_NODE) && context.get(CONTEXT_NODE) != null ? (JCRNodeWrapper)context.get(CONTEXT_NODE) : (JCRNodeWrapper)context.get("contextParent");
            try {
                choices = contextNode != null ? this.getChoices(contextNode, param) : new LinkedList();
            }
            catch (RepositoryException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return choices;
    }

    private List<ChoiceListValue> getChoices(JCRNodeWrapper contextNode, String param) throws RepositoryException {
        JCRValueWrapper[] values = null;
        String targetNode = StringUtils.substringBefore((String)param, (String)";").trim();
        String targetProperty = StringUtils.substringAfter((String)param, (String)";").trim();
        String valueType = null;
        if (targetProperty.contains(";")) {
            valueType = StringUtils.substringAfter((String)targetProperty, (String)";").trim();
            targetProperty = StringUtils.substringBefore((String)targetProperty, (String)";").trim();
        }
        JCRNodeWrapper target = null;
        if ("this".equals(targetNode)) {
            target = contextNode;
        } else {
            try {
                target = contextNode.getSession().getNode(targetNode);
            }
            catch (PathNotFoundException e) {
                logger.warn("Node {} cannot be found. The choice list for the {} will be empty", (Object)targetNode, (Object)contextNode.getPath());
            }
        }
        JCRPropertyWrapper prop = null;
        if (target != null && target.hasProperty(targetProperty)) {
            JCRValueWrapper[] jCRValueWrapperArray;
            prop = target.getProperty(targetProperty);
            if (prop.isMultiple()) {
                jCRValueWrapperArray = prop.getValues();
            } else {
                Value[] valueArray = new Value[1];
                jCRValueWrapperArray = valueArray;
                valueArray[0] = prop.getValue();
            }
            values = jCRValueWrapperArray;
        }
        LinkedList<ChoiceListValue> choices = null;
        if (values != null && values.length > 0) {
            choices = new LinkedList<ChoiceListValue>();
            boolean isReference = prop.getType() == 9 || prop.getType() == 10;
            for (JCRValueWrapper val : values) {
                if (isReference) {
                    JCRNodeWrapper referencedNode = val.getNode();
                    if (referencedNode == null) continue;
                    String listValue = null;
                    if (valueType != null) {
                        if ("name".equalsIgnoreCase(valueType)) {
                            listValue = referencedNode.getName();
                        } else if ("path".equalsIgnoreCase(valueType)) {
                            listValue = referencedNode.getPath();
                        }
                    }
                    listValue = listValue == null ? referencedNode.getIdentifier() : listValue;
                    choices.add(new ChoiceListValue(referencedNode.getDisplayableName(), listValue));
                    continue;
                }
                String listValue = val.getString();
                choices.add(new ChoiceListValue(listValue, listValue));
            }
        }
        return choices;
    }
}

