/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import org.jahia.services.content.nodetypes.ParseException;

public class Lexer {
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char BEGIN_NODE_TYPE_NAME = '[';
    public static final char END_NODE_TYPE_NAME = ']';
    public static final char EXTENDS = '>';
    public static final char LIST_DELIMITER = ',';
    public static final char PROPERTY_DEFINITION = '-';
    public static final char CHILD_NODE_DEFINITION = '+';
    public static final char BEGIN_TYPE = '(';
    public static final char END_TYPE = ')';
    public static final char DEFAULT = '=';
    public static final char CONSTRAINT = '<';
    public static final String[] ORDERABLE = new String[]{"orderable", "ord", "o"};
    public static final String[] MIXIN = new String[]{"mixin", "mix", "m"};
    public static final String[] ABSTRACT = new String[]{"abstract", "abs", "a"};
    public static final String[] NOQUERY = new String[]{"noquery", "nq"};
    public static final String[] QUERY = new String[]{"query", "q"};
    public static final String[] PRIMARYITEM = new String[]{"primaryitem", "!"};
    public static final String[] MIXIN_EXTENDS = new String[]{"extends"};
    public static final String[] VALIDATOR = new String[]{"validator", "val", "v"};
    public static final String[] PRIMARY = new String[]{"primary", "pri", "!"};
    public static final String[] AUTOCREATED = new String[]{"autocreated", "aut", "a"};
    public static final String[] MANDATORY = new String[]{"mandatory", "man", "m"};
    public static final String[] PROTECTED = new String[]{"protected", "pro", "p"};
    public static final String[] MULTIPLE = new String[]{"multiple", "mul", "*"};
    public static final String[] SNS = new String[]{"sns", "*", "multiple"};
    public static final String[] INTERNATIONALIZED = new String[]{"internationalized", "i15d", "i18n", "i"};
    public static final String[] ITEMTYPE = new String[]{"itemtype", "type"};
    public static final String[] INDEXED = new String[]{"indexed", "ind", "x"};
    public static final String[] SCOREBOOST = new String[]{"scoreboost", "boost", "b"};
    public static final String[] NO = new String[]{"no", "n"};
    public static final String[] YES = new String[]{"yes", "y"};
    public static final String[] TOKENIZED = new String[]{"tokenized", "tok", "t"};
    public static final String[] UNTOKENIZED = new String[]{"untokenized", "untok", "u"};
    public static final String[] ANALYZER = new String[]{"analyzer"};
    public static final String[] FACETABLE = new String[]{"facetable"};
    public static final String[] HIERARCHICAL = new String[]{"hierarchical"};
    public static final String[] SORTABLE = new String[]{"sortable"};
    public static final String[] FULLTEXTSEARCHABLE = new String[]{"fulltextsearchable", "fts"};
    public static final String[] QUERYOPS = new String[]{"queryops", "qop"};
    public static final String[] NOFULLTEXT = new String[]{"nofulltext", "nof"};
    public static final String[] NOQUERYORDER = new String[]{"noqueryorder", "nqord"};
    public static final String[] HIDDEN = new String[]{"hidden", "Hidden", "HIDDEN"};
    public static final String[] ONCONFLICT = new String[]{"onconflict"};
    public static final String[] USE_LATEST = new String[]{"latest"};
    public static final String[] USE_OLDEST = new String[]{"oldest"};
    public static final String[] NUMERIC_USE_MIN = new String[]{"min"};
    public static final String[] NUMERIC_USE_MAX = new String[]{"max"};
    public static final String[] NUMERIC_SUM = new String[]{"sum"};
    public static final String[] COPY = new String[]{"copy", "Copy", "COPY"};
    public static final String[] VERSION = new String[]{"version", "Version", "VERSION"};
    public static final String[] INITIALIZE = new String[]{"initialize", "Initialize", "INITIALIZE"};
    public static final String[] COMPUTE = new String[]{"compute", "Compute", "COMPUTE"};
    public static final String[] IGNORE = new String[]{"ignore", "Ignore", "IGNORE"};
    public static final String[] ABORT = new String[]{"abort", "Abort", "ABORT"};
    public static final String[] WORKFLOW = new String[]{"workflow", "Workflow", "WORKFLOW"};
    public static final String[] PROP_ATTRIBUTE;
    public static final String[] NODE_ATTRIBUTE;
    public static final String[] ALL_OPERATORS;
    public static final String QUEROPS_EQUAL = "=";
    public static final String QUEROPS_NOTEQUAL = "<>";
    public static final String QUEROPS_LESSTHAN = "<";
    public static final String QUEROPS_LESSTHANOREQUAL = "<=";
    public static final String QUEROPS_GREATERTHAN = ">";
    public static final String QUEROPS_GREATERTHANOREQUAL = ">=";
    public static final String QUEROPS_LIKE = "LIKE";
    public static final String[] STRING;
    public static final String[] BINARY;
    public static final String[] LONG;
    public static final String[] DOUBLE;
    public static final String[] BOOLEAN;
    public static final String[] DATE;
    public static final String[] NAME;
    public static final String[] PATH;
    public static final String[] REFERENCE;
    public static final String[] WEAKREFERENCE;
    public static final String[] URI;
    public static final String[] DECIMAL;
    public static final String[] SMALLTEXT;
    public static final String[] RICHTEXT;
    public static final String[] TEXTAREA;
    public static final String[] CHOICELIST;
    public static final String[] TAG;
    public static final String[] DATETIMEPICKER;
    public static final String[] DATEPICKER;
    public static final String[] CATEGORY;
    public static final String[] CONTENTPICKER;
    public static final String[] FILEUPLOAD;
    public static final String[] PAGE;
    public static final String[] COLOR;
    public static final String[] CHECKBOX;
    public static final String[] CRON;
    public static final String[] UNDEFINED;
    public static final String EOF = "eof";
    private final StreamTokenizer st;
    private final String filename;

    public Lexer(Reader r, String filename) {
        this.filename = filename;
        this.st = new StreamTokenizer(r);
        this.st.eolIsSignificant(false);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(58, 58);
        this.st.wordChars(95, 95);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.ordinaryChar(91);
        this.st.ordinaryChar(93);
        this.st.ordinaryChar(62);
        this.st.ordinaryChar(44);
        this.st.ordinaryChar(45);
        this.st.ordinaryChar(43);
        this.st.ordinaryChar(40);
        this.st.ordinaryChar(41);
        this.st.ordinaryChar(61);
        this.st.ordinaryChar(60);
    }

    public String getNextToken() throws ParseException {
        try {
            int tokenType = this.st.nextToken();
            if (tokenType == -1) {
                return EOF;
            }
            if (tokenType == -3 || tokenType == 39 || tokenType == 34) {
                return this.st.sval;
            }
            if (tokenType == -2) {
                return String.valueOf(this.st.nval);
            }
            return new String(new char[]{(char)tokenType});
        }
        catch (IOException e) {
            this.fail("IOException while attempting to read input stream", e);
            return null;
        }
    }

    public void fail(String message) throws ParseException {
        throw new ParseException(message, this.st.lineno(), -1, this.filename);
    }

    public void fail(String message, Throwable e) throws ParseException {
        throw new ParseException(message, e, this.st.lineno(), -1, this.filename);
    }

    public void fail(Throwable e) throws ParseException {
        throw new ParseException(e, this.st.lineno(), -1, this.filename);
    }

    static {
        ALL_OPERATORS = new String[]{"jcr.operator.equal.to", "jcr.operator.not.equal.to", "jcr.operator.greater.than", "jcr.operator.greater.than.or.equal.to", "jcr.operator.less.than", "jcr.operator.less.than.or.equal.to", "jcr.operator.like"};
        ArrayList<String> attr = new ArrayList<String>();
        attr.addAll(Arrays.asList(PRIMARY));
        attr.addAll(Arrays.asList(AUTOCREATED));
        attr.addAll(Arrays.asList(MANDATORY));
        attr.addAll(Arrays.asList(PROTECTED));
        attr.addAll(Arrays.asList(INTERNATIONALIZED));
        attr.addAll(Arrays.asList(INDEXED));
        attr.addAll(Arrays.asList(SCOREBOOST));
        attr.addAll(Arrays.asList(ANALYZER));
        attr.addAll(Arrays.asList(SORTABLE));
        attr.addAll(Arrays.asList(FACETABLE));
        attr.addAll(Arrays.asList(HIERARCHICAL));
        attr.addAll(Arrays.asList(FULLTEXTSEARCHABLE));
        attr.addAll(Arrays.asList(MULTIPLE));
        attr.addAll(Arrays.asList(QUERYOPS));
        attr.addAll(Arrays.asList(NOFULLTEXT));
        attr.addAll(Arrays.asList(NOQUERYORDER));
        attr.addAll(Arrays.asList(ONCONFLICT));
        attr.addAll(Arrays.asList(COPY));
        attr.addAll(Arrays.asList(VERSION));
        attr.addAll(Arrays.asList(INITIALIZE));
        attr.addAll(Arrays.asList(COMPUTE));
        attr.addAll(Arrays.asList(IGNORE));
        attr.addAll(Arrays.asList(ABORT));
        attr.addAll(Arrays.asList(HIDDEN));
        attr.addAll(Arrays.asList(ITEMTYPE));
        PROP_ATTRIBUTE = attr.toArray(new String[attr.size()]);
        attr = new ArrayList();
        attr.addAll(Arrays.asList(PRIMARY));
        attr.addAll(Arrays.asList(AUTOCREATED));
        attr.addAll(Arrays.asList(MANDATORY));
        attr.addAll(Arrays.asList(PROTECTED));
        attr.addAll(Arrays.asList(INTERNATIONALIZED));
        attr.addAll(Arrays.asList(SNS));
        attr.addAll(Arrays.asList(COPY));
        attr.addAll(Arrays.asList(VERSION));
        attr.addAll(Arrays.asList(INITIALIZE));
        attr.addAll(Arrays.asList(COMPUTE));
        attr.addAll(Arrays.asList(IGNORE));
        attr.addAll(Arrays.asList(ABORT));
        attr.addAll(Arrays.asList(WORKFLOW));
        attr.addAll(Arrays.asList(HIDDEN));
        attr.addAll(Arrays.asList(ITEMTYPE));
        NODE_ATTRIBUTE = attr.toArray(new String[attr.size()]);
        STRING = new String[]{"string", "String", "STRING"};
        BINARY = new String[]{"binary", "Binary", "BINARY"};
        LONG = new String[]{"long", "Long", "LONG"};
        DOUBLE = new String[]{"double", "Double", "DOUBLE"};
        BOOLEAN = new String[]{"boolean", "Boolean", "BOOLEAN"};
        DATE = new String[]{"date", "Date", "DATE"};
        NAME = new String[]{"name", "Name", "NAME"};
        PATH = new String[]{"path", "Path", "PATH"};
        REFERENCE = new String[]{"reference", "Reference", "REFERENCE"};
        WEAKREFERENCE = new String[]{"WEAKREFERENCE", "WeakReference", "weakreference"};
        URI = new String[]{"URI", "Uri", "uri"};
        DECIMAL = new String[]{"DECIMAL", "Decimal", "decimal"};
        SMALLTEXT = new String[]{"text", "Text", "TEXT"};
        RICHTEXT = new String[]{"richtext", "RichText", "RICHTEXT"};
        TEXTAREA = new String[]{"textarea", "TextArea", "TEXTAREA"};
        CHOICELIST = new String[]{"choicelist", "Choicelist", "CHOICELIST"};
        TAG = new String[]{"tag", "Tag", "TAG"};
        DATETIMEPICKER = new String[]{"datetimepicker", "DateTimePicker", "DATETIMEPICKER"};
        DATEPICKER = new String[]{"datepicker", "DatePicker", "DATEPICKER"};
        CATEGORY = new String[]{"category", "Category", "CATEGORY"};
        CONTENTPICKER = new String[]{"picker", "Picker", "PICKER"};
        FILEUPLOAD = new String[]{"fileupload", "FileUpload", "FILEUPLOAD"};
        PAGE = new String[]{"page", "Page", "PAGE"};
        COLOR = new String[]{"color", "Color", "COLOR"};
        CHECKBOX = new String[]{"checkbox", "Checkbox", "CHECKBOX"};
        CRON = new String[]{"cron", "Cron", "CRON"};
        UNDEFINED = new String[]{"undefined", "Undefined", "UNDEFINED", "*"};
    }
}

