/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.Arrays;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedNodeDefinition
extends ExtendedItemDefinition
implements NodeDefinition {
    private static final transient Logger logger = LoggerFactory.getLogger(ExtendedItemDefinition.class);
    private NodeTypeRegistry registry;
    private String[] requiredPrimaryTypes;
    private String defaultPrimaryType;
    private boolean allowsSameNameSiblings;
    private String workflow;

    public ExtendedNodeDefinition(NodeTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void setDeclaringNodeType(ExtendedNodeType declaringNodeType) {
        super.setDeclaringNodeType(declaringNodeType);
        declaringNodeType.setNodeDefinition(this.getName(), this);
    }

    public ExtendedNodeType[] getRequiredPrimaryTypes() {
        if (this.requiredPrimaryTypes == null) {
            return null;
        }
        ExtendedNodeType[] res = new ExtendedNodeType[this.requiredPrimaryTypes.length];
        for (int i = 0; i < this.requiredPrimaryTypes.length; ++i) {
            try {
                res[i] = this.registry.getNodeType(this.requiredPrimaryTypes[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                logger.error("Nodetype not found", (Throwable)e);
            }
        }
        return res;
    }

    public String[] getRequiredPrimaryTypeNames() {
        return this.requiredPrimaryTypes;
    }

    public void setRequiredPrimaryTypes(String[] requiredPrimaryTypes) {
        this.requiredPrimaryTypes = requiredPrimaryTypes;
    }

    public ExtendedNodeType getDefaultPrimaryType() {
        if (this.defaultPrimaryType != null) {
            try {
                return this.registry.getNodeType(this.defaultPrimaryType);
            }
            catch (NoSuchNodeTypeException e) {
                logger.error("Nodetype not found", (Throwable)e);
            }
        }
        return null;
    }

    public String getDefaultPrimaryTypeName() {
        return this.defaultPrimaryType;
    }

    public void setDefaultPrimaryType(String defaultPrimaryType) {
        this.defaultPrimaryType = defaultPrimaryType;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    public void setAllowsSameNameSiblings(boolean allowsSameNameSiblings) {
        this.allowsSameNameSiblings = allowsSameNameSiblings;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedNodeDefinition that = (ExtendedNodeDefinition)o;
        if (this.getName().equals("*") && !Arrays.equals(this.requiredPrimaryTypes, that.requiredPrimaryTypes)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void remove() {
        this.getDeclaringNodeType().removeNodeDefinition(this);
    }
}

