/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DatabaseJournal;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.jahia.services.content.impl.jackrabbit.DatabaseRecordIterator;
import org.jahia.services.content.impl.jackrabbit.JahiaAbstractJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaDatabaseJournal
extends JahiaAbstractJournal
implements DatabaseAware {
    private static final String DEFAULT_JOURNAL_TABLE = "JOURNAL";
    private static final String LOCAL_REVISIONS_TABLE = "LOCAL_REVISIONS";
    public static final int DEFAULT_JANITOR_SLEEP = 86400;
    static Logger log = LoggerFactory.getLogger(JahiaDatabaseJournal.class);
    private String driver;
    private String url;
    private String databaseType = "default";
    private String user;
    private String password;
    private String dataSourceName;
    ConnectionHelper conHelper;
    private int lockLevel;
    private long lockedRevision;
    private boolean janitorEnabled = false;
    int janitorSleep = 86400;
    Calendar janitorNextRun = Calendar.getInstance();
    private Thread janitorThread;
    private boolean schemaCheckEnabled = true;
    private DatabaseRevision databaseRevision;
    protected String selectRevisionsStmtSQL;
    protected String updateGlobalStmtSQL;
    protected String selectGlobalStmtSQL;
    protected String insertRevisionStmtSQL;
    protected String selectMinLocalRevisionStmtSQL;
    protected String cleanRevisionStmtSQL;
    protected String getLocalRevisionStmtSQL;
    protected String insertLocalRevisionStmtSQL;
    protected String updateLocalRevisionStmtSQL;
    protected String schemaObjectPrefix = "";
    private ConnectionFactory connectionFactory;

    public JahiaDatabaseJournal() {
        if (this.janitorNextRun.get(11) >= 3) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, 3);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
    }

    public void setConnectionFactory(ConnectionFactory connnectionFactory) {
        this.connectionFactory = connnectionFactory;
    }

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        this.init();
        try {
            this.conHelper = this.createConnectionHelper(this.getDataSource());
            this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
            if (this.isSchemaCheckEnabled()) {
                this.checkLocalRevisionSchema();
            }
            this.buildSQLStatements();
            this.initInstanceRevisionAndJanitor();
        }
        catch (Exception e) {
            String msg = "Unable to create connection.";
            throw new JournalException(msg, (Throwable)e);
        }
        log.info("DatabaseJournal initialized.");
    }

    private DataSource getDataSource() throws RepositoryException, SQLException {
        if (this.getDataSourceName() == null || "".equals(this.getDataSourceName())) {
            return this.connectionFactory.getDataSource(this.getDriver(), this.getUrl(), this.getUser(), this.getPassword());
        }
        return this.connectionFactory.getDataSource(this.dataSourceName);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new ConnectionHelper(dataSrc, false);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream in = DatabaseJournal.class.getResourceAsStream(this.databaseType + ".ddl");
        return new CheckSchemaOperation(this.conHelper, in, this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE).addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    protected void init() throws JournalException {
        if (this.driver == null && this.dataSourceName == null) {
            String msg = "Driver not specified.";
            throw new JournalException(msg);
        }
        if (this.url == null && this.dataSourceName == null) {
            String msg = "Connection URL not specified.";
            throw new JournalException(msg);
        }
        if (this.dataSourceName != null) {
            try {
                String configuredDatabaseType = this.connectionFactory.getDataBaseType(this.dataSourceName);
                try (InputStream resourceStream = DatabaseJournal.class.getResourceAsStream(configuredDatabaseType + ".ddl");){
                    if (resourceStream != null) {
                        this.setDatabaseType(configuredDatabaseType);
                    }
                }
                catch (IOException e) {
                    log.warn("Ignored exception on resource close", (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                throw new JournalException("failed to get database type", (Throwable)e);
            }
        }
        if (this.databaseType == null && this.url != null) {
            try {
                this.databaseType = JahiaDatabaseJournal.getDatabaseTypeFromURL(this.url);
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to derive database type from URL: " + e.getMessage();
                throw new JournalException(msg, (Throwable)e);
            }
        }
    }

    protected void initInstanceRevisionAndJanitor() throws JournalException {
        this.databaseRevision = new DatabaseRevision();
        long localFileRevision = 0L;
        if (this.getRevision() != null) {
            FileRevision currentFileRevision = new FileRevision(new File(this.getRevision()), true);
            localFileRevision = currentFileRevision.get();
            currentFileRevision.close();
        }
        long localRevision = this.databaseRevision.init(localFileRevision);
        log.info("Initialized local revision to {}", (Object)localRevision);
        if (this.janitorEnabled) {
            this.janitorThread = new Thread((Runnable)new RevisionTableJanitor(), "Jackrabbit-ClusterRevisionJanitor");
            this.janitorThread.setDaemon(true);
            this.janitorThread.start();
            log.info("Cluster revision janitor thread started; first run scheduled at {}", (Object)this.janitorNextRun.getTime());
        } else {
            log.info("Cluster revision janitor thread not started");
        }
    }

    public InstanceRevision getInstanceRevision() throws JournalException {
        return this.databaseRevision;
    }

    private static String getDatabaseTypeFromURL(String url) {
        int end;
        int start = url.indexOf(58);
        if (start != -1 && (end = url.indexOf(58, start + 1)) != -1) {
            return url.substring(start + 1, end);
        }
        throw new IllegalArgumentException(url);
    }

    public RecordIterator getRecords(long startRevision) throws JournalException {
        try {
            return new DatabaseRecordIterator(this.conHelper.exec(this.selectRevisionsStmtSQL, new Object[]{startRevision}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            throw new JournalException("Unable to return record iterator.", (Throwable)e);
        }
    }

    public RecordIterator getRecords() throws JournalException {
        try {
            return new DatabaseRecordIterator(this.conHelper.exec(this.selectRevisionsStmtSQL, new Object[]{Long.MIN_VALUE}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            throw new JournalException("Unable to return record iterator.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long startRevision, boolean startup) throws JournalException {
        if (!startup) {
            this.doSync(startRevision);
        } else {
            try {
                this.startBatch();
                try {
                    this.doSync(startRevision);
                }
                finally {
                    this.endBatch(true);
                }
            }
            catch (SQLException e) {
                throw new JournalException("Couldn't sync the cluster node", (Throwable)e);
            }
        }
    }

    protected void doLock() throws JournalException {
        ResultSet rs = null;
        boolean succeeded = false;
        try {
            this.startBatch();
        }
        catch (SQLException e) {
            throw new JournalException("Unable to set autocommit to false.", (Throwable)e);
        }
        try {
            this.conHelper.exec(this.updateGlobalStmtSQL, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug("{}.doLock : About to lock global revision table.", (Object)this);
            }
            if (!(rs = this.conHelper.exec(this.selectGlobalStmtSQL, null, false, 0)).next()) {
                throw new JournalException("No revision available.");
            }
            this.lockedRevision = rs.getLong(1);
            if (log.isDebugEnabled()) {
                log.debug("{}.doLock : Global revision table locked: {}", (Object)this, (Object)this.lockedRevision);
            }
            succeeded = true;
        }
        catch (SQLException e) {
            try {
                throw new JournalException("Unable to lock global revision table.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                if (!succeeded) {
                    this.doUnlock(false);
                }
                throw throwable;
            }
        }
        DbUtility.close((ResultSet)rs);
        if (!succeeded) {
            this.doUnlock(false);
        }
    }

    protected void doUnlock(boolean successful) {
        this.endBatch(successful);
    }

    private void startBatch() throws SQLException {
        if (this.lockLevel++ == 0) {
            this.conHelper.startBatch();
            if (log.isDebugEnabled()) {
                log.debug("{}.startBatch : DatabaseJournal batch started.", (Object)this);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("{}.startBatch : incremented lockLevel: {}", (Object)this, (Object)(this.lockLevel - 1));
        }
    }

    private void endBatch(boolean successful) {
        if (--this.lockLevel == 0) {
            try {
                this.conHelper.endBatch(successful);
                if (log.isDebugEnabled()) {
                    log.debug("{}.endBatch : DatabaseJournal batch ended. Successful? {}", (Object)this, (Object)successful);
                }
            }
            catch (SQLException e) {
                log.error("failed to end batch", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("{}.endBatch : startBatch decremented lockLevel: {} Successful? {}", new Object[]{this, this.lockLevel, successful});
        }
    }

    protected void appending(AppendRecord record) {
        log.info("Creating revision: {}", (Object)this.lockedRevision);
        record.setRevision(this.lockedRevision);
    }

    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            this.conHelper.exec(this.insertRevisionStmtSQL, new Object[]{record.getRevision(), this.getId(), record.getProducerId(), new StreamWrapper(in, (long)length)});
        }
        catch (SQLException e) {
            String msg = "Unable to append revision " + this.lockedRevision + ".";
            throw new JournalException(msg, (Throwable)e);
        }
    }

    public void close() {
        if (this.janitorThread != null) {
            this.janitorThread.interrupt();
        }
    }

    private void checkLocalRevisionSchema() throws IOException, SQLException {
        ByteArrayInputStream localRevisionDDLStream;
        block16: {
            localRevisionDDLStream = null;
            boolean done = false;
            try (InputStream in = DatabaseJournal.class.getResourceAsStream(this.databaseType + ".ddl");){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0 && sql.contains(LOCAL_REVISIONS_TABLE)) {
                        localRevisionDDLStream = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));
                        break;
                    }
                    sql = reader.readLine();
                }
                done = true;
            }
            catch (IOException e) {
                if (done) break block16;
                throw e;
            }
        }
        new CheckSchemaOperation(this.conHelper, localRevisionDDLStream, this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE).addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix).run();
    }

    protected void buildSQLStatements() {
        this.selectRevisionsStmtSQL = "select REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA from " + this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE + " where REVISION_ID > ? order by REVISION_ID";
        this.updateGlobalStmtSQL = "update " + this.schemaObjectPrefix + "GLOBAL_REVISION set REVISION_ID = REVISION_ID + 1";
        this.selectGlobalStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "GLOBAL_REVISION";
        this.insertRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE + " (REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA) values (?,?,?,?)";
        this.selectMinLocalRevisionStmtSQL = "select MIN(REVISION_ID) from " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE;
        this.cleanRevisionStmtSQL = "delete from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID < ?";
        this.getLocalRevisionStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE + " where JOURNAL_ID = ?";
        this.insertLocalRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE + " (REVISION_ID, JOURNAL_ID) values (?,?)";
        this.updateLocalRevisionStmtSQL = "update " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE + " set REVISION_ID = ? where JOURNAL_ID = ?";
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    @Deprecated
    public String getSchema() {
        return this.getDatabaseType();
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getJanitorEnabled() {
        return this.janitorEnabled;
    }

    public int getJanitorSleep() {
        return this.janitorSleep;
    }

    public int getJanitorFirstRunHourOfDay() {
        return this.janitorNextRun.get(11);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    @Deprecated
    public void setSchema(String databaseType) {
        this.setDatabaseType(databaseType);
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJanitorEnabled(boolean enabled) {
        this.janitorEnabled = enabled;
    }

    public void setJanitorSleep(int sleep) {
        this.janitorSleep = sleep;
    }

    public void setJanitorFirstRunHourOfDay(int hourOfDay) {
        this.janitorNextRun = Calendar.getInstance();
        if (this.janitorNextRun.get(11) >= hourOfDay) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, hourOfDay);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    @Override
    protected long getLockedRevision() {
        return this.lockedRevision;
    }

    public class RevisionTableJanitor
    implements Runnable {
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    log.info("Next clean-up run scheduled at {}", (Object)JahiaDatabaseJournal.this.janitorNextRun.getTime());
                    long sleepTime = JahiaDatabaseJournal.this.janitorNextRun.getTimeInMillis() - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    this.cleanUpOldRevisions();
                    JahiaDatabaseJournal.this.janitorNextRun.add(13, JahiaDatabaseJournal.this.janitorSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.info("Interrupted: stopping clean-up task.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanUpOldRevisions() {
            ResultSet rs = null;
            try {
                long minRevision = 0L;
                rs = JahiaDatabaseJournal.this.conHelper.exec(JahiaDatabaseJournal.this.selectMinLocalRevisionStmtSQL, null, false, 0);
                boolean cleanUp = rs.next();
                if (cleanUp) {
                    minRevision = rs.getLong(1);
                }
                if (cleanUp) {
                    JahiaDatabaseJournal.this.conHelper.exec(JahiaDatabaseJournal.this.cleanRevisionStmtSQL, new Object[]{minRevision});
                    log.info("Cleaned old revisions up to revision {}.", (Object)minRevision);
                }
                DbUtility.close((ResultSet)rs);
            }
            catch (Exception e) {
                log.warn("Failed to clean up old revisions.", (Throwable)e);
            }
            finally {
                DbUtility.close(rs);
            }
        }
    }

    public class DatabaseRevision
    implements InstanceRevision {
        private long localRevision;
        private boolean initialized = false;

        protected synchronized long init(long revision) throws JournalException {
            long l;
            ResultSet rs = null;
            try {
                rs = JahiaDatabaseJournal.this.conHelper.exec(JahiaDatabaseJournal.this.getLocalRevisionStmtSQL, new Object[]{JahiaDatabaseJournal.this.getId()}, false, 0);
                boolean exists = rs.next();
                boolean needUpdate = false;
                if (exists) {
                    long dbRevision = rs.getLong(1);
                    if (dbRevision < revision) {
                        needUpdate = true;
                    } else {
                        revision = dbRevision;
                    }
                }
                if (!exists) {
                    JahiaDatabaseJournal.this.conHelper.exec(JahiaDatabaseJournal.this.insertLocalRevisionStmtSQL, new Object[]{revision, JahiaDatabaseJournal.this.getId()});
                } else if (needUpdate) {
                    JahiaDatabaseJournal.this.conHelper.exec(JahiaDatabaseJournal.this.updateLocalRevisionStmtSQL, new Object[]{revision, JahiaDatabaseJournal.this.getId()});
                }
                this.localRevision = revision;
                this.initialized = true;
                l = revision;
            }
            catch (SQLException e) {
                try {
                    throw new JournalException("Failed to initialize local revision", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close((ResultSet)rs);
            return l;
        }

        public synchronized long get() {
            if (!this.initialized) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            return this.localRevision;
        }

        public synchronized void set(long localRevision) throws JournalException {
            if (!this.initialized) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            if (this.localRevision == localRevision) {
                if (log.isDebugEnabled()) {
                    log.debug("{}.set : Local revision already has value {}, will do nothing", (Object)this, (Object)localRevision);
                }
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("{}.set : Attempting to update local revision table with revision {} and journal ID {} with connection helper {}", new Object[]{this, localRevision, JahiaDatabaseJournal.this.getId(), JahiaDatabaseJournal.this.conHelper});
                }
                JahiaDatabaseJournal.this.conHelper.exec(JahiaDatabaseJournal.this.updateLocalRevisionStmtSQL, new Object[]{localRevision, JahiaDatabaseJournal.this.getId()});
                this.localRevision = localRevision;
                if (log.isDebugEnabled()) {
                    log.debug("{}.set : Local revision table updated with revision {} and journal ID {} with connection helper {}", new Object[]{this, localRevision, JahiaDatabaseJournal.this.getId(), JahiaDatabaseJournal.this.conHelper});
                }
            }
            catch (SQLException e) {
                throw new JournalException("Failed to update local revision.", (Throwable)e);
            }
        }

        public void close() {
        }
    }
}

