/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.util.XAReentrantWriterPreferenceReadWriteLock;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.VersioningLock;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.hazelcast.HazelcastCP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JahiaAbstractJournal
extends AbstractJournal {
    private static final Logger log = LoggerFactory.getLogger(JahiaAbstractJournal.class);
    public static final int RETRY_COUNT = 10;
    public static final int MAX_LOCK_TIME_INT = 500;
    public static final long MAX_LOCK_TIME_LONG = 500L;
    public static final int DEFAULT_MAX_LOCK_TIME = 30000;
    private final Map<String, RecordConsumer> consumers = new HashMap<String, RecordConsumer>();
    private final XAReentrantWriterPreferenceReadWriteLock rwLock = new XAReentrantWriterPreferenceReadWriteLock();
    private final Random random = new Random();
    private InternalVersionManagerImpl internalVersionManager;
    private int maxLockedSyncTime = 30000;
    private HazelcastCP lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RecordConsumer consumer) throws JournalException {
        super.register(consumer);
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            if (this.consumers.containsKey(consumerId)) {
                String msg = "Record consumer with identifier '" + consumerId + "' already registered.";
                throw new JournalException(msg);
            }
            this.consumers.put(consumerId, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(RecordConsumer consumer) {
        super.unregister(consumer);
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            return this.consumers.remove(consumerId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMinimalRevision() {
        long minimalRevision = Long.MAX_VALUE;
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            for (RecordConsumer consumer : this.consumers.values()) {
                if (consumer.getRevision() >= minimalRevision) continue;
                minimalRevision = consumer.getRevision();
            }
        }
        return minimalRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(boolean startup) throws JournalException {
        log.debug("Synchronize to the latest change. Startup: {}", (Object)startup);
        while (true) {
            if (this.internalVersionManager != null) {
                VersioningLock.ReadLock lock = this.internalVersionManager.acquireReadLock();
                try {
                    this.internalSync(startup);
                }
                finally {
                    lock.release();
                }
            } else {
                this.internalSync(startup);
            }
            startup = false;
            if (!this.syncAgainOnNewRecords()) break;
            RecordIterator it = this.getRecords(this.getMinimalRevision());
            try {
                if (!it.hasNext()) break;
                continue;
            }
            finally {
                it.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSync(boolean startup) throws JournalException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("{}.internalSync({}): Trying to acquire read lock ", (Object)this, (Object)startup);
            }
            this.rwLock.readLock().acquire();
            if (log.isDebugEnabled()) {
                log.debug("{}.internalSync({}): Read lock acquired", (Object)this, (Object)startup);
            }
        }
        catch (InterruptedException e) {
            String msg = "Unable to acquire read lock.";
            throw new JournalException(msg, (Throwable)e);
        }
        try {
            this.doSync(this.getMinimalRevision(), startup);
        }
        finally {
            this.rwLock.readLock().release();
            if (log.isDebugEnabled()) {
                log.debug("{}.internalSync({}): Read lock released", (Object)this, (Object)startup);
            }
        }
    }

    protected void doSync(long startRevision) throws JournalException {
        this.doSync(startRevision, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSync(long startRevision, long maxTime) throws JournalException {
        log.debug("Synchronize contents from journal. StartRevision: {}", (Object)startRevision);
        RecordIterator iterator = this.getRecords(startRevision);
        long startTime = System.currentTimeMillis();
        long stopRevision = Long.MIN_VALUE;
        boolean timeOut = false;
        try {
            while (!timeOut && iterator.hasNext()) {
                Record record = iterator.nextRecord();
                if (record.getJournalId().equals(this.getId())) {
                    log.debug("Record with revision '{}}' created by this journal, skipped.", (Object)record.getRevision());
                } else {
                    RecordConsumer consumer = this.getConsumer(record.getProducerId());
                    if (consumer != null) {
                        consumer.consume(record);
                    }
                }
                stopRevision = record.getRevision();
                if (maxTime <= -1L || System.currentTimeMillis() - startTime <= maxTime) continue;
                timeOut = true;
            }
        }
        catch (IllegalStateException e) {
            log.error("Could not synchronize to revision: {} due illegal state of RecordConsumer.", (Object)(stopRevision + 1L), (Object)e);
        }
        finally {
            iterator.close();
        }
        if (stopRevision > 0L) {
            for (RecordConsumer consumer : this.consumers.values()) {
                consumer.setRevision(stopRevision);
            }
            log.debug("Synchronized from revision {} to revision: {}", (Object)startRevision, (Object)stopRevision);
        }
        return !timeOut;
    }

    public void lockAndSync() throws JournalException {
        log.debug("Lock the journal revision and synchronize to the latest change.");
        if (this.internalVersionManager != null) {
            VersioningLock.ReadLock lock = this.internalVersionManager.acquireReadLock();
            try {
                this.internalLockAndSync();
            }
            finally {
                lock.release();
            }
        } else {
            this.internalLockAndSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalLockAndSync() throws JournalException {
        this.acquireWriteLock();
        boolean succeeded = false;
        int tryCount = 0;
        try {
            while (!succeeded) {
                if (tryCount > 0) {
                    try {
                        log.info("Wait ... ");
                        Thread.sleep(500L + (long)this.random.nextInt(500));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.doSync(this.getMinimalRevision());
                long hazelcast = this.lockCluster();
                this.doLock();
                long lockedRevision = this.getLockedRevision();
                log.debug("Locked revision {}, from hz {}", (Object)lockedRevision, (Object)hazelcast);
                try {
                    if (lockedRevision <= hazelcast) {
                        log.warn("Invalid revision {} from database, must be greater than {}, wait and retry", (Object)lockedRevision, (Object)hazelcast);
                        if (tryCount++ <= 10) continue;
                        throw new JournalException("Invalid revision {} from database, must be greater than {}");
                    }
                    succeeded = this.doSync(this.getMinimalRevision(), this.maxLockedSyncTime);
                    tryCount = 0;
                }
                finally {
                    if (succeeded) continue;
                    this.doUnlock(false);
                    this.unlockCluster(null);
                }
            }
            return;
        }
        finally {
            if (!succeeded) {
                this.rwLock.writeLock().release();
                this.unlockCluster(null);
                if (log.isDebugEnabled()) {
                    log.debug("{}.internalLockAndSync : writeLock {} released - unsuccessful sync", (Object)this, (Object)this.rwLock.writeLock());
                }
            }
        }
    }

    private void acquireWriteLock() throws JournalException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("{}.internalLockAndSync: Trying to acquire writeLock {}", (Object)this, (Object)this.rwLock.writeLock());
            }
            this.rwLock.writeLock().acquire();
            if (log.isDebugEnabled()) {
                log.debug("{}.internalLockAndSync: writeLock {} acquired", (Object)this, (Object)this.rwLock.writeLock());
            }
        }
        catch (InterruptedException e) {
            String msg = "Unable to acquire write lock.";
            throw new JournalException(msg, (Throwable)e);
        }
    }

    protected abstract long getLockedRevision();

    public void unlock(boolean successful) {
        try {
            this.doUnlock(successful);
            this.unlockCluster(successful ? Long.valueOf(this.getLockedRevision()) : null);
        }
        catch (Throwable throwable) {
            this.rwLock.writeLock().release();
            if (log.isDebugEnabled()) {
                log.debug("{}.unlock : writeLock {} released - Successful? {}", new Object[]{this, this.rwLock.writeLock(), successful});
            }
            throw throwable;
        }
        this.rwLock.writeLock().release();
        if (log.isDebugEnabled()) {
            log.debug("{}.unlock : writeLock {} released - Successful? {}", new Object[]{this, this.rwLock.writeLock(), successful});
        }
    }

    private long lockCluster() {
        HazelcastCP hcp = this.getLockService();
        if (hcp != null) {
            hcp.lock("journalLock");
            Long globalRevision = hcp.getAtomic("globalRevision");
            if (globalRevision != null) {
                return globalRevision;
            }
        }
        return 0L;
    }

    private void unlockCluster(Long newGlobalRevision) {
        HazelcastCP hcp = this.getLockService();
        if (hcp != null) {
            if (newGlobalRevision != null) {
                log.debug("Updating global revision before releasing lock = {}", (Object)newGlobalRevision);
                hcp.setAtomic("globalRevision", newGlobalRevision);
            }
            hcp.unlock("journalLock");
        }
    }

    private HazelcastCP getLockService() {
        if (this.lockService == null && FrameworkService.getInstance().isStarted()) {
            this.lockService = BundleUtils.getOsgiService(HazelcastCP.class, null);
        }
        return this.lockService;
    }

    public void setInternalVersionManager(InternalVersionManagerImpl internalVersionManager) {
        this.internalVersionManager = internalVersionManager;
    }

    public int getMaxLockedSyncTime() {
        return this.maxLockedSyncTime;
    }

    public void setMaxLockedSyncTime(int maxLockedSyncTime) {
        this.maxLockedSyncTime = maxLockedSyncTime;
    }
}

