/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RBACUtils {
    private static final Logger logger = LoggerFactory.getLogger(RBACUtils.class);

    public static JCRNodeWrapper getOrCreatePermission(String path, JCRSessionWrapper session) throws RepositoryException {
        if (path == null || !path.startsWith("/permissions/")) {
            throw new IllegalArgumentException("Illegal value for the permission path: " + path);
        }
        String basePath = StringUtils.substringBeforeLast((String)path, (String)"/");
        String name = StringUtils.substringAfterLast((String)path, (String)"/");
        JCRNodeWrapper permission = null;
        JCRNodeWrapper base = null;
        try {
            base = session.getNode(basePath);
        }
        catch (PathNotFoundException e) {
            base = RBACUtils.getOrCreatePermission(basePath, session);
        }
        if (!base.hasNode(name)) {
            session.checkout(base);
            permission = base.addNode(name, "jnt:permission");
            logger.info("Added permission node {}", (Object)permission.getPath());
        } else {
            permission = base.getNode(name);
        }
        return permission;
    }

    public static JCRNodeWrapper getOrCreateRole(String path, JCRSessionWrapper session) throws RepositoryException {
        if (path == null || !path.startsWith("/roles/")) {
            throw new IllegalArgumentException("Illegal value for the role path: " + path);
        }
        String name = StringUtils.substringAfterLast((String)path, (String)"/");
        JCRNodeWrapper role = null;
        JCRNodeWrapper base = session.getNode(StringUtils.substringBeforeLast((String)path, (String)"/"));
        if (!base.hasNode(name)) {
            session.checkout(base);
            role = base.addNode(name, "jnt:role");
            logger.info("Added role node {}", (Object)role.getPath());
        } else {
            role = base.getNode(name);
        }
        return role;
    }

    public static boolean grantPermissionToRole(String permissionPath, String rolePath, JCRSessionWrapper session) throws RepositoryException {
        if (permissionPath == null || !permissionPath.startsWith("/permissions/")) {
            throw new IllegalArgumentException("Illegal value for the permission path: " + permissionPath);
        }
        if (rolePath == null || rolePath.length() == 0) {
            throw new IllegalArgumentException("Illegal value for the role: " + rolePath);
        }
        boolean modified = true;
        JCRNodeWrapper permission = session.getNode(permissionPath);
        String permissionId = permission.getIdentifier();
        JCRNodeWrapper role = null;
        if (rolePath.contains("/")) {
            role = session.getNode(rolePath);
        } else {
            JCRNodeIteratorWrapper ni = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode(rolePath) + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
            if (ni.hasNext()) {
                role = (JCRNodeWrapper)ni.nextNode();
            }
        }
        if (role == null) {
            throw new RepositoryException("Failed to get role: " + rolePath);
        }
        if (role.hasProperty("j:permissions")) {
            JCRValueWrapper[] values = role.getProperty("j:permissions").getValues();
            boolean alreadyPresent = false;
            for (JCRValueWrapper value : values) {
                if (!permissionId.equals(value.getString())) continue;
                alreadyPresent = true;
                break;
            }
            if (!alreadyPresent) {
                Value[] newValues = new Value[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[values.length] = session.getValueFactory().createValue((Node)permission, true);
                role.setProperty("j:permissions", newValues);
                logger.info("Granted permission {} to role {}", (Object)permission.getPath(), (Object)role.getPath());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Role {} already has permission {} granted", (Object)role.getPath(), (Object)permission.getPath());
                }
                modified = false;
            }
        } else {
            role.setProperty("j:permissions", new Value[]{session.getValueFactory().createValue((Node)permission, true)});
            logger.info("Granted permission {} to role {}", (Object)permission.getPath(), (Object)role.getPath());
        }
        return modified;
    }

    public static boolean hasPermission(String rolePath, String permissionPath, JCRSessionWrapper session) throws RepositoryException {
        if (permissionPath == null || !permissionPath.startsWith("/permissions/")) {
            throw new IllegalArgumentException("Illegal value for the permission path: " + permissionPath);
        }
        if (rolePath == null || rolePath.length() == 0) {
            throw new IllegalArgumentException("Illegal value for the role: " + rolePath);
        }
        JCRNodeWrapper permission = session.getNode(permissionPath);
        String permissionId = permission.getIdentifier();
        JCRNodeWrapper role = null;
        if (rolePath.contains("/")) {
            role = session.getNode(rolePath);
        } else {
            JCRNodeIteratorWrapper ni = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode(rolePath) + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
            if (ni.hasNext()) {
                role = (JCRNodeWrapper)ni.nextNode();
            }
        }
        if (role == null) {
            throw new RepositoryException("Failed to get role: " + rolePath);
        }
        if (!role.hasProperty("j:permissions")) {
            return false;
        }
        JCRValueWrapper[] values = role.getProperty("j:permissions").getValues();
        if (values == null || values.length == 0) {
            return false;
        }
        boolean found = false;
        for (JCRValueWrapper value : values) {
            if (!StringUtils.equals((String)permissionId, (String)value.getString())) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean revokePermissionFromRole(String permissionPath, String rolePath, JCRSessionWrapper session) throws RepositoryException {
        if (permissionPath == null || !permissionPath.startsWith("/permissions/")) {
            throw new IllegalArgumentException("Illegal value for the permission path: " + permissionPath);
        }
        if (rolePath == null || rolePath.length() == 0) {
            throw new IllegalArgumentException("Illegal value for the role: " + rolePath);
        }
        boolean modified = false;
        JCRNodeWrapper permission = session.getNode(permissionPath);
        String permissionId = permission.getIdentifier();
        JCRNodeWrapper role = null;
        if (rolePath.contains("/")) {
            role = session.getNode(rolePath);
        } else {
            JCRNodeIteratorWrapper ni = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode(rolePath) + "' and isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
            if (ni.hasNext()) {
                role = (JCRNodeWrapper)ni.nextNode();
            }
        }
        if (role == null) {
            throw new RepositoryException("Failed to get role: " + rolePath);
        }
        if (!role.hasProperty("j:permissions")) {
            return false;
        }
        JCRValueWrapper[] values = role.getProperty("j:permissions").getValues();
        if (values == null || values.length == 0) {
            return false;
        }
        LinkedList newValues = new LinkedList();
        Collections.addAll(newValues, values);
        boolean found = false;
        Iterator valueIterator = newValues.iterator();
        while (valueIterator.hasNext()) {
            if (!StringUtils.equals((String)permissionId, (String)((Value)valueIterator.next()).getString())) continue;
            found = true;
            valueIterator.remove();
        }
        if (found) {
            modified = true;
            if (newValues.isEmpty()) {
                role.setProperty("j:permissions", (Value[])null);
            } else {
                role.setProperty("j:permissions", newValues.toArray(new Value[0]));
            }
            logger.info("Revoked permission {} from role {}", (Object)permission.getPath(), (Object)role.getPath());
        }
        return modified;
    }

    private RBACUtils() {
    }
}

