/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

public class PublicationJob
extends BackgroundJob {
    public static final String PUBLICATION_UUIDS = "publicationInfos";
    public static final String PUBLICATION_PATHS = "publicationPaths";
    public static final String PUBLICATION_PROPERTIES = "publicationProperties";
    public static final String PUBLICATION_COMMENTS = "publicationComments";
    public static final String PUBLICATION_TITLE = "publicationTitle";
    public static final String SOURCE = "source";
    public static final String DESTINATION = "destination";
    public static final String LOCK = "lock";
    public static final String CHECK_PERMISSIONS = "checkPermissions";

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        List uuids = (List)jobDataMap.get((Object)PUBLICATION_UUIDS);
        String source = (String)jobDataMap.get((Object)SOURCE);
        String destination = (String)jobDataMap.get((Object)DESTINATION);
        String lock = (String)jobDataMap.get((Object)LOCK);
        Boolean checkPermissions = (Boolean)jobDataMap.get((Object)CHECK_PERMISSIONS);
        List comments = (List)jobDataMap.get((Object)PUBLICATION_COMMENTS);
        JCRPublicationService.getInstance().publish(uuids, source, destination, (boolean)checkPermissions, (List<String>)comments);
        if (lock != null) {
            JCRPublicationService.getInstance().unlockForPublication(uuids, source, lock);
        }
        String label = "published_at_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(GregorianCalendar.getInstance().getTime());
        JCRVersionService.getInstance().addVersionLabel(uuids, label, "live");
        WorkflowService workflowService = WorkflowService.getInstance();
        List<Workflow> l = workflowService.getWorkflowsForType("publish", null);
        for (Workflow workflow : l) {
            List nodeIds;
            if (("publication-process-" + workflow.getId()).equals(lock) || (nodeIds = (List)workflow.getVariables().get("nodeIds")) == null || !uuids.containsAll(nodeIds)) continue;
            JCRPublicationService.getInstance().unlockForPublication(nodeIds, (String)workflow.getVariables().get("workspace"), "publication-process-" + workflow.getId());
            workflowService.abortProcess(workflow.getId(), workflow.getProvider());
        }
    }
}

