/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.core.JahiaSessionImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.apache.jackrabbit.util.Text;
import org.jahia.api.Constants;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.ChildNodesIterator;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRItemWrapperImpl;
import org.jahia.services.content.JCRLockUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.LazyPropertyIterator;
import org.jahia.services.content.NodeIteratorImpl;
import org.jahia.services.content.PropertyIteratorImpl;
import org.jahia.services.content.VersionInfo;
import org.jahia.services.content.decorator.JCRFileContent;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRPlaceholderNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.decorator.JCRVersion;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingPredicate;

public class JCRNodeWrapperImpl
extends JCRItemWrapperImpl
implements JCRNodeWrapper {
    private static final Logger logger = LoggerFactory.getLogger(JCRNodeWrapperImpl.class);
    private static final String[] TRANSLATION_NODES_PATTERN = new String[]{"j:translation_*"};
    private static final String TRANSLATION_PREFIX = "j:translation_";
    protected Node objectNode = null;
    protected JCRFileContent fileContent = null;
    protected JCRSiteNode site = null;
    protected boolean parentAlreadyResolved = false;
    protected JCRNodeWrapper resolvedParentNode = null;
    protected Map<Locale, Node> i18NobjectNodes = null;
    protected Map<String, List<String[]>> aclEntries = null;
    protected Boolean breakAcl = null;
    public static final String EXTERNAL_IDENTIFIER_PROP_NAME_SEPARATOR = "___";
    public static final Pattern EXTERNAL_IDENTIFIER_PROP_NAME_SEPARATOR_PATTERN = Pattern.compile("___");
    private static final ExtendedNodeType[] EMPTY_EXTENDED_NODE_TYPE_ARRAY = new ExtendedNodeType[0];
    private Map<String, ExtendedPropertyDefinition> applicablePropertyDefinition = new HashMap<String, ExtendedPropertyDefinition>();
    private Map<String, Boolean> hasPropertyCache = new HashMap<String, Boolean>();
    private ExtendedNodeType[] originalMixins = null;

    private static boolean doCopy(JCRNodeWrapper source, JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batchCount, boolean isTopObject) throws RepositoryException {
        if (source instanceof JCRNodeWrapperImpl) {
            return ((JCRNodeWrapperImpl)source).internalCopy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount, isTopObject);
        }
        if (source instanceof JCRNodeDecorator) {
            return ((JCRNodeDecorator)source).internalCopy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount, isTopObject);
        }
        return source.copy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount);
    }

    protected static void unlock(Node objectNode, String type, String userID, JCRSessionWrapper session) throws RepositoryException {
        if (objectNode.hasProperty("j:locktoken")) {
            Value[] types;
            Property property = objectNode.getProperty("j:locktoken");
            String token = property.getString();
            for (Value value : types = objectNode.getProperty("j:lockTypes").getValues()) {
                String owner = StringUtils.substringBefore((String)value.getString(), (String)":");
                String currentType = StringUtils.substringAfter((String)value.getString(), (String)":");
                if (!currentType.equals(type) || !userID.equals(owner)) continue;
                objectNode.getSession().addLockToken(token);
                session.checkout(objectNode);
                ArrayList<Value> valueList = new ArrayList<Value>(Arrays.asList(types));
                valueList.remove(value);
                if (valueList.isEmpty()) {
                    session.save();
                    objectNode.unlock();
                    property.remove();
                    objectNode.getProperty("j:lockTypes").remove();
                } else {
                    objectNode.setProperty("j:lockTypes", valueList.toArray(new Value[valueList.size()]));
                }
                session.save();
                return;
            }
        } else {
            objectNode.unlock();
        }
    }

    protected JCRNodeWrapperImpl(Node objectNode, String path, JCRNodeWrapper parent, JCRSessionWrapper session, JCRStoreProvider provider) throws RepositoryException {
        super(session, provider);
        this.objectNode = objectNode;
        this.setItem((Item)objectNode);
        if (path != null) {
            if (path.endsWith("/") && !path.equals("/")) {
                path = StringUtils.substringBeforeLast((String)path, (String)"/");
            }
            try {
                this.localPath = objectNode.getPath();
                this.localPathInProvider = objectNode.getPath();
                if (path.contains("@/")) {
                    this.localPath = path;
                }
                if (this.localPath.startsWith("/jcr:system")) {
                    this.localPath = path;
                    this.localPathInProvider = path;
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.localPath = objectNode.getPath();
            this.localPathInProvider = objectNode.getPath();
        }
        if (parent != null) {
            this.parentAlreadyResolved = true;
            this.resolvedParentNode = parent;
        }
    }

    @Override
    public Node getRealNode() {
        return this.objectNode;
    }

    @Override
    public JCRNodeWrapper getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (this.parentAlreadyResolved) {
            return this.resolvedParentNode;
        }
        try {
            if (this.localPath.equals("/") || this.localPath.equals(this.provider.getRelativeRoot())) {
                if (this.provider.getMountPoint().equals("/")) {
                    throw new ItemNotFoundException();
                }
                return (JCRNodeWrapper)this.session.getItem(StringUtils.substringBeforeLast((String)this.provider.getMountPoint(), (String)"/"));
            }
            return (JCRNodeWrapper)this.session.getItem(StringUtils.substringBeforeLast((String)this.getPath(), (String)"/"));
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException((Throwable)e);
        }
    }

    @Override
    public JCRUserNode getUser() {
        try {
            return this.session.getUserNode();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, List<String[]>> getAclEntries() {
        try {
            String path = this.getPath();
            if (this.aclEntries == null) {
                LinkedHashMap<String, List<String[]>> entries;
                block17: {
                    entries = new LinkedHashMap<String, List<String[]>>();
                    this.breakAcl = false;
                    try {
                        if (!this.hasNode("j:acl")) break block17;
                        JCRNodeWrapper acl = this.getNode("j:acl");
                        NodeIterator aces = acl.getNodes();
                        while (aces.hasNext()) {
                            Node node = aces.nextNode();
                            if (!node.isNodeType("jnt:ace") || !node.hasProperty("j:roles")) continue;
                            String principal = node.getProperty("j:principal").getString();
                            if (!entries.containsKey(principal)) {
                                entries.put(principal, new ArrayList());
                            }
                            Value[] roles = node.getProperty("j:roles").getValues();
                            if (!node.isNodeType("jnt:externalAce")) {
                                String string = node.getProperty("j:aceType").getString();
                                Value[] valueArray = roles;
                                int n = valueArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Value role = valueArray[i];
                                    ((List)entries.get(principal)).add(new String[]{path, string, role.getString()});
                                }
                                continue;
                            }
                            for (Value role : roles) {
                                ((List)entries.get(principal)).add(new String[]{path, "EXTERNAL", role.getString() + "/" + node.getProperty("j:externalPermissionsName").getString()});
                            }
                        }
                        this.breakAcl = acl.hasProperty("j:inherit") && !acl.getProperty("j:inherit").getBoolean();
                    }
                    catch (ItemNotFoundException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                LinkedHashMap<String, List<Object>> result = entries;
                if (!this.breakAcl.booleanValue() && !path.equals("/")) {
                    result = new LinkedHashMap();
                    for (Map.Entry entry : entries.entrySet()) {
                        result.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
                    }
                    try {
                        for (Map.Entry entry : this.getParent().getAclEntries().entrySet()) {
                            String key = (String)entry.getKey();
                            List value = (List)entry.getValue();
                            List list = (List)result.get(key);
                            if (list != null) {
                                list.addAll(value);
                                continue;
                            }
                            result.put(key, value);
                        }
                    }
                    catch (ItemNotFoundException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                if (this.session.isReadOnlyCacheEnabled()) {
                    this.aclEntries = result;
                }
                return result;
            }
            return this.aclEntries;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Map<String, String>> getActualAclEntries() {
        HashMap<String, Map<String, String>> actualACLs = new HashMap<String, Map<String, String>>();
        Map<String, List<String[]>> allACLs = this.getAclEntries();
        if (allACLs != null) {
            for (Map.Entry<String, List<String[]>> entry : allACLs.entrySet()) {
                HashMap<String, String> permissionsForUser = new HashMap<String, String>();
                for (String[] perms : entry.getValue()) {
                    if (permissionsForUser.containsKey(perms[2])) {
                        if (!perms[0].equals(this.getPath())) continue;
                        permissionsForUser.put(perms[2], perms[1]);
                        continue;
                    }
                    permissionsForUser.put(perms[2], perms[1]);
                }
                actualACLs.put(entry.getKey(), permissionsForUser);
            }
        }
        return actualACLs;
    }

    @Override
    public Map<String, List<JCRNodeWrapper>> getAvailableRoles() throws RepositoryException {
        HashMap<String, List<JCRNodeWrapper>> res = new HashMap<String, List<JCRNodeWrapper>>();
        JCRNodeIteratorWrapper ni = this.session.getWorkspace().getQueryManager().createQuery("select * from [jnt:role] as r where isdescendantnode(r,['/roles'])", "JCR-SQL2").execute().getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper role = (JCRNodeWrapper)ni.nextNode();
            boolean add = false;
            if (!role.hasProperty("j:hidden") || !role.getProperty("j:hidden").getBoolean()) {
                if (role.hasProperty("j:nodeTypes")) {
                    JCRValueWrapper[] values = role.getProperty("j:nodeTypes").getValues();
                    if (values.length > 0) {
                        for (JCRValueWrapper value : values) {
                            if (!this.isNodeType(value.getString())) continue;
                            add = true;
                            break;
                        }
                    } else {
                        add = true;
                    }
                } else {
                    add = true;
                }
            }
            if (!add) continue;
            String roleGroup = role.hasProperty("j:roleGroup") ? role.getProperty("j:roleGroup").getString() : "default";
            if (!res.containsKey(roleGroup)) {
                res.put(roleGroup, new ArrayList());
            }
            ((List)res.get(roleGroup)).add(role);
        }
        return res;
    }

    @Override
    public boolean hasPermission(String perm) {
        try {
            if (this.session.isSystem()) {
                return true;
            }
            AccessControlManager accessControlManager = this.getAccessControlManager();
            return accessControlManager == null || accessControlManager.hasPrivileges(this.localPathInProvider, new Privilege[]{accessControlManager.privilegeFromName(perm)});
        }
        catch (RepositoryException re) {
            logger.error("Cannot check permission " + perm, (Throwable)re);
            return false;
        }
    }

    @Override
    public AccessControlManager getAccessControlManager() throws RepositoryException {
        Session providerSession = this.session.getProviderSession(this.provider);
        AccessControlManager accessControlManager = null;
        try {
            accessControlManager = providerSession.getAccessControlManager();
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            logger.warn("Access control manager is not supported for node " + this.getPath() + ": " + uroe.getMessage());
        }
        return accessControlManager;
    }

    @Override
    public Set<String> getPermissions() {
        HashSet<String> result = new HashSet<String>();
        try {
            AccessControlManager accessControlManager = this.getAccessControlManager();
            if (accessControlManager != null) {
                Privilege[] p;
                for (Privilege privilege : p = accessControlManager.getPrivileges(this.localPathInProvider)) {
                    result.add(privilege.getName());
                    if (!privilege.isAggregate()) continue;
                    for (Privilege privilege1 : privilege.getAggregatePrivileges()) {
                        result.add(privilege1.getName());
                    }
                }
            }
        }
        catch (RepositoryException re) {
            logger.error("Cannot check perm ", (Throwable)re);
        }
        return result;
    }

    @Override
    public BitSet getPermissionsAsBitSet() {
        BitSet b = null;
        try {
            AccessControlManager accessControlManager = this.getAccessControlManager();
            if (accessControlManager == null) {
                return b;
            }
            Privilege[] app = accessControlManager.getPrivileges(this.localPathInProvider);
            Privilege[] pr = accessControlManager.getSupportedPrivileges(this.localPathInProvider);
            b = new BitSet(pr.length);
            if (app.length == pr.length) {
                b.set(0, pr.length);
            } else {
                HashSet<Privilege> effective = new HashSet<Privilege>();
                for (Privilege privilege : app) {
                    effective.add(privilege);
                    if (!privilege.isAggregate()) continue;
                    for (Privilege p : privilege.getAggregatePrivileges()) {
                        effective.add(p);
                    }
                }
                int position = 0;
                for (Privilege privilege : pr) {
                    if (effective.contains(privilege)) {
                        b.set(position);
                    }
                    ++position;
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot check perm ", (Throwable)e);
        }
        return b;
    }

    @Override
    public boolean grantRoles(String principalKey, Set<String> roles) throws RepositoryException {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String role : roles) {
            m.put(role, "GRANT");
        }
        return this.changeRoles(principalKey, m);
    }

    @Override
    public boolean denyRoles(String principalKey, Set<String> roles) throws RepositoryException {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String role : roles) {
            m.put(role, "DENY");
        }
        return this.changeRoles(principalKey, m);
    }

    @Override
    public boolean changeRoles(String principalKey, Map<String, String> roles) throws RepositoryException {
        String s;
        Value[] values;
        if (!this.isCheckedOut() && this.isNodeType("mix:versionable")) {
            this.getSession().checkout(this);
        }
        ArrayList<String> gr = new ArrayList<String>();
        ArrayList<String> den = new ArrayList<String>();
        ArrayList<String> rem = new ArrayList<String>();
        for (Map.Entry<String, String> entry : roles.entrySet()) {
            if ("GRANT".equals(entry.getValue())) {
                gr.add(entry.getKey());
                continue;
            }
            if ("DENY".equals(entry.getValue())) {
                den.add(entry.getKey());
                continue;
            }
            if (!"REMOVE".equals(entry.getValue())) continue;
            rem.add(entry.getKey());
        }
        Node acl = this.getOrCreateAcl();
        NodeIterator ni = acl.getNodes();
        Node aceg = null;
        Node aced = null;
        while (ni.hasNext()) {
            Node ace = ni.nextNode();
            if (!ace.isNodeType("jnt:ace") || ace.isNodeType("jnt:externalAce") || !ace.getProperty("j:principal").getString().equals(principalKey)) continue;
            if (ace.getProperty("j:aceType").getString().equals("GRANT")) {
                aceg = ace;
                continue;
            }
            aced = ace;
        }
        if (aceg == null) {
            aceg = acl.addNode("GRANT_" + JCRContentUtils.replaceColon(principalKey).replaceAll("/", "_"), "jnt:ace");
            aceg.setProperty("j:principal", principalKey);
            aceg.setProperty("j:protected", false);
            aceg.setProperty("j:aceType", "GRANT");
        }
        if (aced == null) {
            aced = acl.addNode("DENY_" + JCRContentUtils.replaceColon(principalKey).replaceAll("/", "_"), "jnt:ace");
            aced.setProperty("j:principal", principalKey);
            aced.setProperty("j:protected", false);
            aced.setProperty("j:aceType", "DENY");
        }
        ArrayList<String> grClone = new ArrayList<String>(gr);
        ArrayList<String> denClone = new ArrayList<String>(den);
        if (aceg.hasProperty("j:roles")) {
            for (Value value : values = aceg.getProperty("j:roles").getValues()) {
                s = value.getString();
                if (gr.contains(s) || den.contains(s) || rem.contains(s)) continue;
                grClone.add(s);
            }
        }
        if (aced.hasProperty("j:roles")) {
            for (Value value : values = aced.getProperty("j:roles").getValues()) {
                s = value.getString();
                if (gr.contains(s) || den.contains(s) || rem.contains(s)) continue;
                denClone.add(s);
            }
        }
        String[] grs = new String[grClone.size()];
        grClone.toArray(grs);
        if (grs.length == 0) {
            aceg.remove();
        } else {
            aceg.setProperty("j:roles", grs);
        }
        String[] dens = new String[denClone.size()];
        denClone.toArray(dens);
        if (dens.length == 0) {
            aced.remove();
        } else {
            aced.setProperty("j:roles", dens);
        }
        this.aclEntries = null;
        return true;
    }

    @Override
    public boolean revokeRolesForPrincipal(String principalKey) throws RepositoryException {
        boolean modified = false;
        Node acl = this.getOrCreateAcl();
        NodeIterator ni = acl.getNodes();
        while (ni.hasNext()) {
            Node ace = ni.nextNode();
            if (!ace.isNodeType("jnt:ace") || ace.isNodeType("jnt:externalAce") || !ace.getProperty("j:principal").getString().equals(principalKey)) continue;
            ace.remove();
            modified = true;
        }
        if (modified) {
            this.aclEntries = null;
        }
        return true;
    }

    @Override
    public boolean revokeAllRoles() throws RepositoryException {
        boolean modified = false;
        if (this.hasNode("j:acl")) {
            JCRNodeWrapper acl = this.getNode("j:acl");
            JCRNodeIteratorWrapper ni = acl.getNodes();
            while (ni.hasNext()) {
                Node ace = ni.nextNode();
                if (!ace.isNodeType("jnt:ace") || ace.isNodeType("jnt:externalAce")) continue;
                ace.remove();
                modified = true;
            }
            if (!acl.hasNodes()) {
                acl.remove();
                modified = true;
                if (this.isNodeType("jmix:accessControlled")) {
                    this.removeMixin("jmix:accessControlled");
                }
            }
            if (modified) {
                this.aclEntries = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setAclInheritanceBreak(boolean breakAclInheritance) throws RepositoryException {
        try {
            boolean inheritAcl = !breakAclInheritance;
            Node aclNode = this.getOrCreateAcl();
            if (!aclNode.hasProperty("j:inherit") || aclNode.getProperty("j:inherit").getBoolean() != inheritAcl) {
                aclNode.setProperty("j:inherit", inheritAcl);
                this.aclEntries = null;
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot change acl", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean getAclInheritanceBreak() throws RepositoryException {
        if (this.hasNode("j:acl")) {
            JCRNodeWrapper acl = this.getNode("j:acl");
            return acl.hasProperty("j:inherit") && !acl.getProperty("j:inherit").getBoolean();
        }
        return false;
    }

    public Node getOrCreateAcl() throws RepositoryException {
        if (this.hasNode("j:acl")) {
            return this.getNode("j:acl");
        }
        if (!this.isCheckedOut()) {
            this.checkout();
        }
        this.addMixin("jmix:accessControlled");
        return this.addNode("j:acl", "jnt:acl");
    }

    @Override
    public JCRNodeWrapper createCollection(String name) throws RepositoryException {
        return this.addNode(name, "jnt:folder");
    }

    @Override
    public JCRNodeWrapper uploadFile(String name, InputStream is, String contentType) throws RepositoryException {
        JCRLockUtils.checkLock(this, false, true);
        name = JCRContentUtils.escapeLocalNodeName(FilenameUtils.getName((String)name));
        JCRNodeWrapper file = null;
        try {
            file = this.getNode(name);
            if (!file.isCheckedOut()) {
                file.getSession().checkout(file);
            }
        }
        catch (PathNotFoundException e) {
            logger.debug("file {} does not exist, creating...", (Object)name);
            if (!this.isCheckedOut()) {
                this.getSession().checkout(this);
            }
            file = this.addNode(name, "jnt:file");
        }
        if (file != null) {
            file.getFileContent().uploadFile(is, contentType);
        } else {
            logger.error("can't write to file " + name + " because it doesn't exist");
        }
        return file;
    }

    @Override
    public JCRNodeWrapper addNode(String name) throws RepositoryException {
        JCRLockUtils.checkLock(this, false, true);
        Node n = this.objectNode.addNode(name);
        return this.provider.getNodeWrapper(n, this.buildSubnodePath(name), this, this.session);
    }

    protected String buildSubnodePath(String name) {
        if (this.localPath.equals("/")) {
            return this.localPath + name;
        }
        return this.localPath + "/" + name;
    }

    @Override
    public JCRNodeWrapper addNode(String name, String type) throws RepositoryException {
        JCRLockUtils.checkLock(this, false, true);
        Node n = this.objectNode.addNode(name, type);
        JCRNodeWrapper newNode = this.provider.getNodeWrapper(n, this.buildSubnodePath(name), this, this.session);
        this.session.registerNewNode(newNode);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRNodeWrapper addNode(String name, String type, String identifier, Calendar created, String createdBy, Calendar lastModified, String lastModifiedBy) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        JCRLockUtils.checkLock(this, false, true);
        if (this.objectNode instanceof NodeImpl) {
            JahiaSessionImpl jrSession = (JahiaSessionImpl)this.objectNode.getSession();
            jrSession.getNodeTypeInstanceHandler().setCreated(created);
            jrSession.getNodeTypeInstanceHandler().setCreatedBy(createdBy);
            jrSession.getNodeTypeInstanceHandler().setLastModified(lastModified);
            jrSession.getNodeTypeInstanceHandler().setLastModifiedBy(lastModifiedBy);
            try {
                if (identifier != null) {
                    Name jahiaName = new Name(name, NodeTypeRegistry.getInstance().getNamespaces());
                    org.apache.jackrabbit.spi.Name qname = NameFactoryImpl.getInstance().create(jahiaName.getUri() == null ? "" : jahiaName.getUri(), jahiaName.getLocalName());
                    org.apache.jackrabbit.spi.Name typeName = null;
                    if (type != null) {
                        Name jahiaTypeName = NodeTypeRegistry.getInstance().getNodeType(type).getNameObject();
                        typeName = NameFactoryImpl.getInstance().create(jahiaTypeName.getUri(), jahiaTypeName.getLocalName());
                    }
                    NodeImpl child = ((NodeImpl)this.objectNode).addNode(qname, typeName, NodeId.valueOf((String)identifier));
                    JCRNodeWrapper jCRNodeWrapper = this.provider.getNodeWrapper((Node)child, this.buildSubnodePath(name), this, this.session);
                    return jCRNodeWrapper;
                }
                JCRNodeWrapper jCRNodeWrapper = this.addNode(name, type);
                return jCRNodeWrapper;
            }
            finally {
                jrSession.getNodeTypeInstanceHandler().setCreated(null);
                jrSession.getNodeTypeInstanceHandler().setCreatedBy(null);
                jrSession.getNodeTypeInstanceHandler().setLastModified(null);
                jrSession.getNodeTypeInstanceHandler().setLastModifiedBy(null);
            }
        }
        return this.addNode(name, type);
    }

    @Override
    public JCRPlaceholderNode getPlaceholder() throws RepositoryException {
        return new JCRPlaceholderNode(this);
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.objectNode.getUUID();
    }

    @Override
    public String getAbsoluteUrl(ServletRequest request) {
        return this.provider.getAbsoluteContextPath(request) + this.getUrl();
    }

    @Override
    public String getUrl() {
        try {
            if (this.isNodeType("nt:file")) {
                return this.provider.getHttpPath() + "/" + this.getSession().getWorkspace().getName() + Text.escapePath((String)this.getCanonicalPath());
            }
            String path = JCRSessionFactory.getInstance().getCurrentServletPath();
            if (path == null) {
                path = "/cms/render";
            }
            return Jahia.getContextPath() + path + "/" + this.getSession().getWorkspace().getName() + "/" + this.getSession().getLocale() + Text.escapePath((String)this.getPath()) + ".html";
        }
        catch (RepositoryException e) {
            logger.error("Cannot get type", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getAbsoluteWebdavUrl(HttpServletRequest request) {
        return this.provider.getAbsoluteContextPath((ServletRequest)request) + this.getWebdavUrl();
    }

    @Override
    public String getWebdavUrl() {
        return Jahia.getContextPath() + this.provider.getWebdavPath() + "/" + this.session.getWorkspace().getName() + this.localPathInProvider;
    }

    @Override
    public List<String> getThumbnails() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            NodeIterator ni = this.objectNode.getNodes();
            while (ni.hasNext()) {
                Node node = ni.nextNode();
                String name = node.getName();
                if (name.equals("jcr:content") || !node.isNodeType("jnt:resource") && (!node.isNodeType("nt:frozenNode") || !"jnt:resource".equals(node.getProperty("jcr:frozenPrimaryType").getString()))) continue;
                names.add(name);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return names;
    }

    @Override
    public String getThumbnailUrl(String name) {
        String url = this.getUrl();
        return url + (url.indexOf(63) != -1 ? "&" : "?") + "t=" + name;
    }

    @Override
    public Map<String, String> getThumbnailUrls() {
        List<String> list = this.getThumbnails();
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (String thumbnailName : list) {
            map.put(thumbnailName, this.getThumbnailUrl(thumbnailName));
        }
        return map;
    }

    @Override
    public JCRNodeWrapper getNode(String s) throws PathNotFoundException, RepositoryException {
        Node node;
        if (this.objectNode.hasNode(s) && !this.isExternalRoot(node = this.objectNode.getNode(s))) {
            return s.indexOf(47) == -1 ? this.provider.getNodeWrapper(node, this.buildSubnodePath(s), this, this.session) : this.provider.getNodeWrapper(node, this.session);
        }
        if (this.provider.getService() != null && this.provider.getSessionFactory().areMultipleMountPointsRegistered()) {
            String targetPath = this.getPath() + '/' + s;
            JCRStoreProvider targetProvider = this.provider.getSessionFactory().getProvider(targetPath, false);
            if (targetProvider != null && targetProvider != this.provider) {
                String childPath;
                JCRNodeWrapper providerRoot = targetProvider.getNodeWrapper(this.session.getProviderSession(targetProvider).getNode(targetProvider.getRelativeRoot().isEmpty() ? "/" : targetProvider.getRelativeRoot()), "/", this, this.session);
                if (!targetProvider.getMountPoint().equals(targetPath) && (childPath = StringUtils.substringAfter((String)targetPath, (String)(targetProvider.getMountPoint() + "/"))).length() > 0) {
                    return providerRoot.getNode(childPath);
                }
                return providerRoot;
            }
        }
        throw new PathNotFoundException(s);
    }

    private boolean isExternalRoot(Node node) throws RepositoryException, ValueFormatException, PathNotFoundException {
        return node.hasProperty("j:isExternalProviderRoot") && node.getProperty("j:isExternalProviderRoot").getBoolean() || this.provider.getSessionFactory().getMountPoints().containsKey(node.getPath());
    }

    @Override
    public JCRNodeIteratorWrapper getNodes() throws RepositoryException {
        return this.getNodes(null, null);
    }

    @Override
    public JCRNodeIteratorWrapper getNodes(String namePattern) throws RepositoryException {
        return this.getNodes(namePattern, null);
    }

    @Override
    public JCRNodeIteratorWrapper getNodes(String[] nameGlobs) throws RepositoryException {
        return this.getNodes(null, nameGlobs);
    }

    protected JCRNodeIteratorWrapper getNodes(String namePattern, String[] nameGlobs) throws RepositoryException {
        LinkedList<JCRNodeWrapper> list = null;
        LinkedList<String> mounts = null;
        if (this.provider.getService() != null && this.provider.getSessionFactory().areMultipleMountPointsRegistered()) {
            Map<String, JCRStoreProvider> mountPoints = this.provider.getSessionFactory().getMountPoints();
            String path = this.getPath();
            for (Map.Entry<String, JCRStoreProvider> entry : mountPoints.entrySet()) {
                int pos;
                String mpp;
                String key = entry.getKey();
                if (entry.getValue().isDefault() || !key.startsWith(path) || !(mpp = (pos = key.lastIndexOf(47)) > 0 ? key.substring(0, pos) : "/").equals(path)) continue;
                String name = key.substring(pos + 1);
                if ((namePattern != null || nameGlobs != null) && (key.length() <= pos + 1 || (namePattern == null || !ChildrenCollectorFilter.matches((String)name, (String)namePattern)) && (nameGlobs == null || !ChildrenCollectorFilter.matches((String)name, (String[])nameGlobs)))) continue;
                JCRStoreProvider storeProvider = entry.getValue();
                String root = storeProvider.getRelativeRoot();
                try {
                    Node node = this.session.getProviderSession(storeProvider).getNode(root.length() == 0 ? "/" : root);
                    if (list == null) {
                        list = new LinkedList<JCRNodeWrapper>();
                        mounts = new LinkedList<String>();
                    }
                    list.add(storeProvider.getNodeWrapper(node, "/", this, this.session));
                    mounts.add(name);
                }
                catch (PathNotFoundException pathNotFoundException) {}
            }
        }
        NodeIterator ni = namePattern != null ? this.objectNode.getNodes(namePattern) : (nameGlobs != null ? this.objectNode.getNodes(nameGlobs) : this.objectNode.getNodes());
        return new ChildNodesIterator(ni, mounts, list, this, this.session, this.provider);
    }

    @Override
    public Map<String, String> getPropertiesAsString() throws RepositoryException {
        HashMap<String, String> res = new HashMap<String, String>();
        PropertyIterator pi = this.getProperties();
        if (pi != null) {
            while (pi.hasNext()) {
                Property p = pi.nextProperty();
                if (p.getType() == 2) continue;
                if (!p.isMultiple()) {
                    res.put(p.getName(), p.getString());
                    continue;
                }
                Value[] vs = p.getValues();
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < vs.length; ++i) {
                    Value v = vs[i];
                    b.append(v.getString());
                    if (i + 1 >= vs.length) continue;
                    b.append(" ");
                }
                res.put(p.getName(), b.toString());
            }
        }
        return res;
    }

    @Override
    public String getName() {
        try {
            if ((this.localPathInProvider.equals("/") || this.localPathInProvider.equals(this.provider.getRelativeRoot())) && this.provider.getMountPoint().length() > 1) {
                String mp = this.provider.getMountPoint();
                return mp.substring(mp.lastIndexOf(47) + 1);
            }
            return this.objectNode.getName();
        }
        catch (RepositoryException e) {
            logger.error("Repository error unable to read node {}", (Object)this.localPath, (Object)e);
            return null;
        }
    }

    @Override
    public ExtendedNodeType getPrimaryNodeType() throws RepositoryException {
        try {
            return NodeTypeRegistry.getInstance().getNodeType(this.objectNode.getPrimaryNodeType().getName());
        }
        catch (NoSuchNodeTypeException e) {
            return NodeTypeRegistry.getInstance().getNodeType("nt:base");
        }
    }

    @Override
    public String getPrimaryNodeTypeName() throws RepositoryException {
        String name = this.objectNode.getPrimaryNodeType().getName();
        if (NodeTypeRegistry.getInstance().hasNodeType(name)) {
            return name;
        }
        return "nt:base";
    }

    @Override
    public ExtendedNodeType[] getMixinNodeTypes() throws RepositoryException {
        NodeType[] mixinNodeTypes;
        ArrayList<ExtendedNodeType> l = null;
        for (NodeType nodeType : mixinNodeTypes = this.objectNode.getMixinNodeTypes()) {
            try {
                if (l == null) {
                    l = new ArrayList<ExtendedNodeType>(mixinNodeTypes.length);
                }
                l.add(NodeTypeRegistry.getInstance().getNodeType(nodeType.getName()));
            }
            catch (NoSuchNodeTypeException e) {
                logger.debug("Skipping missing mixin {}", (Object)nodeType.getName());
            }
        }
        return l != null ? l.toArray(new ExtendedNodeType[l.size()]) : EMPTY_EXTENDED_NODE_TYPE_ARRAY;
    }

    public ExtendedNodeType[] getOriginalMixinNodeTypes() throws RepositoryException {
        if (this.originalMixins == null) {
            this.originalMixins = this.getMixinNodeTypes();
        }
        return this.originalMixins;
    }

    public void addMixin(String s) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkLock();
        try {
            this.getOriginalMixinNodeTypes();
            this.objectNode.addMixin(s);
        }
        finally {
            this.flushLocalCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkLock();
        NodeTypeRegistry nodeTypeRegistry = NodeTypeRegistry.getInstance();
        ExtendedNodeType mixin = nodeTypeRegistry.getNodeType(mixinName);
        try {
            this.getOriginalMixinNodeTypes();
            this.objectNode.removeMixin(mixinName);
            if (!mixin.getChildNodeDefinitionsAsMap().isEmpty()) {
                this.getSession().flushCaches();
            }
        }
        finally {
            this.flushLocalCaches();
        }
        NodeIterator translationNodes = this.objectNode.getNodes(TRANSLATION_NODES_PATTERN);
        while (translationNodes.hasNext()) {
            Node translationNode = translationNodes.nextNode();
            PropertyIterator properties = translationNode.getProperties();
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                if (!property.getDefinition().getName().equals("*")) {
                    logger.debug("removeMixin - preserving property '{}'", (Object)property.getPath());
                    continue;
                }
                ExtendedPropertyDefinition propertyDefinition = this.getApplicablePropertyDefinition(property.getName(), property.getType(), false);
                if (propertyDefinition == null) {
                    propertyDefinition = this.getApplicablePropertyDefinition(property.getName(), property.getType(), true);
                }
                if (propertyDefinition != null && propertyDefinition.isInternationalized()) {
                    logger.debug("removeMixin - preserving property '{}'", (Object)property.getPath());
                    continue;
                }
                logger.debug("removeMixin - removing property '{}'", (Object)property.getPath());
                property.remove();
            }
        }
    }

    public boolean canAddMixin(String s) throws NoSuchNodeTypeException, RepositoryException {
        try {
            this.checkLock();
        }
        catch (LockException e) {
            return false;
        }
        return this.objectNode.canAddMixin(s);
    }

    @Override
    public ExtendedNodeDefinition getDefinition() throws RepositoryException {
        NodeDefinition definition = this.objectNode.getDefinition();
        if (definition == null) {
            return null;
        }
        ExtendedNodeType nt = NodeTypeRegistry.getInstance().getNodeType(definition.getDeclaringNodeType().getName());
        if (definition.getName().equals("*")) {
            for (ExtendedNodeDefinition d : nt.getUnstructuredChildNodeDefinitions().values()) {
                ExtendedNodeType[] requiredPrimaryTypes = d.getRequiredPrimaryTypes();
                NodeType[] a2 = definition.getRequiredPrimaryTypes();
                boolean valid = true;
                for (ExtendedNodeType extendedNodeType : requiredPrimaryTypes) {
                    boolean found = false;
                    for (NodeType nodeType : a2) {
                        if (!nodeType.getName().equals(extendedNodeType.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                return d;
            }
        } else {
            return nt.getNodeDefinition(definition.getName());
        }
        return null;
    }

    @Override
    public List<String> getNodeTypes() throws RepositoryException {
        ArrayList<String> results = new ArrayList<String>();
        if (NodeTypeRegistry.getInstance().hasNodeType(this.objectNode.getPrimaryNodeType().getName())) {
            results.add(this.objectNode.getPrimaryNodeType().getName());
        } else {
            results.add("nt:base");
        }
        NodeType[] mixin = this.objectNode.getMixinNodeTypes();
        for (int i = 0; i < mixin.length; ++i) {
            NodeType mixinType = mixin[i];
            if (!NodeTypeRegistry.getInstance().hasNodeType(mixinType.getName())) continue;
            results.add(mixinType.getName());
        }
        return results;
    }

    public boolean isNodeType(String type) throws RepositoryException {
        return "nt:base".equals(type) || this.objectNode.isNodeType(type);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isFile() {
        try {
            return this.isNodeType("nt:file");
        }
        catch (RepositoryException e) {
            logger.error("Cannot get type", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isPortlet() {
        try {
            return this.isNodeType("jnt:portlet");
        }
        catch (RepositoryException e) {
            logger.error("Cannot get type", (Throwable)e);
            return false;
        }
    }

    @Override
    public Date getLastModifiedAsDate() {
        try {
            return this.objectNode.getProperty("jcr:lastModified").getDate().getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Date getContentLastModifiedAsDate() {
        try {
            Node content = this.objectNode.getNode("jcr:content");
            return content.getProperty("jcr:lastModified").getDate().getTime();
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Date getLastPublishedAsDate() {
        try {
            return this.objectNode.getProperty("j:lastPublished").getDate().getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Date getContentLastPublishedAsDate() {
        try {
            Node content = this.objectNode.getNode("jcr:content");
            return content.getProperty("j:lastPublished").getDate().getTime();
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Date getCreationDateAsDate() {
        try {
            return this.objectNode.getProperty("jcr:created").getDate().getTime();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    @Override
    public String getCreationUser() {
        try {
            return this.objectNode.getProperty("jcr:createdBy").getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    @Override
    public String getModificationUser() {
        try {
            return this.objectNode.getProperty("jcr:lastModifiedBy").getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    @Override
    public String getPublicationUser() {
        try {
            return this.objectNode.getProperty("j:lastPublishedBy").getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    @Override
    public String getLanguage() {
        String language = null;
        try {
            if ("jnt:translation".equals(this.getPrimaryNodeTypeName())) {
                language = this.getProperty("jcr:language").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (language == null && this.getSession().getLocale() != null) {
            try {
                language = this.getI18N(this.getSession().getLocale()).getProperty("jcr:language").getString();
            }
            catch (Exception e) {
                language = this.getSession().getLocale().toString();
            }
        }
        return language;
    }

    @Override
    public List<Locale> getExistingLocales() throws RepositoryException {
        ArrayList<Locale> r = new ArrayList<Locale>();
        NodeIterator ni = this.getI18Ns();
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            r.add(LanguageCodeConverters.languageCodeToLocale(n.getProperty("jcr:language").getString()));
        }
        return r;
    }

    @Override
    public Node getI18N(Locale locale) throws RepositoryException {
        return this.getI18N(locale, true);
    }

    @Override
    public boolean hasI18N(Locale locale) throws RepositoryException {
        return this.hasI18N(locale, true);
    }

    @Override
    public boolean hasI18N(Locale locale, boolean fallback) throws RepositoryException {
        return this.hasI18N(locale, fallback, true);
    }

    private boolean hasI18N(Locale locale, boolean fallback, boolean checkPublication) throws RepositoryException {
        Locale fallbackLocale;
        boolean b = this.checkI18NNode(locale, checkPublication);
        if (!b && fallback && (fallbackLocale = this.getSession().getFallbackLocale()) != null && fallbackLocale != locale) {
            b = this.checkI18NNode(fallbackLocale, checkPublication);
        }
        return b;
    }

    private boolean checkI18NNode(Locale locale, boolean checkPublication) throws RepositoryException {
        boolean b = false;
        String transName = JCRNodeWrapperImpl.getTranslationNodeName(locale);
        if (this.i18NobjectNodes != null && this.i18NobjectNodes.containsKey(locale) || this.objectNode.hasNode(transName)) {
            Node node;
            b = checkPublication && "live".equals(this.session.getWorkspace().getName()) ? !(node = this.objectNode.getNode(transName)).hasProperty("j:published") || node.getProperty("j:published").getBoolean() : true;
        }
        return b;
    }

    static String getTranslationNodeName(Locale locale) {
        return TRANSLATION_PREFIX + locale;
    }

    @Override
    public Node getI18N(Locale locale, boolean fallback) throws RepositoryException {
        Locale fallbackLocale;
        if (this.i18NobjectNodes == null) {
            this.i18NobjectNodes = new HashMap<Locale, Node>();
        }
        if (this.i18NobjectNodes.containsKey(locale)) {
            Node node = this.i18NobjectNodes.get(locale);
            if (node != null) {
                return node;
            }
        } else {
            String translationNodeName = JCRNodeWrapperImpl.getTranslationNodeName(locale);
            if (this.objectNode.hasNode(translationNodeName)) {
                Node node = this.objectNode.getNode(translationNodeName);
                if (!"live".equals(this.session.getWorkspace().getName()) || !node.hasProperty("j:published") || node.getProperty("j:published").getBoolean()) {
                    this.i18NobjectNodes.put(locale, node);
                    return node;
                }
            }
        }
        if (fallback && (fallbackLocale = this.getSession().getFallbackLocale()) != null && fallbackLocale != locale) {
            return this.getI18N(fallbackLocale);
        }
        throw new ItemNotFoundException(locale.toString());
    }

    @Override
    public NodeIterator getI18Ns() throws RepositoryException {
        return this.objectNode.getNodes("j:translation*");
    }

    @Override
    public Node getOrCreateI18N(Locale locale) throws RepositoryException {
        try {
            return this.getI18N(locale, false);
        }
        catch (RepositoryException e) {
            Node t = this.objectNode.addNode(JCRNodeWrapperImpl.getTranslationNodeName(locale), "jnt:translation");
            t.setProperty("jcr:language", locale.toString());
            this.i18NobjectNodes.put(locale, t);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getOrCreateI18N(Locale locale, Calendar created, String createdBy, Calendar lastModified, String lastModifiedBy) throws RepositoryException {
        JahiaSessionImpl jrSession = (JahiaSessionImpl)this.objectNode.getSession();
        try {
            return this.getI18N(locale, false);
        }
        catch (RepositoryException e) {
            try {
                jrSession.getNodeTypeInstanceHandler().setCreated(created);
                jrSession.getNodeTypeInstanceHandler().setCreatedBy(createdBy);
                jrSession.getNodeTypeInstanceHandler().setLastModified(lastModified);
                jrSession.getNodeTypeInstanceHandler().setLastModifiedBy(lastModifiedBy);
                Node t = this.objectNode.addNode(JCRNodeWrapperImpl.getTranslationNodeName(locale), "jnt:translation");
                t.setProperty("jcr:language", locale.toString());
                this.i18NobjectNodes.put(locale, t);
                Node node = t;
                return node;
            }
            finally {
                jrSession.getNodeTypeInstanceHandler().setCreated(null);
                jrSession.getNodeTypeInstanceHandler().setCreatedBy(null);
                jrSession.getNodeTypeInstanceHandler().setLastModified(null);
                jrSession.getNodeTypeInstanceHandler().setLastModifiedBy(null);
            }
        }
    }

    @Override
    public JCRPropertyWrapper getProperty(String name) throws PathNotFoundException, RepositoryException {
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(name);
        if (epd != null) {
            return this.internalGetProperty(name, epd);
        }
        throw new PathNotFoundException(name);
    }

    private JCRPropertyWrapper internalGetProperty(String name, ExtendedPropertyDefinition epd) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (epd == null) {
            epd = this.getApplicablePropertyDefinition(name);
        }
        if (epd == null) {
            throw new PathNotFoundException(name);
        }
        if (locale != null && epd.isInternationalized()) {
            Pattern pathPattern = JCRContentUtils.getInstance().getHandleFallbackLocaleForPathPattern();
            if (pathPattern == null || locale.equals(SettingsBean.getInstance().getDefaultLocale())) {
                try {
                    Node localizedNode = this.getI18N(locale);
                    return new JCRPropertyWrapperImpl(this, localizedNode.getProperty(name), this.session, this.provider, epd, name);
                }
                catch (ItemNotFoundException e) {
                    return new JCRPropertyWrapperImpl(this, this.objectNode.getProperty(name), this.session, this.provider, epd);
                }
            }
            return this.internalGetPropertyI18nWithDefFallback(name, epd, locale, pathPattern);
        }
        return new JCRPropertyWrapperImpl(this, this.objectNode.getProperty(name), this.session, this.provider, epd);
    }

    private JCRPropertyWrapper internalGetPropertyI18nWithDefFallback(String name, ExtendedPropertyDefinition epd, Locale locale, Pattern pathPattern) throws RepositoryException {
        Node localizedNode = null;
        try {
            localizedNode = this.getI18N(locale);
            return new JCRPropertyWrapperImpl(this, localizedNode.getProperty(name), this.session, this.provider, epd, name);
        }
        catch (ItemNotFoundException e) {
            try {
                return new JCRPropertyWrapperImpl(this, this.objectNode.getProperty(name), this.session, this.provider, epd);
            }
            catch (PathNotFoundException pnte) {
                if (pathPattern.matcher(this.getPath()).matches()) {
                    try {
                        localizedNode = this.getI18N(SettingsBean.getInstance().getDefaultLocale());
                        return new JCRPropertyWrapperImpl(this, localizedNode.getProperty(name), this.session, this.provider, epd, name);
                    }
                    catch (ItemNotFoundException e2) {
                        throw pnte;
                    }
                }
                throw pnte;
            }
        }
        catch (PathNotFoundException e) {
            if (pathPattern.matcher(this.getPath()).matches()) {
                try {
                    localizedNode = this.getI18N(SettingsBean.getInstance().getDefaultLocale());
                    return new JCRPropertyWrapperImpl(this, localizedNode.getProperty(name), this.session, this.provider, epd, name);
                }
                catch (ItemNotFoundException e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public PropertyIterator getProperties() throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator(this, locale);
        }
        return new LazyPropertyIterator(this, null);
    }

    public PropertyIterator getProperties(String s) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator((JCRNodeWrapper)this, locale, s);
        }
        return new LazyPropertyIterator((JCRNodeWrapper)this, null, s);
    }

    @Override
    public String getPropertyAsString(String name) {
        try {
            JCRPropertyWrapper property = this.getProperty(name);
            if (property == null) {
                return null;
            }
            if (property.getType() == 2) {
                return null;
            }
            if (!property.isMultiple()) {
                return property.getString();
            }
            Value[] vs = property.getValues();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < vs.length; ++i) {
                Value v = vs[i];
                b.append(v.getString());
                if (i + 1 >= vs.length) continue;
                b.append(" ");
            }
            return b.toString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    private String ensurePrefixedName(String name) {
        if (!name.startsWith("{")) {
            return name;
        }
        Name nameObj = new Name(name, NodeTypeRegistry.getInstance().getNamespaces());
        return StringUtils.isEmpty((String)nameObj.getPrefix()) ? nameObj.getLocalName() : nameObj.getPrefix() + ":" + nameObj.getLocalName();
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.hasPropertyCache.remove(name);
        name = this.ensurePrefixedName(name);
        Locale locale = this.getSession().getLocale();
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(name);
        if (epd == null) {
            throw new ConstraintViolationException("Couldn't find definition for property " + name);
        }
        if (value != null && 0 != epd.getRequiredType() && value.getType() != epd.getRequiredType() && (value.getType() != 10 || epd.getRequiredType() != 9)) {
            value = this.getSession().getValueFactory().createValue(value.getString(), epd.getRequiredType());
        }
        if (!(this.session.isSystem() || epd.isProtected() || epd.getDeclaringNodeType().canSetProperty(epd.getName(), value))) {
            throw new ConstraintViolationException("Invalid value for : " + epd.getName());
        }
        JCRLockUtils.checkLock(this, locale != null && epd.isInternationalized(), false);
        value = JCRStoreService.getInstance().getInterceptorChain().beforeSetValue(this, name, epd, value);
        if (locale != null && epd.isInternationalized()) {
            if (value == null) {
                this.getOrCreateI18N(locale).setProperty(name, (Value)null);
                return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd, name);
            }
            return new JCRPropertyWrapperImpl(this, this.getOrCreateI18N(locale).setProperty(name, value), this.session, this.provider, epd, name);
        }
        if (value == null) {
            this.objectNode.setProperty(name, (Value)null);
            return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd);
        }
        return new JCRPropertyWrapperImpl(this, this.objectNode.setProperty(name, value), this.session, this.provider, epd);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.hasPropertyCache.remove(name);
        Locale locale = this.getSession().getLocale();
        name = this.ensurePrefixedName(name);
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(name);
        if (epd == null) {
            throw new ConstraintViolationException("Couldn't find definition for property " + name);
        }
        if (!(this.session.isSystem() || epd.isProtected() || epd.getDeclaringNodeType().canSetProperty(epd.getName(), value))) {
            throw new ConstraintViolationException("Invalid value for : " + epd.getName());
        }
        JCRLockUtils.checkLock(this, locale != null && epd.isInternationalized(), false);
        value = JCRStoreService.getInstance().getInterceptorChain().beforeSetValue(this, name, epd, value);
        if (locale != null && epd.isInternationalized()) {
            return new JCRPropertyWrapperImpl(this, this.getOrCreateI18N(locale).setProperty(name, value, type), this.session, this.provider, epd, name);
        }
        if (value == null) {
            this.objectNode.setProperty(name, (Value)null);
            return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd);
        }
        return new JCRPropertyWrapperImpl(this, this.objectNode.setProperty(name, value, type), this.session, this.provider, epd);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.hasPropertyCache.remove(name);
        Locale locale = this.getSession().getLocale();
        name = this.ensurePrefixedName(name);
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(name);
        if (epd == null) {
            throw new ConstraintViolationException("Couldn't find definition for property " + name);
        }
        if (values != null) {
            Value[] valuesCopy = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesCopy[i] = values[i] != null && 0 != epd.getRequiredType() && values[i].getType() != epd.getRequiredType() && (values[i].getType() != 10 || epd.getRequiredType() != 9) ? this.getSession().getValueFactory().createValue(values[i].getString(), epd.getRequiredType()) : values[i];
            }
            values = valuesCopy;
        }
        if (!(this.session.isSystem() || epd.isProtected() || epd.getDeclaringNodeType().canSetProperty(epd.getName(), values))) {
            throw new ConstraintViolationException("Invalid value for : " + epd.getName());
        }
        JCRLockUtils.checkLock(this, locale != null && epd.isInternationalized(), false);
        values = JCRStoreService.getInstance().getInterceptorChain().beforeSetValues(this, name, epd, values);
        if (locale != null && epd.isInternationalized()) {
            if (values == null) {
                this.getOrCreateI18N(locale).setProperty(name, (Value[])null);
                return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd);
            }
            return new JCRPropertyWrapperImpl(this, this.getOrCreateI18N(locale).setProperty(name, values), this.session, this.provider, epd, name);
        }
        if (values == null) {
            this.objectNode.setProperty(name, (Value[])null);
            return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd);
        }
        return new JCRPropertyWrapperImpl(this, this.objectNode.setProperty(name, values), this.session, this.provider, epd);
    }

    @Override
    public JCRPropertyWrapper setProperty(String namespace, String name, String value) throws RepositoryException {
        String pref = this.objectNode.getSession().getNamespacePrefix(namespace);
        String key = pref + ":" + name;
        return this.setProperty(key, value);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Locale locale = this.getSession().getLocale();
        this.hasPropertyCache.remove(name);
        name = this.ensurePrefixedName(name);
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(name);
        if (epd == null) {
            throw new ConstraintViolationException("Couldn't find definition for property " + name);
        }
        if (!(this.session.isSystem() || epd.isProtected() || epd.getDeclaringNodeType().canSetProperty(epd.getName(), values))) {
            throw new ConstraintViolationException("Invalid value for : " + epd.getName());
        }
        JCRLockUtils.checkLock(this, locale != null && epd.isInternationalized(), false);
        values = JCRStoreService.getInstance().getInterceptorChain().beforeSetValues(this, name, epd, values);
        if (locale != null && epd.isInternationalized()) {
            if (values == null) {
                this.getOrCreateI18N(locale).setProperty(name, (Value[])null);
                return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd);
            }
            return new JCRPropertyWrapperImpl(this, this.getOrCreateI18N(locale).setProperty(name, values, type), this.session, this.provider, epd, name);
        }
        if (values == null) {
            this.objectNode.setProperty(name, (Value[])null);
            return new JCRPropertyWrapperImpl(this, null, this.session, this.provider, epd);
        }
        return new JCRPropertyWrapperImpl(this, this.objectNode.setProperty(name, values, type), this.session, this.provider, epd);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] v = null;
        if (values != null) {
            v = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                v[i] = values[i] != null ? this.getSession().getValueFactory().createValue(values[i]) : null;
            }
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] v = null;
        if (values != null) {
            v = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                v[i] = values[i] != null ? this.getSession().getValueFactory().createValue(values[i], type) : null;
            }
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value, type);
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = this.getSession().getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = this.getSession().getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = this.getSession().getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, RepositoryException {
        Value v = null;
        if (value != null) {
            ExtendedPropertyDefinition epd;
            if (value instanceof JCRNodeWrapper) {
                value = ((JCRNodeWrapper)value).getRealNode();
            }
            if ((epd = this.getApplicablePropertyDefinition(name)) != null) {
                v = this.getSession().getValueFactory().createValue(value, true);
            }
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public boolean hasProperty(String propertyName) throws RepositoryException {
        if (this.hasPropertyCache.containsKey(propertyName)) {
            return this.hasPropertyCache.get(propertyName);
        }
        boolean result = this.internalHasProperty(propertyName);
        this.hasPropertyCache.put(propertyName, result);
        return result;
    }

    private boolean internalHasProperty(String propertyName) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(propertyName);
        if (epd == null) {
            return false;
        }
        if (locale != null && !propertyName.equals("jcr:language")) {
            try {
                if (epd.isInternationalized() && this.hasI18N(locale, true)) {
                    Node localizedNode = this.getI18N(locale);
                    return localizedNode.hasProperty(propertyName);
                }
            }
            catch (ConstraintViolationException e) {
                return false;
            }
        }
        if (this.objectNode instanceof NodeImpl) {
            return ((NodeImpl)this.objectNode).hasProperty(((SessionImpl)this.objectNode.getSession()).getQName(propertyName));
        }
        return this.objectNode.hasProperty(propertyName);
    }

    public boolean hasProperties() throws RepositoryException {
        boolean result = this.objectNode.hasProperties();
        if (result) {
            return true;
        }
        Locale locale = this.getSession().getLocale();
        if (locale != null && this.hasI18N(locale, true)) {
            return this.getI18N(locale).hasProperties();
        }
        return false;
    }

    @Override
    public List<JCRItemWrapper> getAncestors() throws RepositoryException {
        ArrayList<JCRItemWrapper> ancestors = new ArrayList<JCRItemWrapper>();
        for (int i = 0; i < this.getDepth(); ++i) {
            try {
                ancestors.add(this.getAncestor(i));
                continue;
            }
            catch (AccessDeniedException ade) {
                return ancestors;
            }
        }
        return ancestors;
    }

    @Override
    public boolean rename(String newName) throws RepositoryException {
        this.checkLock();
        this.getSession().checkout(this);
        JCRNodeWrapper parent = this.getParent();
        this.getSession().checkout(parent);
        String nextNodeName = null;
        boolean nodePositionFound = false;
        if (parent.getPrimaryNodeType().hasOrderableChildNodes()) {
            JCRNodeIteratorWrapper nodeIterator = parent.getNodes();
            while (nodeIterator.hasNext()) {
                Node currentNode = nodeIterator.nextNode();
                if (!currentNode.getIdentifier().equals(this.getIdentifier())) continue;
                nodePositionFound = true;
                if (!nodeIterator.hasNext()) break;
                nextNodeName = nodeIterator.nextNode().getName();
                break;
            }
        }
        this.getSession().move(this.getPath(), parent.getPath() + "/" + newName);
        if (this.i18NobjectNodes != null) {
            this.i18NobjectNodes.clear();
        }
        this.localPathInProvider = parent.getPath() + "/" + newName;
        String mountPoint = this.getProvider().getMountPoint();
        if (mountPoint.length() > 1 && this.localPathInProvider.startsWith(mountPoint)) {
            this.localPathInProvider = StringUtils.substringAfter((String)this.localPathInProvider, (String)mountPoint);
        }
        this.localPath = this.localPathInProvider;
        this.objectNode = this.getSession().getProviderSession(this.getProvider()).getNode(this.localPathInProvider);
        if (nodePositionFound && parent.getPrimaryNodeType().hasOrderableChildNodes()) {
            JCRLockUtils.checkLock(parent, false, true);
            parent.getRealNode().orderBefore(newName, nextNodeName);
        }
        return true;
    }

    @Override
    public boolean copy(String dest) throws RepositoryException {
        return this.copy(dest, this.getName());
    }

    @Override
    public boolean copy(String dest, String name) throws RepositoryException {
        return this.copy(dest, name, JCRNodeWrapper.NodeNamingConflictResolutionStrategy.MERGE);
    }

    @Override
    public boolean copy(String dest, String name, JCRNodeWrapper.NodeNamingConflictResolutionStrategy namingConflictResolutionStrategy) throws RepositoryException {
        JCRNodeWrapper node = (JCRNodeWrapper)this.session.getItem(dest);
        boolean sameProvider = this.provider.getKey().equals(node.getProvider().getKey());
        if (!sameProvider) {
            this.copy(node, name, true, namingConflictResolutionStrategy);
            node.save();
        } else {
            this.copy(node, name, true, namingConflictResolutionStrategy);
        }
        return true;
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes) throws RepositoryException {
        return this.copy(dest, name, allowsExternalSharedNodes, JCRNodeWrapper.NodeNamingConflictResolutionStrategy.MERGE);
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, JCRNodeWrapper.NodeNamingConflictResolutionStrategy namingConflictResolutionStrategy) throws RepositoryException {
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        boolean copy = this.copy(dest, name, allowsExternalSharedNodes, references, null, 0, new MutableInt(0), namingConflictResolutionStrategy);
        ReferencesHelper.resolveCrossReferences(this.getSession(), references, false);
        return copy;
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references) throws RepositoryException {
        return this.copy(dest, name, allowsExternalSharedNodes, references, null, 0, new MutableInt(0));
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, List<String> ignoreNodeTypes, int maxBatch) throws RepositoryException {
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        boolean copy = this.copy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, new MutableInt(0));
        ReferencesHelper.resolveCrossReferences(this.getSession(), references, false);
        return copy;
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batchCount) throws RepositoryException {
        return this.copy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount, JCRNodeWrapper.NodeNamingConflictResolutionStrategy.MERGE);
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batchCount, JCRNodeWrapper.NodeNamingConflictResolutionStrategy namingConflictResolutionStrategy) throws RepositoryException {
        return this.internalCopy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount, true, namingConflictResolutionStrategy);
    }

    public boolean internalCopy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batchCount, boolean isTopObject) throws RepositoryException {
        return this.internalCopy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount, isTopObject, JCRNodeWrapper.NodeNamingConflictResolutionStrategy.MERGE);
    }

    public boolean internalCopy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batchCount, boolean isTopObject, JCRNodeWrapper.NodeNamingConflictResolutionStrategy namingConflictResolutionStrategy) throws RepositoryException {
        if (isTopObject) {
            this.getSession().getUuidMapping().put("top-" + this.getIdentifier(), "");
        }
        JCRNodeWrapper copy = null;
        try {
            copy = (JCRNodeWrapper)this.session.getItem(dest.getPath() + "/" + name);
            this.getSession().checkout(copy);
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (copy != null && !copy.getParent().getDefinition().allowsSameNameSiblings() && namingConflictResolutionStrategy == JCRNodeWrapper.NodeNamingConflictResolutionStrategy.FAIL) {
            throw new ItemExistsException("Same name siblings are not allowed: node " + copy.getPath());
        }
        if (ignoreNodeTypes != null) {
            for (String nodeType : ignoreNodeTypes) {
                if (!this.isNodeType(nodeType)) continue;
                return false;
            }
        }
        batchCount.increment();
        if (maxBatch > 0 && batchCount.intValue() > maxBatch) {
            try {
                this.session.save();
                batchCount.setValue(0);
            }
            catch (ConstraintViolationException e) {
                batchCount.setValue(maxBatch - 1);
            }
        }
        Map<String, String> uuidMapping = this.getSession().getUuidMapping();
        if (copy == null || copy.getDefinition().allowsSameNameSiblings()) {
            if (dest.isVersioned()) {
                this.session.checkout(dest);
            }
            String typeName = this.getPrimaryNodeTypeName();
            try {
                copy = dest.addNode(name, typeName);
            }
            catch (ItemExistsException e) {
                copy = dest.getNode(name);
            }
            catch (ConstraintViolationException e) {
                logger.error("Cannot copy node", (Throwable)e);
                return false;
            }
        }
        try {
            if (copy.getProvider().isUpdateMixinAvailable()) {
                NodeType[] mixin;
                for (NodeType aMixin : mixin = this.objectNode.getMixinNodeTypes()) {
                    if (Constants.forbiddenMixinToCopy.contains(aMixin.getName())) continue;
                    copy.addMixin(aMixin.getName());
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error adding mixin types to copy", (Throwable)e);
        }
        if (copy != null) {
            uuidMapping.put(this.getIdentifier(), copy.getIdentifier());
            if (this.hasProperty("jcr:language")) {
                copy.setProperty("jcr:language", this.getProperty("jcr:language").getString());
            }
            this.copyProperties(copy, references);
        }
        JCRNodeIteratorWrapper ni = this.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper source = (JCRNodeWrapper)ni.next();
            if (source.isNodeType("mix:shareable")) {
                if (uuidMapping.containsKey(source.getIdentifier())) {
                    this.session.save();
                    copy.clone(this.session.getNodeByUUID(uuidMapping.get(source.getIdentifier())), source.getName());
                    continue;
                }
                if (allowsExternalSharedNodes) {
                    copy.clone(source, source.getName());
                    continue;
                }
                JCRNodeWrapperImpl.doCopy(source, copy, source.getName(), false, references, ignoreNodeTypes, maxBatch, batchCount, false);
                continue;
            }
            if (!Constants.forbiddenChildNodeTypesToCopy.stream().noneMatch(ThrowingPredicate.unchecked(arg_0 -> ((JCRNodeWrapper)source).isNodeType(arg_0)))) continue;
            JCRNodeWrapperImpl.doCopy(source, copy, source.getName(), allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount, false);
        }
        return true;
    }

    @Override
    public void copyProperties(JCRNodeWrapper destinationNode, Map<String, List<String>> references) throws RepositoryException {
        PropertyIterator props = this.getProperties();
        while (props.hasNext()) {
            Property property = props.nextProperty();
            boolean b = !property.getDefinition().getDeclaringNodeType().isMixin() || destinationNode.getProvider().isUpdateMixinAvailable();
            try {
                if (Constants.forbiddenPropertiesToCopy.contains(property.getName()) || !b) continue;
                if (property.getType() == 9 || property.getType() == 10) {
                    if (property.getDefinition().isMultiple() && property.isMultiple()) {
                        Value[] values;
                        for (Value value : values = property.getValues()) {
                            this.keepReference(destinationNode, references, property, value.getString());
                        }
                    } else {
                        this.keepReference(destinationNode, references, property, property.getValue().getString());
                    }
                }
                if (property.getDefinition().isMultiple() && property.isMultiple()) {
                    destinationNode.setProperty(property.getName(), property.getValues());
                    continue;
                }
                destinationNode.setProperty(property.getName(), property.getValue());
            }
            catch (Exception e) {
                logger.debug("Unable to copy property '" + property.getName() + "'. Skipping.", (Throwable)e);
            }
        }
    }

    private void keepReference(JCRNodeWrapper destinationNode, Map<String, List<String>> references, Property property, String value) throws RepositoryException {
        if (!references.containsKey(value)) {
            references.put(value, new ArrayList());
        }
        references.get(value).add(destinationNode.getIdentifier() + "/" + property.getName());
    }

    @Override
    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        JCRNodeWrapper parent = null;
        try {
            parent = this.getParent();
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (parent != null) {
            JCRLockUtils.checkLock(parent, false, true);
        }
        this.getSession().unregisterNewNode(this);
        if (!this.hasNodes()) {
            this.getSession().removeFromCache(this);
        } else {
            this.getSession().flushCaches();
        }
        this.item.remove();
    }

    @Override
    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.session.checkReadOnly("Node lock operation is not permitted for the current session as it is in read-only mode");
        return this.objectNode.lock(isDeep, isSessionScoped);
    }

    @Override
    public boolean lockAndStoreToken(String type) throws RepositoryException {
        String l = this.getSession().isSystem() ? " system " : this.getSession().getUserID();
        return this.lockAndStoreToken(type, l);
    }

    @Override
    public boolean lockAndStoreToken(String type, String userID) throws RepositoryException {
        this.session.checkReadOnly("Node lock operation is not permitted for the current session as it is in read-only mode");
        if (!this.isNodeType("jmix:lockable")) {
            return false;
        }
        String token = null;
        String i18nToken = null;
        Node locked = null;
        Node i18nLocked = null;
        if (!this.objectNode.isLocked()) {
            this.lockNode(this.objectNode);
            locked = this.objectNode;
        } else {
            Property property = this.objectNode.getProperty("j:locktoken");
            token = property.getString();
            this.objectNode.getSession().getWorkspace().getLockManager().addLockToken(token);
        }
        try {
            this.addLockTypeValue(this.objectNode, userID + ":" + type);
            if (!"deletion".equals(type) && this.session.getLocale() != null && !this.isNodeType("jnt:translation")) {
                Node trans = null;
                try {
                    trans = this.getI18N(this.session.getLocale());
                    if (!trans.isLocked()) {
                        this.lockNode(trans);
                        i18nLocked = trans;
                    } else {
                        Property property = trans.getProperty("j:locktoken");
                        i18nToken = property.getString();
                        trans.getSession().getWorkspace().getLockManager().addLockToken(i18nToken);
                    }
                    this.addLockTypeValue(trans, userID + ":" + type);
                }
                catch (ItemNotFoundException property) {
                    // empty catch block
                }
            }
            this.objectNode.getSession().save();
        }
        catch (RepositoryException e) {
            try {
                if (locked != null) {
                    locked.getSession().getWorkspace().getLockManager().unlock(locked.getPath());
                }
            }
            catch (RepositoryException unlockEx) {
                logger.warn("Error when unlocking unsuccessful lock on node: " + this.getPath(), (Throwable)unlockEx);
            }
            try {
                if (i18nLocked != null) {
                    i18nLocked.getSession().getWorkspace().getLockManager().unlock(i18nLocked.getPath());
                }
            }
            catch (RepositoryException unlockEx) {
                logger.warn("Error when unlocking unsuccessful lock on node: " + this.getPath(), (Throwable)unlockEx);
            }
            if (token != null) {
                this.objectNode.getSession().getWorkspace().getLockManager().removeLockToken(token);
            }
            if (i18nToken != null) {
                this.objectNode.getSession().getWorkspace().getLockManager().removeLockToken(i18nToken);
            }
            throw e;
        }
        return true;
    }

    private void lockNode(Node objectNode) throws RepositoryException {
        this.getSession().checkout(objectNode);
        Lock lock = objectNode.lock(false, false);
        if (lock.getLockToken() != null) {
            try {
                objectNode.setProperty("j:locktoken", lock.getLockToken());
            }
            catch (RepositoryException e) {
                logger.error("Cannot store token for " + this.getPath(), (Throwable)e);
                objectNode.unlock();
            }
        } else {
            logger.error("Lost lock ! " + this.localPathInProvider);
        }
    }

    private void addLockTypeValue(Node objectNode, String l) throws RepositoryException {
        this.getSession().checkout(objectNode);
        if (objectNode.hasProperty("j:lockTypes")) {
            Property property = objectNode.getProperty("j:lockTypes");
            Value[] oldValues = property.getValues();
            boolean addValue = true;
            for (Value oldValue : oldValues) {
                if (!l.equals(oldValue.getString())) continue;
                addValue = false;
                break;
            }
            if (addValue) {
                Value[] newValues = new Value[oldValues.length + 1];
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[oldValues.length] = this.getSession().getValueFactory().createValue(l);
                property.setValue(newValues);
            }
        } else {
            objectNode.setProperty("j:lockTypes", new String[]{l});
        }
    }

    @Override
    public boolean isLocked() {
        try {
            return this.objectNode.isLocked();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean isLockable() {
        try {
            return this.objectNode.isNodeType("mix:lockable");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public List<Locale> getLockedLocales() throws RepositoryException {
        ArrayList<Locale> r = new ArrayList<Locale>();
        NodeIterator ni = this.objectNode.getNodes(TRANSLATION_NODES_PATTERN);
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            if (!n.isLocked()) continue;
            r.add(LanguageCodeConverters.languageCodeToLocale(n.getProperty("jcr:language").getString()));
        }
        return r;
    }

    public List<Locale> getLockedLocalesForUserAndType(String type) throws RepositoryException {
        ArrayList<Locale> r = new ArrayList<Locale>();
        NodeIterator ni = this.getI18Ns();
        block0: while (ni.hasNext()) {
            Value[] v;
            Node n = ni.nextNode();
            if (!n.isLocked() || !n.hasProperty("j:lockTypes")) continue;
            String l = (this.getSession().isSystem() ? " system " : this.getSession().getUserID()) + ":" + type;
            for (Value value : v = n.getProperty("j:lockTypes").getValues()) {
                if (!value.getString().equals(l)) continue;
                r.add(LanguageCodeConverters.getLocaleFromCode(n.getProperty("jcr:language").getString()));
                continue block0;
            }
        }
        return r;
    }

    @Override
    public Lock getLock() {
        try {
            final Lock lock = this.objectNode.getLock();
            return new Lock(){

                public String getLockOwner() {
                    return lock.getLockOwner();
                }

                public boolean isDeep() {
                    return lock.isDeep();
                }

                public long getSecondsRemaining() throws RepositoryException {
                    return lock.getSecondsRemaining();
                }

                public boolean isLockOwningSession() {
                    return lock.isLockOwningSession();
                }

                public Node getNode() {
                    try {
                        return JCRNodeWrapperImpl.this.getProvider().getNodeWrapper(lock.getNode(), JCRNodeWrapperImpl.this.getSession());
                    }
                    catch (RepositoryException e) {
                        logger.warn("Can't get wrapper for node holding lock", (Throwable)e);
                        return JCRNodeWrapperImpl.this;
                    }
                }

                public String getLockToken() {
                    return lock.getLockToken();
                }

                public boolean isLive() throws RepositoryException {
                    return lock.isLive();
                }

                public boolean isSessionScoped() {
                    return lock.isSessionScoped();
                }

                public void refresh() throws LockException, RepositoryException {
                    lock.isSessionScoped();
                }
            };
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.session.checkReadOnly("Node unlock operation is not permitted for the current session as it is in read-only mode");
        this.objectNode.unlock();
    }

    @Override
    public void unlock(String type) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        if (this.getSession().getUser() != null) {
            this.unlock(type, this.getSession().getUser().getName());
        } else {
            this.unlock(type, this.getSession().getUserID());
        }
    }

    @Override
    public void unlock(String type, String userID) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        Node trans;
        if (!this.isLocked()) {
            throw new LockException("Node not locked");
        }
        this.session.checkReadOnly("Node unlock operation is not permitted for the current session as it is in read-only mode");
        if (this.session.getLocale() != null && !this.isNodeType("jnt:translation") && this.hasI18N(this.session.getLocale(), false) && (trans = this.getI18N(this.session.getLocale(), false)).isLocked()) {
            this.unlock(trans, type, userID);
        }
        if (this.isNodeType("jnt:translation") && !this.getLockedLocalesForUserAndType(type).isEmpty()) {
            return;
        }
        this.unlock(this.objectNode, type, userID);
    }

    private void unlock(Node objectNode, String type, String userID) throws RepositoryException {
        JCRNodeWrapperImpl.unlock(objectNode, type, userID, this.getSession());
    }

    @Override
    public void clearAllLocks() throws RepositoryException {
        this.session.checkReadOnly("Clear all locks on node operation is not permitted for the current session as it is in read-only mode");
        if (!this.isNodeType("jnt:translation")) {
            NodeIterator ni = this.objectNode.getNodes(TRANSLATION_NODES_PATTERN);
            while (ni.hasNext()) {
                Node trans = (Node)ni.next();
                this.clearAllLocks(trans);
            }
        }
        if (this.isNodeType("jnt:translation") && !this.getLockedLocales().isEmpty()) {
            return;
        }
        this.clearAllLocks(this.objectNode);
    }

    private void clearAllLocks(Node objectNode) throws RepositoryException {
        this.getSession().checkout(objectNode);
        if (objectNode.isLocked()) {
            objectNode.unlock();
        }
        if (objectNode.hasProperty("j:locktoken")) {
            objectNode.getProperty("j:locktoken").remove();
            this.getSession().save();
        }
        if (objectNode.hasProperty("j:lockTypes")) {
            objectNode.getProperty("j:lockTypes").remove();
            this.getSession().save();
        }
    }

    @Override
    public void checkLock() throws RepositoryException {
        JCRLockUtils.checkLock(this, false, false);
    }

    @Override
    public boolean holdsLock() throws RepositoryException {
        return this.objectNode.holdsLock();
    }

    @Override
    public String getLockOwner() throws RepositoryException {
        if (this.getLock() == null) {
            return null;
        }
        if (!"shared".equals(this.provider.getAuthenticationType())) {
            List<String> lockOwners = JCRLockUtils.getLockOwners(this.objectNode);
            if (lockOwners.isEmpty()) {
                return null;
            }
            if (lockOwners.isEmpty()) {
                return "";
            }
            if (lockOwners.size() == 1) {
                return String.valueOf(lockOwners.get(0)).trim();
            }
            StringBuilder owners = new StringBuilder();
            for (String s : lockOwners) {
                owners.append(s).append(" ");
            }
            return owners.toString().trim();
        }
        return this.getSession().getUserID();
    }

    @Override
    public Map<String, List<String>> getLockInfos() throws RepositoryException {
        HashMap<String, List<String>> locks = new HashMap<String, List<String>>();
        List<String> lockInfos = JCRLockUtils.getLockInfos(this.objectNode);
        if (!lockInfos.isEmpty()) {
            locks.put(null, lockInfos);
        }
        NodeIterator ni = this.getI18Ns();
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            lockInfos = JCRLockUtils.getLockInfos(n);
            if (lockInfos.isEmpty()) continue;
            locks.put(n.getProperty("jcr:language").getString(), lockInfos);
        }
        return locks;
    }

    @Override
    public void versionFile() {
        try {
            this.objectNode.addMixin("mix:versionable");
        }
        catch (RepositoryException e) {
            logger.error("Error while adding versionable mixin type", (Throwable)e);
        }
    }

    @Override
    public boolean isVersioned() {
        try {
            return this.getProvider().isVersioningAvailable() && this.objectNode.isNodeType("mix:versionable");
        }
        catch (RepositoryException e) {
            logger.error("Error while checking if object node is versioned", (Throwable)e);
            return false;
        }
    }

    @Override
    public void checkpoint() {
        try {
            JCRObservationManager.doWorkspaceWriteCall(this.getSession(), 8, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    session.getWorkspace().getVersionManager().checkpoint(JCRNodeWrapperImpl.this.localPathInProvider);
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error setting checkpoint for node " + this.getPath(), (Throwable)e);
        }
    }

    @Override
    public List<String> getVersions() {
        ArrayList<String> results = new ArrayList<String>();
        try {
            VersionHistory vh = this.objectNode.getVersionHistory();
            VersionIterator vi = vh.getAllVersions();
            vi.nextVersion();
            while (vi.hasNext()) {
                Version version = vi.nextVersion();
                results.add(version.getName());
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving versions", (Throwable)e);
        }
        return results;
    }

    @Override
    public List<Version> getVersionsAsVersion() {
        ArrayList<Version> results = new ArrayList<Version>();
        try {
            VersionHistory vh = this.objectNode.getVersionHistory();
            VersionIterator vi = vh.getAllVersions();
            vi.nextVersion();
            while (vi.hasNext()) {
                Version version = vi.nextVersion();
                results.add(version);
            }
            Collections.sort(results, new Comparator<Version>(){

                @Override
                public int compare(Version o1, Version o2) {
                    try {
                        return o1.getCreated().compareTo(o2.getCreated());
                    }
                    catch (RepositoryException e) {
                        return -1;
                    }
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving versions", (Throwable)e);
        }
        return results;
    }

    @Override
    public List<VersionInfo> getVersionInfos() throws RepositoryException {
        return ServicesRegistry.getInstance().getJCRVersionService().getVersionInfos(this.session, this);
    }

    @Override
    public List<VersionInfo> getLinearVersionInfos() throws RepositoryException {
        return ServicesRegistry.getInstance().getJCRVersionService().getLinearVersionInfos(this.session, this);
    }

    @Override
    public JCRStoreProvider getJCRProvider() {
        return this.provider;
    }

    @Override
    public JCRStoreProvider getProvider() {
        return this.provider;
    }

    public void orderBefore(String s, String s1) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.checkLock();
        this.objectNode.orderBefore(s, s1);
    }

    @Override
    public JCRItemWrapper getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        return this.provider.getItemWrapper(this.objectNode.getPrimaryItem(), this.session);
    }

    public int getIndex() throws RepositoryException {
        return this.objectNode.getIndex();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return new PropertyIteratorImpl(this.objectNode.getReferences(), this.getSession(), this.getProvider());
    }

    public boolean hasNode(String s) throws RepositoryException {
        if (!this.objectNode.hasNode(s)) {
            if (this.provider.getService() != null && this.provider.getSessionFactory().areMultipleMountPointsRegistered()) {
                String targetPath = this.getPath() + '/' + s;
                JCRStoreProvider targetProvider = this.provider.getSessionFactory().getProvider(targetPath, false);
                if (targetProvider != null && targetProvider != this.provider) {
                    if (targetProvider.getMountPoint().equals(targetPath)) {
                        return true;
                    }
                    JCRNodeWrapper providerRoot = targetProvider.getNodeWrapper(this.session.getProviderSession(targetProvider).getNode(targetProvider.getRelativeRoot().isEmpty() ? "/" : targetProvider.getRelativeRoot()), "/", this, this.session);
                    String childPath = StringUtils.substringAfter((String)targetPath, (String)(targetProvider.getMountPoint() + "/"));
                    if (childPath.length() > 0) {
                        return providerRoot.hasNode(childPath);
                    }
                }
            }
            return false;
        }
        if ("live".equals(this.getSession().getWorkspace().getName()) && !s.startsWith("j:translation")) {
            JCRNodeWrapper wrapper;
            try {
                wrapper = this.getNode(s);
            }
            catch (RepositoryException e) {
                return false;
            }
            return wrapper.checkValidity();
        }
        return true;
    }

    public boolean hasNodes() throws RepositoryException {
        Map<String, JCRStoreProvider> allMountPoints;
        if (this.provider.getService() != null && (allMountPoints = this.provider.getSessionFactory().getMountPoints()).size() > 1) {
            String pathPrefix = this.getPath() + "/";
            for (String entry : allMountPoints.keySet()) {
                if (entry.equals("/") || !entry.startsWith(pathPrefix) || entry.indexOf(47, pathPrefix.length() - 1) != -1) continue;
                return true;
            }
        }
        if (!this.objectNode.hasNodes()) {
            return false;
        }
        boolean inLive = "live".equals(this.getSession().getWorkspace().getName());
        if (inLive || this.session.getLocale() != null) {
            NodeIterator ni = this.objectNode.getNodes();
            while (ni.hasNext()) {
                try {
                    Node child = ni.nextNode();
                    String childName = child.getName();
                    if (this.session.getLocale() != null && childName.startsWith(TRANSLATION_PREFIX) || !this.getNode(childName).checkValidity()) continue;
                    return true;
                }
                catch (PathNotFoundException pathNotFoundException) {
                }
            }
            return false;
        }
        return true;
    }

    public JCRVersion checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return (JCRVersion)this.session.getWorkspace().getVersionManager().checkin(this.getPath());
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.session.checkout(this);
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        VersionManager versionManager = this.session.getWorkspace().getVersionManager();
        versionManager.doneMerge(this.localPathInProvider, ((JCRVersion)version).getRealNode());
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        VersionManager versionManager = this.session.getWorkspace().getVersionManager();
        versionManager.cancelMerge(this.localPathInProvider, ((JCRVersion)version).getRealNode());
    }

    public void update(final String srcWorkspace) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        JCRObservationManager.doWorkspaceWriteCall(this.getSession(), 10, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapperImpl.this.objectNode.update(srcWorkspace);
                return null;
            }
        });
    }

    @Override
    public JCRNodeIteratorWrapper merge(String s, boolean b) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getCorrespondingNodePath(String s) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        String nodePath = this.objectNode.getCorrespondingNodePath(s);
        if (this.provider.getMountPoint().equals("/")) {
            return nodePath;
        }
        return nodePath.equals("/") ? this.provider.getMountPoint() : this.provider.getMountPoint() + nodePath;
    }

    public boolean isCheckedOut() throws RepositoryException {
        VersionManager versionManager = this.session.getProviderSession(this.provider).getWorkspace().getVersionManager();
        boolean co = versionManager.isCheckedOut(this.localPathInProvider);
        if (co && this.session.getLocale() != null) {
            try {
                co &= versionManager.isCheckedOut(this.getI18N(this.session.getLocale()).getPath());
            }
            catch (ItemNotFoundException e) {
                logger.debug("isCheckedOut : no i18n node for node {}", (Object)this.localPathInProvider);
            }
        }
        return co;
    }

    public void restore(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.getRealNode().restore(s, b);
    }

    public void restore(Version version, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.getRealNode().restore(version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version, b);
    }

    public void restore(Version version, String s, boolean b) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.getRealNode().restore(version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version, s, b);
    }

    public void restoreByLabel(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.getRealNode().restoreByLabel(s, b);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return (VersionHistory)this.getProvider().getNodeWrapper((Node)this.getRealNode().getVersionHistory(), this.getSession());
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return (Version)this.getProvider().getNodeWrapper((Node)this.getRealNode().getBaseVersion(), this.getSession());
    }

    @Override
    public JCRFileContent getFileContent() {
        if (this.fileContent == null) {
            this.fileContent = new JCRFileContent(this, this.objectNode);
        }
        return this.fileContent;
    }

    @Override
    public ExtendedPropertyDefinition getApplicablePropertyDefinition(String propertyName) throws RepositoryException {
        return this.getApplicablePropertyDefinition(propertyName, 0, false);
    }

    @Override
    public ExtendedPropertyDefinition getApplicablePropertyDefinition(String propertyName, int requiredPropertyType, boolean isMultiple) throws RepositoryException {
        ExtendedPropertyDefinition result = null;
        if (this.applicablePropertyDefinition.containsKey(propertyName) && (this.applicablePropertyDefinition.get(propertyName) == null || this.applicablePropertyDefinition.get(propertyName).isMultiple() == isMultiple)) {
            result = this.applicablePropertyDefinition.get(propertyName);
            return result;
        }
        ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
        Iterator<ExtendedNodeType> iterator = this.getNodeTypesIterator();
        while (iterator.hasNext()) {
            ExtendedNodeType type = iterator.next();
            Map<String, ExtendedPropertyDefinition> definitionMap = type.getPropertyDefinitionsAsMap();
            this.applicablePropertyDefinition.putAll(definitionMap);
            if (definitionMap.containsKey(propertyName)) {
                result = definitionMap.get(propertyName);
                return result;
            }
            types.add(type);
        }
        if (this.isNodeType("jnt:translation") && !propertyName.equals("jcr:language") && (result = this.getParent().getApplicablePropertyDefinition(propertyName)) != null) {
            this.applicablePropertyDefinition.put(propertyName, result);
            return result;
        }
        for (ExtendedNodeType type : types) {
            for (ExtendedPropertyDefinition epd : type.getUnstructuredPropertyDefinitions().values()) {
                if (requiredPropertyType != 0 && epd.getRequiredType() != 0 && epd.getRequiredType() != requiredPropertyType || isMultiple != epd.isMultiple()) continue;
                result = epd;
                this.applicablePropertyDefinition.put(propertyName, result);
                return result;
            }
        }
        this.applicablePropertyDefinition.put(propertyName, result);
        return result;
    }

    @Override
    public List<ExtendedPropertyDefinition> getReferenceProperties() throws RepositoryException {
        ArrayList<ExtendedPropertyDefinition> defs = new ArrayList<ExtendedPropertyDefinition>();
        ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
        Iterator<ExtendedNodeType> iterator = this.getNodeTypesIterator();
        if (this.isNodeType("jnt:translation")) {
            return this.getParent().getReferenceProperties();
        }
        while (iterator.hasNext()) {
            ExtendedNodeType type = iterator.next();
            Map<String, ExtendedPropertyDefinition> definitionMap = type.getPropertyDefinitionsAsMap();
            for (ExtendedPropertyDefinition definition : definitionMap.values()) {
                if (definition.getRequiredType() != 9 && definition.getRequiredType() != 10) continue;
                defs.add(definition);
            }
            types.add(type);
        }
        for (ExtendedNodeType type : types) {
            for (ExtendedPropertyDefinition definition : type.getUnstructuredPropertyDefinitions().values()) {
                if (definition.getRequiredType() != 9 && definition.getRequiredType() != 10) continue;
                defs.add(definition);
            }
        }
        return defs;
    }

    @Override
    public ExtendedNodeDefinition getApplicableChildNodeDefinition(String childName, String nodeType) throws ConstraintViolationException, RepositoryException {
        ExtendedNodeType requiredType = NodeTypeRegistry.getInstance().getNodeType(nodeType);
        ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
        Iterator<ExtendedNodeType> iterator = this.getNodeTypesIterator();
        while (iterator.hasNext()) {
            ExtendedNodeType type = iterator.next();
            Map<String, ExtendedNodeDefinition> definitionMap = type.getChildNodeDefinitionsAsMap();
            if (definitionMap.containsKey(childName)) {
                ExtendedNodeDefinition epd = definitionMap.get(childName);
                for (String req : epd.getRequiredPrimaryTypeNames()) {
                    if (!requiredType.isNodeType(req)) continue;
                    return epd;
                }
                throw new ConstraintViolationException("Definition type for " + childName + " on node " + this.getName() + " (" + this.getPrimaryNodeTypeName() + ") does not match " + nodeType);
            }
            types.add(type);
        }
        for (ExtendedNodeType type : types) {
            for (ExtendedNodeDefinition epd : type.getUnstructuredChildNodeDefinitions().values()) {
                for (String req : epd.getRequiredPrimaryTypeNames()) {
                    if (!requiredType.isNodeType(req)) continue;
                    return epd;
                }
            }
        }
        throw new ConstraintViolationException("Cannot find definition for " + childName + " on node " + this.getName() + " (" + this.getPrimaryNodeTypeName() + ")");
    }

    private Iterator<ExtendedNodeType> getNodeTypesIterator() {
        return new Iterator<ExtendedNodeType>(){
            int i = 0;
            ExtendedNodeType next;
            boolean fetched = false;
            Iterator<ExtendedNodeType> mix = null;

            @Override
            public boolean hasNext() {
                if (!this.fetched) {
                    try {
                        if (this.i == 0) {
                            this.next = JCRNodeWrapperImpl.this.getPrimaryNodeType();
                        } else if (this.i == 1 && this.isNodeType("nt:frozenNode")) {
                            this.next = NodeTypeRegistry.getInstance().getNodeType(JCRNodeWrapperImpl.this.objectNode.getProperty("jcr:frozenPrimaryType").getString());
                        } else {
                            if (this.mix == null) {
                                this.mix = Arrays.asList(JCRNodeWrapperImpl.this.getMixinNodeTypes()).iterator();
                            }
                            this.next = this.mix.hasNext() ? this.mix.next() : null;
                        }
                    }
                    catch (RepositoryException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ++this.i;
                    }
                    this.fetched = true;
                }
                return this.next != null;
            }

            private boolean isNodeType(String nodeType) {
                boolean isNodeType = false;
                try {
                    isNodeType = JCRNodeWrapperImpl.this.objectNode.isNodeType(nodeType);
                }
                catch (RepositoryException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                return isNodeType;
            }

            @Override
            public ExtendedNodeType next() {
                if (!this.fetched) {
                    this.hasNext();
                }
                if (this.next != null) {
                    this.fetched = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCRNodeWrapper fileNodeWrapper = (JCRNodeWrapper)o;
        return !(this.getPath() == null ? fileNodeWrapper.getPath() != null : !this.getPath().equals(fileNodeWrapper.getPath()));
    }

    public int hashCode() {
        return this.getPath() != null ? this.getPath().hashCode() : 0;
    }

    public PropertyIterator getProperties(String[] strings) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator((JCRNodeWrapper)this, locale, strings);
        }
        return new LazyPropertyIterator((JCRNodeWrapper)this, null, strings);
    }

    public String getIdentifier() throws RepositoryException {
        return this.objectNode.getIdentifier();
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        return new PropertyIteratorImpl(this.objectNode.getReferences(name), this.getSession(), this.getProvider());
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.getWeakReferences(null);
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        if (!this.isNodeType("mix:referenceable")) {
            return new PropertyIteratorImpl(PropertyIteratorAdapter.EMPTY, this.getSession(), this.getProvider());
        }
        return this.getSession().getWeakReferences(this, name);
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public JCRNodeIteratorWrapper getSharedSet() throws RepositoryException {
        ArrayList<JCRNodeWrapper> list = new ArrayList<JCRNodeWrapper>();
        NodeIterator ni = this.objectNode.getSharedSet();
        while (ni.hasNext()) {
            Node node = ni.nextNode();
            JCRNodeWrapper child = this.provider.getNodeWrapper(node, this.session);
            list.add(child);
        }
        return new NodeIteratorImpl(list.iterator(), (long)list.size());
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.objectNode.removeSharedSet();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.objectNode.removeShare();
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new String[0];
    }

    @Override
    public JCRNodeWrapper clone(JCRNodeWrapper sharedNode, String name) throws ItemExistsException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (!sharedNode.isNodeType("jmix:shareable")) {
            this.getSession().checkout(sharedNode);
            sharedNode.addMixin("jmix:shareable");
            sharedNode.getRealNode().getSession().save();
            try {
                final String path = sharedNode.getCorrespondingNodePath("live");
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper n = session.getNode(path);
                        JCRNodeWrapperImpl.this.getSession().checkout(n);
                        n.addMixin("jmix:shareable");
                        n.getRealNode().getSession().save();
                        return null;
                    }
                });
            }
            catch (ItemNotFoundException path) {
            }
            catch (RepositoryException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (this.getRealNode() instanceof NodeImpl && sharedNode.getRealNode() instanceof NodeImpl) {
            String uri = "";
            if (name.contains(":")) {
                uri = this.session.getNamespaceURI(StringUtils.substringBefore((String)name, (String)":"));
                name = StringUtils.substringAfter((String)name, (String)":");
            }
            org.apache.jackrabbit.spi.Name jrname = NameFactoryImpl.getInstance().create(uri, name);
            NodeImpl node = (NodeImpl)this.getRealNode();
            try {
                return this.provider.getNodeWrapper((Node)node.clone((NodeImpl)sharedNode.getRealNode(), jrname), this.buildSubnodePath(name), this, this.session);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean checkValidity() {
        try {
            JCRSessionWrapper jcrSessionWrapper;
            if (this.getPath().startsWith("/sites") && "live".equals((jcrSessionWrapper = this.getSession()).getWorkspace().getName()) && !JCRStoreService.getInstance().getNoValidityCheckTypes().contains(this.getPrimaryNodeTypeName())) {
                boolean result;
                boolean isLocaleDefined;
                boolean bl = isLocaleDefined = jcrSessionWrapper.getLocale() != null;
                if (isLocaleDefined) {
                    if (this.objectNode.hasProperty("j:published") && !this.objectNode.getProperty("j:published").getBoolean()) {
                        return false;
                    }
                    if (JCRContentUtils.isLanguageInvalid(this.objectNode, jcrSessionWrapper.getLocale().toString()) || !this.hasI18N(jcrSessionWrapper.getLocale(), true) && this.hasI18N(jcrSessionWrapper.getLocale(), true, false)) {
                        return false;
                    }
                }
                if ((result = this.checkLanguageValidity(null)) && isLocaleDefined) {
                    result = VisibilityService.getInstance().matchesConditions(this);
                }
                return result;
            }
            if (this.getProvider().isDefault()) {
                return !this.objectNode.hasProperty("j:isExternalProviderRoot");
            }
        }
        catch (RepositoryException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Node " + this.getPath() + " is not valid due to an Exception during validity check", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkLanguageValidity(Set<String> languages) {
        block12: {
            JCRSessionWrapper jcrSessionWrapper = this.getSession();
            try {
                Locale locale = jcrSessionWrapper.getLocale();
                if (locale != null) {
                    boolean b;
                    JCRSiteNode siteNode = this.getResolveSite();
                    if (siteNode != null) {
                        List<Locale> locales;
                        Set<String> mandatoryLanguages = siteNode.getMandatoryLanguages();
                        List<Locale> list = locales = jcrSessionWrapper.isLive() ? siteNode.getActiveLiveLanguagesAsLocales() : siteNode.getLanguagesAsLocales();
                        if (locales.size() == 0) {
                            return true;
                        }
                        if (!JCRStoreService.getInstance().getNoLanguageValidityCheckTypes().contains(this.getPrimaryNodeTypeName()) && !locales.contains(locale) && !this.site.isAllowsUnlistedLanguages() && this.hasI18N(locale)) {
                            return false;
                        }
                        for (String mandatoryLanguage : mandatoryLanguages) {
                            if (this.checkI18nAndMandatoryPropertiesForLocale(LanguageCodeConverters.getLocaleFromCode(mandatoryLanguage))) continue;
                            return false;
                        }
                    }
                    if (!(b = this.checkI18nAndMandatoryPropertiesForLocale(locale)) && siteNode != null && siteNode.isMixLanguagesActive()) {
                        b = this.checkI18nAndMandatoryPropertiesForLocale(LanguageCodeConverters.getLocaleFromCode(siteNode.getDefaultLanguage()));
                    }
                    return b;
                }
                if (languages == null) break block12;
                for (String language : languages) {
                    if (this.checkI18nAndMandatoryPropertiesForLocale(LanguageCodeConverters.getLocaleFromCode(language))) {
                        JCRSiteNode siteNode = this.getResolveSite();
                        if (siteNode == null) continue;
                        Set<String> mandatoryLanguages = siteNode.getMandatoryLanguages();
                        if (mandatoryLanguages == null || mandatoryLanguages.isEmpty()) {
                            return true;
                        }
                        for (String mandatoryLanguage : mandatoryLanguages) {
                            if (this.checkI18nAndMandatoryPropertiesForLocale(LanguageCodeConverters.getLocaleFromCode(mandatoryLanguage))) continue;
                            return false;
                        }
                        continue;
                    }
                    return false;
                }
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasTranslations() throws RepositoryException {
        return this.objectNode.getNodes(TRANSLATION_NODES_PATTERN).hasNext();
    }

    @Override
    public boolean checkI18nAndMandatoryPropertiesForLocale(Locale locale) throws RepositoryException {
        Node i18n = null;
        if (this.hasI18N(locale, false)) {
            i18n = this.getI18N(locale, false);
        }
        for (ExtendedPropertyDefinition def : this.getPrimaryNodeType().getPropertyDefinitionsAsMap().values()) {
            if (!def.isInternationalized() || !def.isMandatory() || i18n != null && i18n.hasProperty(def.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public JCRSiteNode getResolveSite() throws RepositoryException {
        if (this.site != null) {
            return this.site;
        }
        try {
            String path = this.getCanonicalPath();
            String string = path = path.startsWith("/modulesFileSystem/") ? path.replace("/modulesFileSystem/", "/modules/") : path;
            if (path.startsWith("/sites/") || path.startsWith("/modules/")) {
                JCRNodeWrapper node;
                int index = path.indexOf(47, path.indexOf(47, 1) + 1);
                if (index == -1 && (node = this.provider.getNodeWrapper(this.objectNode, this.session)) instanceof JCRSiteNode) {
                    this.site = (JCRSiteNode)node;
                    return this.site;
                }
                try {
                    this.site = (JCRSiteNode)this.getSession().getNode(index == -1 ? path : path.substring(0, index));
                    return this.site;
                }
                catch (ClassCastException e) {
                    logger.debug("Cannot resolve site for node " + this.getPath(), (Throwable)e);
                }
            }
            this.site = (JCRSiteNode)this.getSession().getNode(JCRContentUtils.getSystemSitePath());
            return this.site;
        }
        catch (PathNotFoundException e) {
            logger.debug("Cannot resolve site for node " + this.getPath(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getDisplayableName() {
        try {
            String rb;
            if (this.isNodeType("jmix:rbTitle") && (rb = this.getProperty("j:titleKey").getValue().getString()) != null) {
                return this.getResourceBundle(rb);
            }
        }
        catch (RepositoryException e) {
            logger.debug("Failed to get resourceBundled title", (Throwable)e);
        }
        String title = null;
        try {
            title = this.getProperty("jcr:title").getValue().getString();
        }
        catch (RepositoryException e) {
            try {
                String s;
                String itemName = this.getPrimaryNodeType().getPrimaryItemName();
                if (itemName != null && (s = this.getProperty(itemName).getValue().getString()) != null && s.length() > 0) {
                    title = s.contains("<") ? new TextExtractor((Segment)new Source((CharSequence)s)).toString() : s;
                }
            }
            catch (RepositoryException e1) {
                title = null;
            }
        }
        if (title != null && !title.isEmpty()) {
            return this.session.getWorkspace().getName().equals("default") && title.contains("##resourceBundle(") ? this.interpolateResourceBundle(title) : title;
        }
        return this.getUnescapedName();
    }

    @Override
    public String getUnescapedName() {
        String name = this.getName();
        return name != null ? JCRContentUtils.unescapeLocalNodeName(name) : null;
    }

    private String interpolateResourceBundle(String title) {
        Locale locale = this.getSession().getLocale();
        try {
            JCRSiteNode site = this.getResolveSite();
            Iterator<String> iterator = site.getInstalledModules().iterator();
            if (iterator.hasNext()) {
                String module = iterator.next();
                try {
                    return Messages.interpolateResourceBundleMacro(title, locale != null ? locale : this.session.getFallbackLocale(), ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(module));
                }
                catch (Exception e) {
                    return title;
                }
            }
        }
        catch (RepositoryException e) {
            logger.warn("Unable to resolve the site for node {}. Cause: {}", (Object)this.getPath(), (Object)e.getMessage());
        }
        return title;
    }

    private String getResourceBundle(String title) {
        Locale locale = this.getSession().getLocale();
        try {
            JCRSiteNode site = this.getResolveSite();
            for (String module : site.getInstalledModules()) {
                try {
                    String r = Messages.get(null, ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(module), title, locale != null ? locale : this.session.getFallbackLocale(), null);
                    if (r == null) continue;
                    return r;
                }
                catch (Exception exception) {
                }
            }
            return title;
        }
        catch (RepositoryException e) {
            logger.warn("Unable to resolve the site for node {}. Cause: {}", (Object)this.getPath(), (Object)e.getMessage());
            return title;
        }
    }

    public void flushLocalCaches() {
        this.applicablePropertyDefinition.clear();
        this.hasPropertyCache.clear();
    }

    @Override
    public boolean canMarkForDeletion() throws RepositoryException {
        JCRStoreProvider provider = this.getProvider();
        if (!provider.isLockingAvailable() || !provider.isUpdateMixinAvailable()) {
            return false;
        }
        for (String skipType : JCRContentUtils.getInstance().getUnsupportedMarkForDeletionNodeTypes()) {
            if (!this.isNodeType(skipType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMarkedForDeletion() throws RepositoryException {
        return this.objectNode.isNodeType("jmix:markedForDeletion");
    }

    @Override
    public void markForDeletion(String comment) throws RepositoryException {
        long timer = System.currentTimeMillis();
        if (!this.canMarkForDeletion()) {
            throw new UnsupportedRepositoryOperationException("Mark for deletion is not supported on this node !");
        }
        this.checkout();
        if (!this.objectNode.isNodeType("jmix:markedForDeletion")) {
            this.addMixin("jmix:markedForDeletion");
        }
        if (!this.objectNode.isNodeType("jmix:markedForDeletionRoot")) {
            this.addMixin("jmix:markedForDeletionRoot");
        }
        this.objectNode.setProperty("j:deletionUser", this.session.getUserID());
        this.objectNode.setProperty("j:deletionDate", Calendar.getInstance());
        if (comment != null && comment.length() > 0) {
            this.objectNode.setProperty("j:deletionMessage", comment);
        }
        JCRNodeWrapperImpl.markNodesForDeletion(this);
        if (this.session.hasPendingChanges()) {
            this.objectNode.getSession().save();
        }
        if (this.hasPermission("{http://www.jcp.org/jcr/1.0}lockManagement")) {
            this.lockAndStoreToken("deletion", " deletion ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("markForDeletion for node {} took {} ms", (Object)this.getPath(), (Object)(System.currentTimeMillis() - timer));
        }
    }

    private static void markNodesForDeletion(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeIteratorWrapper iterator = node.getNodes();
        while (iterator.hasNext()) {
            JCRNodeWrapper child = (JCRNodeWrapper)iterator.nextNode();
            if (child.isNodeType("jnt:translation")) continue;
            child.getSession().checkout(child);
            if (child.isNodeType("jmix:markedForDeletionRoot")) {
                try {
                    child.unlock("deletion", " deletion ");
                }
                catch (LockException lockException) {
                    // empty catch block
                }
                child.removeMixin("jmix:markedForDeletionRoot");
            }
            if (!child.isNodeType("jmix:markedForDeletion")) {
                child.addMixin("jmix:markedForDeletion");
            }
            if (child.getSession().hasPendingChanges()) {
                child.getSession().save();
            }
            if (child.hasPermission("{http://www.jcp.org/jcr/1.0}lockManagement")) {
                child.lockAndStoreToken("deletion", " deletion ");
            }
            JCRNodeWrapperImpl.markNodesForDeletion(child);
        }
    }

    @Override
    public void unmarkForDeletion() throws RepositoryException {
        long timer = System.currentTimeMillis();
        if (!this.canMarkForDeletion()) {
            throw new UnsupportedRepositoryOperationException("Mark for deletion is not supported on this node !");
        }
        this.checkout();
        if (this.isNodeType("jmix:lockable")) {
            try {
                this.unlock("deletion", " deletion ");
            }
            catch (LockException ex) {
                logger.warn("Node {} is not locked. Skipping during undelete operation.", (Object)this.getPath());
            }
        }
        if (this.objectNode.isNodeType("jmix:markedForDeletionRoot")) {
            this.removeMixin("jmix:markedForDeletionRoot");
            if (this.objectNode.isNodeType("jmix:markedForDeletion")) {
                this.removeMixin("jmix:markedForDeletion");
            }
            JCRNodeWrapperImpl.unmarkNodesForDeletion(this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("unmarkForDeletion for node {} took {} ms", (Object)this.getPath(), (Object)(System.currentTimeMillis() - timer));
        }
    }

    private static void unmarkNodesForDeletion(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeIteratorWrapper iterator = node.getNodes();
        while (iterator.hasNext()) {
            JCRNodeWrapper child = (JCRNodeWrapper)iterator.nextNode();
            if (child.isNodeType("jnt:translation")) continue;
            child.getSession().checkout(child);
            if (child.isNodeType("jmix:lockable")) {
                try {
                    child.unlock("deletion", " deletion ");
                }
                catch (LockException ex) {
                    logger.warn("Node {} is not locked. Skipping during undelete operation.", (Object)child.getPath());
                }
            }
            if (child.isNodeType("jmix:markedForDeletion")) {
                child.removeMixin("jmix:markedForDeletion");
            }
            if (child.isNodeType("jmix:markedForDeletionRoot")) {
                child.removeMixin("jmix:markedForDeletionRoot");
            }
            JCRNodeWrapperImpl.unmarkNodesForDeletion(child);
        }
    }
}

