/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JCRAutoSplitUtils {
    private static final Logger logger = LoggerFactory.getLogger(JCRAutoSplitUtils.class);

    public static JCRNodeWrapper applyAutoSplitRules(JCRNodeWrapper node) throws RepositoryException {
        return JCRAutoSplitUtils.applyAutoSplitRules(node, node.getParent());
    }

    public static JCRNodeWrapper applyAutoSplitRules(JCRNodeWrapper node, JCRNodeWrapper parent) throws RepositoryException {
        try {
            String[] config;
            String splitConfig = parent.getProperty("j:splitConfig").getString();
            String splitType = parent.getProperty("j:splitNodeType").getString();
            if (node.isNodeType(splitType)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Aborting auto-splitting on node (UUID=" + node.getIdentifier() + ", path=" + node.getPath() + ") since it is applied on the split type.");
                }
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Auto-splitting node (UUID=" + node.getIdentifier() + ", path=" + node.getPath() + ") with split config " + splitConfig + " and split node type " + splitType);
            }
            try {
                node.getSession().getNode(node.getPath());
            }
            catch (PathNotFoundException pnfe) {
                logger.warn("Node has already been moved in this session, will not move again !");
                return null;
            }
            for (String s : config = Patterns.SEMICOLON.split(splitConfig)) {
                String[] folderConfig = Patterns.COMMA.split(s);
                String type = folderConfig[0];
                String propertyName = folderConfig[1];
                String key = null;
                try {
                    if (type.equals("constant")) {
                        key = propertyName;
                    } else if (type.equals("property")) {
                        key = JCRAutoSplitUtils.getKey(node, propertyName);
                    } else if (type.equals("firstChars")) {
                        key = JCRAutoSplitUtils.getKey(node, propertyName);
                        int index = Integer.parseInt(folderConfig[2]);
                        if (key != null && key.length() >= index) {
                            key = key.substring(0, index);
                        }
                    } else if (type.equals("substring")) {
                        key = JCRAutoSplitUtils.getKey(node, propertyName);
                        String[] indexes = Patterns.DASH.split(folderConfig[2]);
                        int startIndex = Integer.parseInt(indexes[0]);
                        int endIndex = Integer.parseInt(indexes[1]);
                        if (key != null && key.length() >= endIndex) {
                            key = key.substring(startIndex, endIndex);
                        }
                    } else if (type.equals("date") && node.hasProperty(propertyName)) {
                        Calendar calendar = node.getProperty(propertyName).getDate();
                        SimpleDateFormat sdf = new SimpleDateFormat(folderConfig[2]);
                        key = sdf.format(calendar.getTime());
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot split folder", (Throwable)e);
                    key = null;
                }
                if (key == null) continue;
                if (!parent.hasNode(key)) {
                    node.getSession().checkout(parent);
                    parent = parent.addNode(key, splitType);
                    continue;
                }
                parent = parent.getNode(key);
            }
            if (!parent.getPath().equals(node.getParent().getPath())) {
                String newPath = parent.getPath() + "/" + JCRContentUtils.findAvailableNodeName(parent, node.getName(), node.isFile());
                node.getSession().move(node.getPath(), newPath);
                return node.getSession().getNode(newPath);
            }
            return null;
        }
        catch (RepositoryException e) {
            logger.error("Error while trying to move node " + node.getPath(), (Throwable)e);
            return null;
        }
    }

    public static Map<JCRNodeWrapper, JCRNodeWrapper> applyAutoSplitRulesOnSubnodes(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeIteratorWrapper ni = node.getNodes();
        HashMap<JCRNodeWrapper, JCRNodeWrapper> modifiedNodes = new HashMap<JCRNodeWrapper, JCRNodeWrapper>();
        while (ni.hasNext()) {
            JCRNodeWrapper existingNode = (JCRNodeWrapper)ni.nextNode();
            JCRNodeWrapper newNode = JCRAutoSplitUtils.applyAutoSplitRules(existingNode);
            if (newNode == null) continue;
            modifiedNodes.put(existingNode, newNode);
        }
        return modifiedNodes;
    }

    public static void enableAutoSplitting(JCRNodeWrapper node, String splitConfig, String splitFolderNodeType) throws RepositoryException {
        node.getSession().checkout(node);
        node.addMixin("jmix:autoSplitFolders");
        node.setProperty("j:splitConfig", splitConfig);
        node.setProperty("j:splitNodeType", splitFolderNodeType);
        node.getSession().save();
    }

    public static JCRNodeWrapper addNodeWithAutoSplitting(JCRNodeWrapper parentNode, String nodeName, String nodeType, String splitConfig, String splitNodeType, Object valueBean) throws RepositoryException {
        String[] config;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding node with auto-splitting (name=" + nodeName + ", parent path=" + parentNode.getPath() + ") with split config " + splitConfig + " and split node type " + splitNodeType);
        }
        for (String s : config = Patterns.SEMICOLON.split(splitConfig)) {
            String[] folderConfig = Patterns.COMMA.split(s);
            String type = folderConfig[0];
            String propertyName = folderConfig[1];
            String key = null;
            try {
                if (type.equals("constant")) {
                    key = propertyName;
                } else if (type.equals("property")) {
                    key = JCRAutoSplitUtils.getKey(valueBean, nodeName, propertyName);
                } else if (type.equals("firstChars")) {
                    key = JCRAutoSplitUtils.getKey(valueBean, nodeName, propertyName);
                    int index = Integer.parseInt(folderConfig[2]);
                    if (key != null && key.length() >= index) {
                        key = key.substring(0, index);
                    }
                } else if (type.equals("substring")) {
                    key = JCRAutoSplitUtils.getKey(valueBean, nodeName, propertyName);
                    String[] indexes = Patterns.DASH.split(folderConfig[2]);
                    int startIndex = Integer.parseInt(indexes[0]);
                    int endIndex = Integer.parseInt(indexes[1]);
                    if (key != null && key.length() >= endIndex) {
                        key = key.substring(startIndex, endIndex);
                    }
                } else if (type.equals("date") && PropertyUtils.getSimpleProperty((Object)valueBean, (String)propertyName) != null) {
                    Date date = (Date)PropertyUtils.getSimpleProperty((Object)valueBean, (String)propertyName);
                    SimpleDateFormat sdf = new SimpleDateFormat(folderConfig[2]);
                    key = sdf.format(date);
                }
            }
            catch (Exception e) {
                logger.error("Cannot split folder", (Throwable)e);
                key = null;
            }
            if (key == null) continue;
            if (!parentNode.hasNode(key)) {
                parentNode.getSession().checkout(parentNode);
                parentNode = parentNode.addNode(key, splitNodeType);
                continue;
            }
            parentNode = parentNode.getNode(key);
        }
        JCRNodeWrapper newNode = parentNode.addNode(JCRContentUtils.findAvailableNodeName(parentNode, nodeName), nodeType);
        if (logger.isDebugEnabled()) {
            logger.debug("Node added at " + newNode.getPath());
        }
        return newNode;
    }

    private static String getKey(JCRNodeWrapper node, String propertyName) throws RepositoryException {
        if (propertyName.equals("j:nodename")) {
            return JCRAutoSplitUtils.getNodeNameKey(node.getName());
        }
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return null;
    }

    private static String getKey(Object valueBean, String nodename, String propertyName) throws Exception {
        if (propertyName.equals("j:nodename")) {
            return JCRAutoSplitUtils.getNodeNameKey(nodename);
        }
        if (PropertyUtils.getSimpleProperty((Object)valueBean, (String)propertyName) != null) {
            return PropertyUtils.getSimpleProperty((Object)valueBean, (String)propertyName).toString();
        }
        return null;
    }

    private static String getNodeNameKey(String nodeName) {
        if (nodeName.indexOf(58) > 0) {
            return StringUtils.substringAfter((String)nodeName, (String)":");
        }
        return nodeName;
    }
}

