/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache.ehcache;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.CacheHelper;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushCacheEventListener
extends CacheEventListenerAdapter
implements RecordConsumer {
    private static final Logger logger = LoggerFactory.getLogger(FlushCacheEventListener.class);
    private ClusterNode clusterNode;
    private Queue<PostPonedEvent> events;
    private long revision;

    private void init() {
        if (this.clusterNode == null) {
            this.clusterNode = SpringJackrabbitRepository.getInstance().getClusterNode();
            this.events = new ConcurrentLinkedQueue<PostPonedEvent>();
        }
        try {
            this.clusterNode.getJournal().register((RecordConsumer)this);
            this.setRevision(this.clusterNode.getRevision());
        }
        catch (JournalException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (!SpringContextSingleton.getInstance().isInitialized() || SpringJackrabbitRepository.getInstance().getRepository() == null) {
            return;
        }
        this.init();
        String command = (String)element.getObjectKey();
        Object objectValue = element.getObjectValue();
        if (!(objectValue instanceof CacheClusterEvent)) {
            throw new CacheException("This cache only support element of type " + CacheClusterEvent.class.getName() + " you put " + objectValue.getClass().getName());
        }
        CacheClusterEvent cacheClusterEvent = (CacheClusterEvent)objectValue;
        logger.debug("Received an event with revision {} where current journal revision is {}", (Object)cacheClusterEvent.getClusterRevision(), (Object)this.revision);
        if (this.revision >= cacheClusterEvent.getClusterRevision()) {
            this.executeCommand(command, ehcache.getName(), cacheClusterEvent.getEvent());
        } else {
            this.events.add(new PostPonedEvent(cacheClusterEvent.getEvent(), ehcache.getName(), this.revision, command));
        }
    }

    private void executeCommand(String command, String cacheName, String event) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received command {} ({}) remotely", new Object[]{cacheName, command, event});
        }
        if (command.startsWith("FLUSH_PATH")) {
            ModuleCacheProvider.getInstance().invalidate(event, false);
        } else if (command.startsWith("FLUSH_REGEXPDEP")) {
            this.flushRegexpDependenciesOfPath(event);
        } else if (command.startsWith("FLUSH_REGEXP")) {
            ModuleCacheProvider.getInstance().invalidateRegexp(event, false);
        } else if (command.startsWith("FLUSH_CHILDREN") || command.startsWith("FLUSH_CHILDS")) {
            this.flushChildrenDependenciesOfPath(event);
        } else if (command.startsWith("FLUSH_MATCHINGPERMISSIONS")) {
            JahiaAccessManager.flushMatchingPermissions();
        } else if (command.equals("FLUSH_OUTPUT_CACHES")) {
            CacheHelper.flushOutputCaches();
        } else if (command.startsWith("FLUSH_URLRESOLVER")) {
            URLResolverFactory urlResolverFactory = (URLResolverFactory)SpringContextSingleton.getInstance().getContext().getBean("urlResolverFactory");
            urlResolverFactory.flushCaches(event);
        } else if (command.startsWith("FLUSH_VANITYURL")) {
            VanityUrlService vanityUrlService = (VanityUrlService)SpringContextSingleton.getInstance().getContext().getBean("org.jahia.services.seo.jcr.VanityUrlService");
            vanityUrlService.flushCaches();
        } else if (command.equals("FLUSH_ALL_CACHES")) {
            CacheHelper.flushAllCaches(false);
        }
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        this.notifyElementPut(ehcache, element);
    }

    private void flushChildrenDependenciesOfPath(String path) {
        ModuleCacheProvider.getInstance().flushChildrenDependenciesOfPath(path, false);
    }

    private void flushRegexpDependenciesOfPath(String path) {
        ModuleCacheProvider.getInstance().flushRegexpDependenciesOfPath(path, false);
    }

    public String getId() {
        return "JDF_CACHE";
    }

    public long getRevision() {
        return this.revision;
    }

    public void consume(Record record) {
        logger.error("This consumer can not handle records.");
    }

    public void setRevision(long revision) {
        logger.debug("Flushing event previous to revision: {}", (Object)revision);
        PostPonedEvent peek = this.events.peek();
        while (peek != null && peek.getRevision() <= revision) {
            this.events.remove();
            this.executeCommand(peek.getCommand(), peek.getName(), peek.getElement());
            peek = this.events.peek();
        }
        if (logger.isDebugEnabled()) {
            if (this.events.isEmpty()) {
                logger.debug("No more events fo flush");
            } else {
                logger.debug("Still some events to flush. Next revision to flush is {}", (Object)this.events.peek().getRevision());
            }
        }
        this.revision = revision;
    }

    private static class PostPonedEvent {
        private final String element;
        private final String name;
        private final long revision;
        private final String command;

        public PostPonedEvent(String element, String name, long revision, String command) {
            this.element = element;
            this.name = name;
            this.revision = revision;
            this.command = command;
        }

        public String getElement() {
            return this.element;
        }

        public String getName() {
            return this.name;
        }

        public long getRevision() {
            return this.revision;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

