/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.security.Principal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.pluto.container.PortletWindow;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.services.render.RenderContext;
import org.jahia.services.usermanager.JahiaUser;

public class JahiaPortalServletRequest
extends HttpServletRequestWrapper {
    private JahiaUser jahiaUser;
    private EntryPointInstance entryPointInstance;
    private String id;
    private String workspaceName;
    private Locale locale;

    public JahiaPortalServletRequest(EntryPointInstance entryPointInstance, JahiaUser jahiaUser, HttpServletRequest request, PortletWindow window, String workspaceName) {
        super(request);
        this.jahiaUser = jahiaUser;
        this.entryPointInstance = entryPointInstance;
        this.id = window.getId().getStringId();
        this.workspaceName = workspaceName;
        RenderContext ctx = (RenderContext)request.getAttribute("renderContext");
        this.locale = ctx != null && ctx.getMainResource() != null ? ctx.getMainResourceLocale() : null;
    }

    public String getRemoteUser() {
        return this.jahiaUser.getUserKey();
    }

    public Principal getUserPrincipal() {
        return this.jahiaUser;
    }

    public String getId() {
        return this.id;
    }

    public boolean isUserInRole(String role) {
        if (this.entryPointInstance == null) {
            return false;
        }
        return this.entryPointInstance.isUserInRole(this.jahiaUser, role, this.workspaceName);
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : super.getLocale();
    }
}

