/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications;

import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.ServletBean;
import org.jahia.data.applications.WebAppContext;
import org.jahia.data.webapps.Security_Role;
import org.jahia.data.webapps.Servlet_Element;
import org.jahia.data.webapps.Web_App_Xml;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class ServletContextManager
implements ServletContextAware {
    private static Logger logger = LoggerFactory.getLogger(ServletContextManager.class);
    private static final String REGISTRY_CACHE_NAME = "ApplicationContextCache";
    private static final String WEB_XML_FILE = "/WEB-INF/web.xml";
    private static ServletContextManager instance = null;
    private Cache<String, WebAppContext> mRegistry;
    private ServletContext mContext;
    private boolean initialized = false;
    private CacheService cacheService;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setServletContext(ServletContext servletContext) {
        this.mContext = servletContext;
    }

    protected ServletContextManager() {
    }

    public static synchronized ServletContextManager getInstance() {
        if (instance == null) {
            instance = new ServletContextManager();
        }
        return instance;
    }

    public void start() throws JahiaInitializationException {
        if (!this.initialized) {
            this.mRegistry = this.cacheService.getCache(REGISTRY_CACHE_NAME, true);
            this.initialized = true;
        }
    }

    public WebAppContext getApplicationContext(String id) throws JahiaException {
        logger.debug("Requested application : [" + id + "]");
        ApplicationBean appBean = ServicesRegistry.getInstance().getApplicationsManagerService().getApplicationByContext(id);
        if (appBean == null) {
            String errMsg = "Error getting application bean for application [" + id + "]";
            logger.debug(errMsg);
            throw new JahiaException(errMsg, errMsg, 2, 9);
        }
        return this.getApplicationContext(appBean);
    }

    public WebAppContext getApplicationContext(ApplicationBean appBean) throws JahiaException {
        if (appBean == null) {
            String errMsg = "Error getting application bean for application";
            logger.debug(errMsg);
            throw new JahiaException(errMsg, errMsg, 2, 9);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Requested for context : " + appBean.getContext());
        }
        if (appBean.getContext() == null) {
            return null;
        }
        WebAppContext appContext = this.mRegistry.get(appBean.getContext());
        if (appContext == null) {
            appContext = this.loadContextInfoFromDisk(appBean.getID(), appBean.getContext());
            if (appContext == null) {
                appContext = new WebAppContext(appBean.getContext());
            }
            this.mRegistry.put(appBean.getContext(), appContext);
        }
        return appContext;
    }

    public void removeContextFromCache(String context) {
        this.mRegistry.remove(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebAppContext loadContextInfoFromDisk(String applicationID, String context) {
        Web_App_Xml webXmlDoc;
        ServletContext dispatchedContext = this.mContext.getContext(context);
        if (dispatchedContext == null) {
            logger.error("Error getting dispatch context [" + context + "]");
            return null;
        }
        InputStream is = null;
        try {
            is = dispatchedContext.getResourceAsStream(WEB_XML_FILE);
            webXmlDoc = Web_App_Xml.parse(is);
        }
        catch (Exception e) {
            logger.error("Error during loading of web.xml file for application " + context, (Throwable)e);
            WebAppContext webAppContext = null;
            return webAppContext;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        WebAppContext appContext = new WebAppContext(context, webXmlDoc.getDisplayName(), webXmlDoc.getdesc(), null, webXmlDoc.getServletMappings(), null, webXmlDoc.getWelcomeFiles());
        List<Servlet_Element> servlets = webXmlDoc.getServlets();
        for (int i = 0; i < servlets.size(); ++i) {
            Servlet_Element servlet = servlets.get(i);
            ServletBean servletBean = new ServletBean(applicationID, servlet.getType(), servlet.getDisplayName(), servlet.getName(), servlet.getSource(), context, servlet.getdesc());
            appContext.addServlet(servletBean);
        }
        List<Security_Role> roles = webXmlDoc.getRoles();
        for (int i = 0; i < roles.size(); ++i) {
            Security_Role role = roles.get(i);
            appContext.addRole(role.getName());
        }
        return appContext;
    }
}

