/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAuthValveImpl
extends BaseAuthValve {
    private CookieAuthConfig cookieAuthConfig;
    private static final Logger logger = LoggerFactory.getLogger(CookieAuthValveImpl.class);

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        JCRUserNode jahiaUser;
        AuthValveContext authContext;
        block18: {
            Cookie[] cookies;
            if (!this.isEnabled() || SettingsBean.getInstance().isFullReadOnlyMode()) {
                valveContext.invokeNext(context);
                return;
            }
            logger.debug("Invoking cookie auth...");
            authContext = (AuthValveContext)context;
            jahiaUser = null;
            Cookie[] cookieArray = cookies = this.cookieAuthConfig.isActivated() ? authContext.getRequest().getCookies() : null;
            if (!this.cookieAuthConfig.isActivated()) {
                logger.debug("Cookie auth not activated");
            }
            if (cookies == null) {
                logger.debug("No cookies found");
                valveContext.invokeNext(context);
                return;
            }
            Cookie authCookie = null;
            for (Cookie curCookie : cookies) {
                if (!this.cookieAuthConfig.getCookieName().equals(curCookie.getName())) continue;
                authCookie = curCookie;
                break;
            }
            if (authCookie != null) {
                Properties searchCriterias = new Properties();
                String userPropertyName = this.cookieAuthConfig.getUserPropertyName();
                String value = authCookie.getValue();
                String realm = null;
                if (value.contains(":")) {
                    realm = StringUtils.substringAfter((String)value, (String)":");
                    value = StringUtils.substringBefore((String)value, (String)":");
                }
                if (value.equals("deleted")) {
                    logger.debug("Deleted cookie");
                    valveContext.invokeNext(context);
                    return;
                }
                searchCriterias.setProperty(userPropertyName, value);
                Set<JCRUserNode> foundUsers = null;
                try {
                    logger.debug("Auth cookie found. Searching users...");
                    foundUsers = ServicesRegistry.getInstance().getJahiaUserManagerService().searchUsers(searchCriterias, realm, null, JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null));
                    if (foundUsers.size() == 1) {
                        jahiaUser = foundUsers.iterator().next();
                        if (jahiaUser.isAccountLocked()) {
                            logger.debug("Account locked");
                            jahiaUser = null;
                        } else {
                            HttpSession session = authContext.getRequest().getSession(false);
                            if (session != null) {
                                logger.debug("Attaching user to session");
                                session.setAttribute("org.jahia.usermanager.jahiauser", (Object)jahiaUser.getJahiaUser());
                            }
                            if (this.cookieAuthConfig.isRenewalActivated()) {
                                logger.debug("Renewal activated. Recreating cookie..");
                                CookieAuthValveImpl.sendCookie(value, authContext, jahiaUser, this.cookieAuthConfig);
                            }
                        }
                        break block18;
                    }
                    logger.debug("Creating deleted cookie...");
                    authCookie = new Cookie(this.cookieAuthConfig.getCookieName(), "deleted");
                    authCookie.setPath(StringUtils.isNotEmpty((String)authContext.getRequest().getContextPath()) ? authContext.getRequest().getContextPath() : "/");
                    authCookie.setMaxAge(0);
                    authCookie.setHttpOnly(this.cookieAuthConfig.isHttpOnly());
                    authCookie.setSecure(this.cookieAuthConfig.isSecure());
                    authContext.getResponse().addCookie(authCookie);
                }
                catch (RepositoryException e) {
                    logger.error("Error while searching for users", (Throwable)e);
                }
            } else {
                logger.debug("Cookie auth not found");
            }
        }
        if (jahiaUser == null) {
            logger.debug("No user found");
            valveContext.invokeNext(context);
        } else {
            logger.debug("User found");
            JahiaUser user = jahiaUser.getJahiaUser();
            if (authContext.getRequest().getSession(false) != null) {
                logger.debug("Invalidated session");
                authContext.getRequest().getSession().invalidate();
            }
            authContext.getSessionFactory().setCurrentUser(user);
        }
        logger.debug("Cookie auth invoked");
    }

    public static void createAndSendCookie(AuthValveContext authContext, JCRUserNode theUser, CookieAuthConfig cookieAuthConfig) {
        String cookieUserKey = CookieAuthValveImpl.getAvailableCookieKey(cookieAuthConfig);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, session -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Saving cookie auth for user: {}...", (Object)theUser.getPath());
                }
                JCRUserNode innerUserNode = (JCRUserNode)session.getNode(theUser.getPath());
                innerUserNode.setProperty(cookieAuthConfig.getUserPropertyName(), cookieUserKey);
                session.save();
                return null;
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        CookieAuthValveImpl.sendCookie(cookieUserKey, authContext, theUser, cookieAuthConfig);
    }

    protected static void sendCookie(String cookieUserKey, AuthValveContext authContext, JCRUserNode theUser, CookieAuthConfig cookieAuthConfig) {
        String realm = theUser.getRealm();
        if (realm != null && logger.isDebugEnabled()) {
            logger.debug("Found realm: {}", (Object)realm);
        }
        Cookie authCookie = new Cookie(cookieAuthConfig.getCookieName(), cookieUserKey + (realm != null ? ":" + realm : ""));
        authCookie.setPath(StringUtils.isNotEmpty((String)authContext.getRequest().getContextPath()) ? authContext.getRequest().getContextPath() : "/");
        authCookie.setMaxAge(cookieAuthConfig.getMaxAgeInSeconds());
        authCookie.setHttpOnly(cookieAuthConfig.isHttpOnly());
        authCookie.setSecure(cookieAuthConfig.isSecure());
        authContext.getResponse().addCookie(authCookie);
    }

    public static String getAvailableCookieKey(CookieAuthConfig cookieAuthConfig) {
        return UUID.randomUUID().toString();
    }

    public void setCookieAuthConfig(CookieAuthConfig config) {
        this.cookieAuthConfig = config;
    }

    @Deprecated
    public static String generateRandomString(int length) {
        SecureRandom randomGen = new SecureRandom();
        StringBuilder result = new StringBuilder();
        for (int count = 0; count < length; ++count) {
            int randomSel = randomGen.nextInt(3);
            int randomInt = randomGen.nextInt(26);
            char randomChar = '0';
            switch (randomSel) {
                case 0: {
                    randomChar = (char)(65 + randomInt);
                    break;
                }
                case 1: {
                    randomChar = (char)(97 + randomInt);
                    break;
                }
                case 2: {
                    randomChar = (char)(48 + randomInt % 10);
                }
            }
            result.append(randomChar);
        }
        return result.toString();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setEnabled(this.cookieAuthConfig.isActivated());
    }
}

