/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import org.apache.commons.lang.StringUtils;
import org.jahia.pipelines.Pipeline;
import org.jahia.pipelines.valves.Valve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class BaseAuthValve
implements Valve,
BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(BaseAuthValve.class);
    private String beanName;
    private boolean enabled = true;
    private String id;

    protected static int indexOf(String id, Pipeline authPipeline) {
        Valve[] registeredValves = authPipeline.getValves();
        for (int i = 0; i < registeredValves.length; ++i) {
            Valve v = registeredValves[i];
            if (!(v instanceof BaseAuthValve) || !StringUtils.equals((String)((BaseAuthValve)v).getId(), (String)id)) continue;
            return i;
        }
        return -1;
    }

    protected void addValve(Pipeline authPipeline, Integer position, String positionAfter, String positionBefore) {
        int index = -1;
        if (position >= 0) {
            index = position;
        } else if (positionBefore != null) {
            index = BaseAuthValve.indexOf(positionBefore, authPipeline);
        } else if (positionAfter != null) {
            index = BaseAuthValve.indexOf(positionAfter, authPipeline);
            if (index != -1) {
                ++index;
            }
            if (index >= authPipeline.getValves().length) {
                index = -1;
            }
        }
        if (index != -1) {
            authPipeline.addValve(index, this);
            logger.info("Registered authentication valve {} at position {}", (Object)this.getId(), (Object)index);
        } else {
            authPipeline.addValve(this);
            logger.info("Registered authentication valve {}", (Object)this.getId());
        }
    }

    protected void removeValve(Pipeline authPipeline) {
        Valve[] registeredValves;
        for (Valve v : registeredValves = authPipeline.getValves()) {
            if (!(v instanceof BaseAuthValve) || !StringUtils.equals((String)((BaseAuthValve)v).getId(), (String)this.id)) continue;
            authPipeline.removeValve(v);
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            BaseAuthValve other = (BaseAuthValve)obj;
            return this.getId() != null ? other.getId() != null && this.getId().equals(other.getId()) : other.getId() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void initialize() {
        if (StringUtils.isEmpty((String)this.id)) {
            this.id = this.beanName;
        }
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(String id) {
        this.id = id;
    }
}

