/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.hibernate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaNamingStrategy
extends PhysicalNamingStrategyStandardImpl {
    private static final Logger logger = LoggerFactory.getLogger(JahiaNamingStrategy.class);
    private static final int MAX_LENGTH = 30;
    private static final long serialVersionUID = 2436201913019906777L;
    private static final String VOWELS = "aeiou";
    private static String[] sqlReservedWords = new String[0];

    protected static String addUnderscores(String name) {
        StringBuilder buf = new StringBuilder(name.replace('.', '_'));
        for (int i = 1; i < buf.length() - 1; ++i) {
            if (!Character.isLowerCase(buf.charAt(i - 1)) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, '_');
        }
        return buf.toString().toLowerCase(Locale.ROOT);
    }

    private static String ensureLength(String name) {
        if (name.length() <= 30) {
            return name;
        }
        Object[] tokens = StringUtils.split((String)name, (char)'_');
        JahiaNamingStrategy.shorten(name, (String[])tokens);
        return StringUtils.join((Object[])tokens, (char)'_');
    }

    private static int getIndexOfLongest(String[] tokens) {
        int maxLength = 0;
        int index = -1;
        for (int i = 0; i < tokens.length; ++i) {
            String string = tokens[i];
            if (maxLength >= string.length()) continue;
            maxLength = string.length();
            index = i;
        }
        return index;
    }

    public static boolean isSqlReservedWord(String name) {
        String lowerCaseName = name.toLowerCase();
        for (String reservedWord : sqlReservedWords) {
            if (!reservedWord.equals(lowerCaseName)) continue;
            return true;
        }
        return false;
    }

    public static String prefixSqlReservedWords(String name) {
        if (JahiaNamingStrategy.isSqlReservedWord(name)) {
            return "r_" + name;
        }
        return name;
    }

    public static String processColumnName(String columnName) {
        return JahiaNamingStrategy.ensureLength(JahiaNamingStrategy.processNameCase(JahiaNamingStrategy.prefixSqlReservedWords(JahiaNamingStrategy.addUnderscores(columnName))));
    }

    public static String processNameCase(String name) {
        return name.toLowerCase();
    }

    public static String processTableName(String tableName) {
        return JahiaNamingStrategy.ensureLength(JahiaNamingStrategy.processNameCase("jbpm_" + JahiaNamingStrategy.addUnderscores(tableName)));
    }

    private static void shorten(String someName, String[] tokens) {
        int tokenIndex;
        String oldToken;
        for (int currentLength = someName.length(); currentLength > 30; currentLength -= oldToken.length() - tokens[tokenIndex].length()) {
            tokenIndex = JahiaNamingStrategy.getIndexOfLongest(tokens);
            oldToken = tokens[tokenIndex];
            tokens[tokenIndex] = JahiaNamingStrategy.substringAfterLastVowel(oldToken);
        }
    }

    private static String substringAfterLastVowel(String token) {
        boolean vowelFound = false;
        for (int i = token.length() - 1; i >= 0; --i) {
            boolean isVowel;
            char c = token.charAt(i);
            boolean bl = isVowel = VOWELS.indexOf(c) != -1;
            if (isVowel) {
                vowelFound = true;
                continue;
            }
            if (!vowelFound) continue;
            return token.substring(0, i + 1);
        }
        return "";
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        return Identifier.toIdentifier((String)JahiaNamingStrategy.processTableName(super.toPhysicalTableName(name, context).getText()));
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment context) {
        return Identifier.toIdentifier((String)JahiaNamingStrategy.processColumnName(super.toPhysicalSequenceName(name, context).getText()));
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        return Identifier.toIdentifier((String)JahiaNamingStrategy.processColumnName(super.toPhysicalColumnName(name, context).getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream sqlReservedWordsStream = JahiaNamingStrategy.class.getClassLoader().getResourceAsStream("org/jahia/hibernate/sqlReservedWords.txt");
        if (sqlReservedWordsStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sqlReservedWordsStream));
            String newLine = null;
            ArrayList<String> reservedWordList = new ArrayList<String>();
            try {
                while ((newLine = bufferedReader.readLine()) != null) {
                    reservedWordList.add(newLine.trim().toLowerCase());
                }
                sqlReservedWords = reservedWordList.toArray(new String[reservedWordList.size()]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedReader);
            }
        }
    }
}

